/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.logistics.controller;

import com.qianjiang.freight.bean.SysLogisticsCompany;
import com.qianjiang.freight.service.SysLogisticsCompanyService;
import com.qianjiang.util.KuaiDiUtil;
import com.qianjiang.util.MyLogger;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LogisticsController {
    public static final MyLogger LOGGER = new MyLogger(LogisticsController.class);
    @Resource(name="SysLogisticsCompanyService")
    private SysLogisticsCompanyService sysLogisticsCompanyService;

    @RequestMapping(value={"/selectLogisticsDetail"})
    public ModelAndView selectLogisticsDetail(Long orderId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (orderId != null) {
                SysLogisticsCompany sysLogisticsCompany = this.sysLogisticsCompanyService.selectLogisticsCompanyInfoByOrderId(orderId);
                if (sysLogisticsCompany != null) {
                    String kuaidi100Code = sysLogisticsCompany.getKuaidi100Code();
                    String kuaidi100Name = sysLogisticsCompany.getName();
                    String expressNo = sysLogisticsCompany.getExpressNo();
                    String param = "{\"com\":\"" + kuaidi100Code + "\",\"num\":\"" + expressNo + "\"}";
                    List<Map<Object, Object>> logisticsInfo = KuaiDiUtil.getKuaiDiInfo4Firm(param);
                    if (logisticsInfo != null && !logisticsInfo.isEmpty()) {
                        mav.addObject("logisticsInfo", logisticsInfo);
                        mav.addObject("kuaidi100Name", (Object)kuaidi100Name);
                        mav.addObject("expressNo", (Object)expressNo);
                    } else {
                        mav.addObject("logisticsInfo", logisticsInfo);
                    }
                }
            } else {
                LOGGER.error("\u4f20\u9012\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7269\u6d41\u8be6\u60c5\u5931\u8d25" + e.getMessage());
        }
        mav.setViewName("jsp/order/logisticsdetail");
        return mav;
    }
}

