/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.mobile.bean.MobCateBar;
import com.qianjiang.mobile.service.MobCateBarService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MobCateBarController {
    private static final String MOB_STORELIST_STREET = "jsp/mobile/mob_storelist_street";
    private static final String QUERY_MOB_CATE_BAR_BY_PB = "queryMobCateBarByPb.htm";
    private static final String GRADE = "grade";
    @Resource(name="MobCateBarService")
    private MobCateBarService mobCateBarService;
    @Resource(name="ChannelGoodsCateService")
    private GoodsCateService goodsCateService;
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";

    @RequestMapping(value={"/storeliststreetimage"})
    public ModelAndView storeliststreetimage(PageBean pb) {
        return new ModelAndView(MOB_STORELIST_STREET).addObject("pb", (Object)this.mobCateBarService.selectStoreListImageByPages(pb, null));
    }

    @RequestMapping(value={"/storelistqianggouimage"})
    public ModelAndView storelistqianggouimage(PageBean pb) {
        this.mobCateBarService.selectStoreListQianggouImage(pb);
        return new ModelAndView("jsp/mobile/mob_storelist_qianggou").addObject("pb", (Object)pb);
    }

    @RequestMapping(value={"/queryMobCateBarByPb"})
    public ModelAndView queryMobCateBarByPb(PageBean pb, ModelMap model) {
        pb = this.mobCateBarService.selectMobCateBarByPb(pb);
        model.put((Object)"pageBean", (Object)pb);
        model.put((Object)"rows", (Object)JSONArray.fromObject((Object)pb.getList()));
        return new ModelAndView("jsp/mobile/mobcatebar_list", (Map)model);
    }

    @RequestMapping(value={"/showMobCateBar"})
    public ModelAndView showMobCateBar(Long mobCateBarId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String pageNo = request.getParameter("pageNo");
        if (null != mobCateBarId) {
            MobCateBar cate = this.mobCateBarService.selectMobcateBarById(mobCateBarId);
            mav.addObject("mobcatebar", (Object)cate);
            mav.addObject(GRADE, (Object)cate.getGrade());
            mav.addObject("pageNo", (Object)pageNo);
        } else {
            mav.addObject(GRADE, (Object)1);
        }
        mav.setViewName("jsp/mobile/show_mobcatebar");
        return mav;
    }

    @RequestMapping(value={"/showNewMobCateBar"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public MobCateBar showNewMobCateBar(Long mobCateBarId) {
        return this.mobCateBarService.selectMobcateBarById(mobCateBarId);
    }

    @RequestMapping(value={"/showMobCateBarByParentId"})
    public ModelAndView showMobCateBarByParentId(Long mobCateBarId, Long parentId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        if (null != mobCateBarId) {
            mav.addObject("mobcatebar", (Object)this.mobCateBarService.selectMobcateBarById(mobCateBarId));
        }
        String pageNo = request.getParameter("pageNo");
        MobCateBar parent = this.mobCateBarService.selectMobcateBarById(parentId);
        mav.addObject("parent", (Object)parent);
        mav.addObject("cateList", (Object)this.goodsCateService.queryGoosCateByParentId(parent.getCateId()));
        mav.addObject(GRADE, (Object)(parent.getGrade() + 1));
        mav.setViewName("jsp/mobile/show_mobcatebar");
        mav.addObject("pageNo", (Object)pageNo);
        return mav;
    }

    @RequestMapping(value={"/createMobCateBar"})
    public ModelAndView createMobCateBar(@Valid MobCateBar mobCateBar, BindingResult bindingResult, MultipartHttpServletRequest request) {
        MultipartFile muFile;
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERY_MOB_CATE_BAR_BY_PB));
        }
        if (null == mobCateBar.getTemp2()) {
            mobCateBar.setTemp2("0");
        }
        if (null == mobCateBar.getTemp3()) {
            mobCateBar.setTemp3("0");
        }
        if (null != (muFile = request.getFile("imageSrc")) && muFile.getSize() > 0L) {
            mobCateBar.setImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        this.setParentIdAndGrade(mobCateBar);
        this.mobCateBarService.createMobCateBar(mobCateBar);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u79fb\u52a8\u7248\u5206\u7c7b\u5bfc\u822a", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(QUERY_MOB_CATE_BAR_BY_PB));
    }

    @RequestMapping(value={"/updateMobCateBar"})
    public ModelAndView updateMobCateBar(@Valid MobCateBar mobCateBar, BindingResult bindingResult, MultipartHttpServletRequest request) {
        MultipartFile muFile;
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERY_MOB_CATE_BAR_BY_PB));
        }
        if (null == mobCateBar.getTemp2()) {
            mobCateBar.setTemp2("0");
        }
        if (null == mobCateBar.getTemp3()) {
            mobCateBar.setTemp3("0");
        }
        if (null != (muFile = request.getFile("imageSrc")) && muFile.getSize() > 0L) {
            mobCateBar.setImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        this.setParentIdAndGrade(mobCateBar);
        this.mobCateBarService.updateMobCateBar(mobCateBar);
        String pageNo = request.getParameter("pageNo");
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u5206\u7c7b\u5bfc\u822a", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(QUERY_MOB_CATE_BAR_BY_PB));
    }

    @RequestMapping(value={"/changeMobCateBarUserdStatus"})
    public ModelAndView changeMobCateBarUserdStatus(Long mobCateBarId, HttpServletRequest request) {
        this.mobCateBarService.changeUserdStatus(mobCateBarId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u5206\u7c7b\u5bfc\u822a\u542f\u7528\u72b6\u6001", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(QUERY_MOB_CATE_BAR_BY_PB));
    }

    private void setParentIdAndGrade(MobCateBar mobCateBar) {
        if (null == mobCateBar.getParentId()) {
            mobCateBar.setParentId(Long.valueOf(0L));
        }
        if (mobCateBar.getParentId() == 0L) {
            mobCateBar.setGrade(Integer.valueOf(1));
        }
    }

    @RequestMapping(value={"/deleteMobCateBar"})
    public ModelAndView deleteMobCateBar(Long mobCateBarId, HttpServletRequest request) {
        if (null != mobCateBarId && mobCateBarId != 0L) {
            this.mobCateBarService.deleteMobCateBar(mobCateBarId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u79fb\u52a8\u7248\u5206\u7c7b\u5bfc\u822a", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(QUERY_MOB_CATE_BAR_BY_PB));
    }

    @ResponseBody
    @RequestMapping(value={"/checkMobCateBarIsOnly"}, produces={"application/json;charset=UTF-8"})
    public boolean checkMobCateBarIsOnly(Long cateId) {
        return this.mobCateBarService.checkMobCateBarIsOnly(cateId);
    }

    @ResponseBody
    @RequestMapping(value={"/checkDele"}, produces={"application/json;charset=UTF-8"})
    public boolean checkDele(Long mobCateBarId) {
        return this.mobCateBarService.checkDelete(mobCateBarId);
    }
}

