/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempBrandController {
    private static final MyLogger LOGGER = new MyLogger(TempBrandController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String QUERYTEMPTRADEMARKBYPAGEBEAN_HTM = "queryTempTrademarkByPageBean.htm?tempId=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private TempService tempService;
    private ChannelTrademarkService channelTrademarkService;

    @RequestMapping(value={"/queryTempTrademarkByPageBean"})
    public ModelAndView queryTempTrademarkByPageBean(PageBean pb, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        return new ModelAndView("jsp/temp/temp_trademark_list", "pb", (Object)this.channelTrademarkService.selectchannelTrademarkByParam(pb, null, tempId, null, null, null, null)).addObject("temp", (Object)temp);
    }

    @RequestMapping(value={"/showTempTrademark"})
    public ModelAndView showTempTrademark(Long trademarkId, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("temp", temp);
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        return new ModelAndView("jsp/temp/show_temp_trademark", "map", map);
    }

    @RequestMapping(value={"/createTempTrademark"})
    public ModelAndView createTempTrademark(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYTEMPTRADEMARKBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setCreateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setCreateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYTEMPTRADEMARKBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/modifTempTrademark"})
    public ModelAndView updateTempTrademark(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYTEMPTRADEMARKBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setUpdateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYTEMPTRADEMARKBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/delTempTrademark"})
    public void deleteTempTrademark(HttpServletRequest request, HttpServletResponse response) {
        String[] trademarkIds = request.getParameterValues("trademarkIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(Long.valueOf(trademarkIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6a21\u677f\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public ChannelTrademarkService getChannelTrademarkService() {
        return this.channelTrademarkService;
    }

    @Resource(name="ChannelTrademarkService")
    public void setChannelTrademarkService(ChannelTrademarkService channelTrademarkService) {
        this.channelTrademarkService = channelTrademarkService;
    }
}

