/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.AreaPackage;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.IAreaPackageBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="areaPackageController")
public class AreaPackageController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(AreaPackageController.class);
    private AreaPackage areaPackage;
    private IAreaPackageBiz areaPackageBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    private IDictionarysCache dictionarysCache;
    private static final String INIT_AREAPACKAGE = "initAreaPackage.htm";
    private static final String ADD_AREAPACKAGE_JSP = "jsp/system/area/areapackage_add";
    private static final String AREAPACKAGE_LIST_JSP = "jsp/system/area/areapackage_list";
    private static final String UPDATE_AREAPACKAGE_JSP = "jsp/system/area/areapackage_update";
    private static final String READ_AREAPACKAGE_JSP = "jsp/system/area/areapackage_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String AREAPACKAGE = "areaPackage";
    private static final String IDS = "ids";
    private static final String AREA = "area";

    @RequestMapping(value={"/initAreaPackage"})
    public ModelAndView initAreaPackage(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        pageBean.setUrl(INIT_AREAPACKAGE);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(AREAPACKAGE_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject("pageBean", (Object)this.areaPackageBizImpl.getAreaPackageByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.areaPackageBizImpl.getAreaPackageByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddAreaPackagePage"})
    public ModelAndView openAddAreaPackagePage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_AREAPACKAGE_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addAreaPackage"})
    public ModelAndView addAreaPackage(AreaPackage areaPackage, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            areaPackage.setInsertDate(new Date());
            areaPackage.setInsertId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            areaPackage.setDeleteStatus(0);
            boolean flag = this.areaPackageBizImpl.saveAreaPackage(areaPackage);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backAddPage(areaPackage, mav);
            }
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u5730\u533a\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backAddPage(areaPackage, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(AreaPackage areaPackage, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(AREAPACKAGE, (Object)areaPackage);
        mav.setViewName(ADD_AREAPACKAGE_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateAreaPackagePage"})
    public ModelAndView openUpdateAreaPackagePage(@RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(AREAPACKAGE, (Object)this.areaPackageBizImpl.getAreaPackageById(id.intValue()));
            mav.setViewName(UPDATE_AREAPACKAGE_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/selectAreaPackageById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public AreaPackage selectAreaPackageById(Integer areaPackageId) {
        return this.areaPackageBizImpl.getAreaPackageById(areaPackageId.intValue());
    }

    @RequestMapping(value={"/updateAreaPackage"})
    public ModelAndView updateAreaPackage(AreaPackage areaPackage, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            areaPackage.setModifyDate(new Date());
            areaPackage.setModifyId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            if (this.areaPackageBizImpl.updateAreaPackage(areaPackage) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backUpdatePage(areaPackage, mav);
            }
            mav.addObject(MSG, (Object)"\u4fee\u6539\u5730\u533a\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backUpdatePage(areaPackage, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(AreaPackage areaPackage, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(AREAPACKAGE, (Object)areaPackage);
        mav.setViewName(UPDATE_AREAPACKAGE_JSP);
        return mav;
    }

    @RequestMapping(value={"/readAreaPackage"})
    public ModelAndView readAreaPackage(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        } else {
            mav.setViewName(READ_AREAPACKAGE_JSP);
            mav.addObject(AREAPACKAGE, (Object)this.areaPackageBizImpl.getAreaPackageById(id.intValue()));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteAreaPackage"})
    public ModelAndView deleteAreaPackage(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.areaPackageBizImpl.deleteAreaPackage(ids) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.areaPackageBizImpl.updateAreaPackageFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreAreaPackage"})
    public ModelAndView restoreAreaPackage(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.areaPackageBizImpl.updateAreaPackageFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u5730\u533a\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/deleteAreaPackageOne"})
    public ModelAndView deleteAreaPackageOne(Integer areaPackageId) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        this.areaPackageBizImpl.deleteById(areaPackageId);
        return mav;
    }

    @RequestMapping(value={"/deleteAreaPackageBatch"})
    public ModelAndView deleteAreaPackageBatch(Integer[] areaPackageIds) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_AREAPACKAGE));
        for (Integer areaPackageId : areaPackageIds) {
            this.areaPackageBizImpl.deleteById(areaPackageId);
        }
        return mav;
    }

    @RequestMapping(value={"/queryAreaPackage"})
    public ModelAndView queryAreaPackage(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="area", required=false, defaultValue="") String area, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (area != null && area.trim().length() != 0) {
            param.put(AREA, area);
            queryParam.put(AREA, area);
            queryParam.put("searchField", AREA);
            queryParam.put("searchValue", area);
            queryParam.put("searchName", "\u5730\u533a\u8bbe\u7f6e");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(AREAPACKAGE_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject("pageBean", (Object)this.areaPackageBizImpl.getAreaPackageByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5730\u533a\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
    }

    public AreaPackage getAreaPackage() {
        return this.areaPackage;
    }

    @Resource(name="areaPackage")
    public void setAreaPackage(AreaPackage areaPackage) {
        this.areaPackage = areaPackage;
    }

    public IAreaPackageBiz getAreaPackageBizImpl() {
        return this.areaPackageBizImpl;
    }

    @Resource(name="areaPackageBizImpl")
    public void setAreaPackageBizImpl(IAreaPackageBiz areaPackageBizImpl) {
        this.areaPackageBizImpl = areaPackageBizImpl;
    }

    public IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }
}

