/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PageTagController {
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    private static final String CSRFTOKEN = "CSRFToken";
    private static final String CSRFTOKENSTRING = "&CSRFToken=";
    private static final String USERNAME = ",\u7528\u6237\u540d:";
    public static final String OPERAPATH = "operaPath";
    private static final String QUERYPAGETAGBYPAGEBEAN_TEMPID = "queryPageTagByPageBean.htm?tempId=";
    private static final String QUERYPAGETAGBYPAGEBEAN_CHANNELID = "queryPageTagByPageBean.htm?channelId=";
    private static final String LOGGERINFO1 = "\u5220\u9664\u9875\u9762\u6807\u7b7e";
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    @Resource(name="ChannelStoreyTagService")
    private ChannelStoreyTagService channelStoreyTagService;

    @RequestMapping(value={"/queryPageTagByPageBean"})
    public ModelAndView queryPageTagByPageBean(PageBean pb, Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        mav.addObject("pb", (Object)this.channelStoreyTagService.selectchannelStoreyTagByParam(pb, null, tempId, channelId));
        mav.addObject("tempId", (Object)tempId);
        mav.addObject("channelId", (Object)channelId);
        mav.setViewName("jsp/channel/page_tag_list");
        return mav;
    }

    @RequestMapping(value={"/querypagetagbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryPageTagByPageBeanAjax(PageBean pb, Long tempId, Long channelId, Long storeyId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelStoreyTagService.selectchannelStoreyTagByParam(pb, storeyId, tempId, channelId));
        return map;
    }

    @RequestMapping(value={"/showPageTag"})
    public ModelAndView showPageTag(Long tagId, Long tempId, Long channelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == channelId) {
            SysTemp temp = this.tempService.getSystempById(tempId);
            map.put("temp", temp);
        } else {
            Channel channel = this.channelService.findChannelByID(channelId);
            map.put("channel", channel);
        }
        if (null != tagId) {
            ChannelStoreyTag channelStoreyTag = this.channelStoreyTagService.getChannelStoreyTagById(tagId);
            map.put("channelStoreyTag", channelStoreyTag);
        }
        return new ModelAndView("jsp/channel/show_page_tag", "map", map);
    }

    @RequestMapping(value={"/showpagetagajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStoreyTag showPageTagAjax(Long tagId, Long tempId, Long channelId) {
        return this.channelStoreyTagService.getChannelStoreyTagById(tagId);
    }

    @RequestMapping(value={"/createPageTag"})
    public ModelAndView createPageTag(HttpServletRequest request, @Valid ChannelStoreyTag channelStoreyTag, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            if (null == channelId) {
                return new ModelAndView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_TEMPID + tempId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
            }
            return new ModelAndView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_CHANNELID + channelId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        channelStoreyTag.setCreateUserId(loginUserId);
        this.channelStoreyTagService.saveChannelStoreyTag(channelStoreyTag);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9875\u9762\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        if (null == channelId) {
            mav.setView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_TEMPID + tempId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        } else {
            mav.setView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_CHANNELID + channelId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        }
        return mav;
    }

    @RequestMapping(value={"/createpagetagajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createPageTagAjax(HttpServletRequest request, @Valid ChannelStoreyTag channelStoreyTag, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channelStoreyTag.setCreateUserId(loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9875\u9762\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return this.channelStoreyTagService.saveChannelStoreyTag(channelStoreyTag);
    }

    @RequestMapping(value={"/updatePageTag"})
    public ModelAndView updatePageTag(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyTag channelStoreyTag, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            if (null == channelId) {
                return new ModelAndView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_TEMPID + tempId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
            }
            return new ModelAndView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_CHANNELID + channelId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        channelStoreyTag.setUpdateUserId(loginUserId);
        this.channelStoreyTagService.updateChannelStoreyTag(channelStoreyTag);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9875\u9762\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        if (null == channelId) {
            mav.setView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_TEMPID + tempId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        } else {
            mav.setView((View)new RedirectView(QUERYPAGETAGBYPAGEBEAN_CHANNELID + channelId + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        }
        return mav;
    }

    @RequestMapping(value={"/updatepagetagajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updatePageTagAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyTag channelStoreyTag, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        channelStoreyTag.setUpdateUserId(loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9875\u9762\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return this.channelStoreyTagService.updateChannelStoreyTag(channelStoreyTag);
    }

    @RequestMapping(value={"/deletePageTag"})
    public void deletePageTag(HttpServletRequest request, HttpServletResponse response) {
        String[] tagIds = request.getParameterValues("tagIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < tagIds.length; ++i) {
            this.channelStoreyTagService.deleteChannelStoreyTag(Long.valueOf(tagIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO1, (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
    }

    @RequestMapping(value={"/deletepagetagajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deletePageTagAjax(HttpServletRequest request, HttpServletResponse response) {
        String[] tagIds = request.getParameterValues("tagId");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < tagIds.length; ++i) {
            this.channelStoreyTagService.deleteChannelStoreyTag(Long.valueOf(tagIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO1, (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
    }

    @RequestMapping(value={"/deletePageTagPro"})
    public void deletePageTagPro(HttpServletRequest request, HttpServletResponse response) {
        String[] tagIds = request.getParameterValues("tagIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < tagIds.length; ++i) {
            this.channelStoreyTagService.deleteByPrimaryKeyCallPro(Long.valueOf(tagIds[i]));
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO1, (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
    }
}

