/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.push.controller;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.push.util.JPushUtil;
import com.qianjiang.util.MyLogger;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class JPushController {
    private static final MyLogger LOGGER = new MyLogger(JPushController.class);
    private static final String appKey = "83e6242fd1658bfb0d938a7f";
    private static final String masterSecret = "ba4fa1699ec9b7e2c24f598c";
    private static long timeToLive = 86400L;
    private static JPushClient jPushClient = null;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="OrderService")
    private OrderService orderService;

    public String sendPushAll(String msg) {
        jPushClient = new JPushClient(masterSecret, appKey);
        try {
            PushPayload payload = JPushUtil.buildPushObject_all_alias_alert("alias", msg);
            PushResult result = jPushClient.sendPush(payload);
            LOGGER.info((Object)("\u8fd4\u56de\u6570\u636e\uff1a" + result));
        }
        catch (APIConnectionException e) {
            LOGGER.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOGGER.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOGGER.info((Object)("HTTP Status: " + e.getStatus()));
            LOGGER.info((Object)("Error Code: " + e.getErrorCode()));
            LOGGER.info((Object)("Error Message: " + e.getErrorMessage()));
            LOGGER.info((Object)("Msg ID: " + e.getMsgId()));
        }
        return "success";
    }

    @RequestMapping(value={"/sendPushAll"})
    public int sendToRegistrationId(HttpServletRequest request, String title, String url, Long orderId) {
        LOGGER.info((Object)("\u9875\u9762\u8df3\u8f6c\u5730\u5740\uff1a" + url));
        int result = 0;
        jPushClient = new JPushClient(masterSecret, appKey);
        if (null == title || null == url || null == orderId) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        Long customerId = this.orderService.selectCustomerIdByOrderId(orderId);
        Customer customer = this.customerService.selectCustomerByCustomerId(customerId);
        if (customer != null && !"".equals(customer.getIosRegistrationId())) {
            try {
                PushPayload pushPayload = JPushUtil.buildPushObject_all_ios_notification(customer.getIosRegistrationId(), title, url);
                PushResult pushResult = jPushClient.sendPush(pushPayload);
                if (pushResult.getResponseCode() == 200) {
                    result = 1;
                    return result;
                }
            }
            catch (APIConnectionException e) {
                e.printStackTrace();
            }
            catch (APIRequestException e) {
                e.printStackTrace();
            }
        } else if (customer != null && !"".equals(customer.getAndroidRegistrationId())) {
            try {
                PushPayload pushPayload = JPushUtil.buildPushObject_all_android_notification(customer.getIosRegistrationId(), title, url);
                PushResult pushResult = jPushClient.sendPush(pushPayload);
                if (pushResult.getResponseCode() == 200) {
                    result = 1;
                    return result;
                }
            }
            catch (APIConnectionException e) {
                e.printStackTrace();
            }
            catch (APIRequestException e) {
                e.printStackTrace();
            }
        } else {
            result = 0;
            LOGGER.error("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8bbe\u5907id");
        }
        return result;
    }

    public int sendToRegistrationId(String registrationId, String title, String url) {
        int result = 0;
        jPushClient = new JPushClient(masterSecret, appKey);
        try {
            PushPayload pushPayload = JPushUtil.buildPushObject_all_ios_notification(registrationId, title, url);
            System.out.println(pushPayload);
            PushResult pushResult = jPushClient.sendPush(pushPayload);
            System.out.println(pushResult);
            if (pushResult.getResponseCode() == 200) {
                result = 1;
            }
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        JPushController c = new JPushController();
        int result = c.sendToRegistrationId("161a3797c857abb748d", "\u6536\u5230\u4e00\u6761\u4fe1\u606f", "\u60a8\u7684\u8ba2\u5355\u5df2\u7ecf\u6210\u529f\u53d1\u8d27\uff01");
        System.out.println(result);
    }
}

