/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelTrademarkController {
    private static final MyLogger LOGGER = new MyLogger(ChannelTrademarkController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_ACTION = "showChannelTrademark.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYCHANNELTRADEMARKBYPAGEBEAN_HTM = "queryChannelTrademarkByPageBean.htm?channelId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    private ChannelTrademarkService channelTrademarkService;

    @RequestMapping(value={"/queryChannelTrademarkByPageBean"})
    public ModelAndView queryChannelTrademarkByPageBean(PageBean pb, Long channelId, HttpServletRequest request) {
        Channel channel = this.channelService.findChannelByID(channelId);
        return new ModelAndView("jsp/channel/channel_Trademark_list", "pb", (Object)this.channelTrademarkService.selectchannelTrademarkByParam(pb, channelId, channel.getTempId(), null, null, null, null)).addObject("channel", (Object)channel);
    }

    @RequestMapping(value={"/showChannelTrademark"})
    public ModelAndView showChannelTrademark(Long trademarkId, Long channelId) {
        Channel channel = this.channelService.findChannelByID(channelId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", channel);
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        return new ModelAndView("jsp/channel/showChannelTrademark", "map", map);
    }

    @RequestMapping(value={"/createChannelTrademark"})
    public ModelAndView createChannelTrademark(HttpServletRequest request, HttpServletResponse response, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELTRADEMARKBYPAGEBEAN_HTM + channelId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setCreateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setCreateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
            mav.addObject("channelId", (Object)channelId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9891\u9053\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(QUERYCHANNELTRADEMARKBYPAGEBEAN_HTM + channelId + "&CSRFToken=" + request.getParameter("CSRFToken")));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/updateChannelTrademark"})
    public ModelAndView updateChannelTrademark(HttpServletRequest request, HttpServletResponse response, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELTRADEMARKBYPAGEBEAN_HTM + channelId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setUpdateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
            mav.addObject("channelId", (Object)channelId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9891\u9053\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(QUERYCHANNELTRADEMARKBYPAGEBEAN_HTM + channelId + "&CSRFToken=" + request.getParameter("CSRFToken")));
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteChannelTrademark"})
    public void deleteChannelTrademark(HttpServletRequest request, HttpServletResponse response) {
        String[] trademarkIds = request.getParameterValues("trademarkIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(Long.valueOf(trademarkIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9891\u9053\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelTrademarkService getChannelTrademarkService() {
        return this.channelTrademarkService;
    }

    @Resource(name="ChannelTrademarkService")
    public void setChannelTrademarkService(ChannelTrademarkService channelTrademarkService) {
        this.channelTrademarkService = channelTrademarkService;
    }
}

