/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.controller;

import com.qianjiang.manager.bean.Page;
import com.qianjiang.manager.bean.valuebean.MenuVo;
import com.qianjiang.manager.service.MenuServiceInterface;
import com.qianjiang.manager.service.PageServiceInterface;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import com.qianjiang.util.UploadUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PageController {
    private PageServiceInterface pageserviceInterface;
    private MenuServiceInterface menuServiceInterface;
    private static final MyLogger LOGGER = new MyLogger(PageController.class);

    @RequestMapping(value={"/delPage"})
    public ModelAndView delPage(Long pageId, String active) {
        Page page;
        if (null != pageId && null != (page = this.pageserviceInterface.queryPageByPrimaryKey(pageId)).getDesignation()) {
            LOGGER.info((Object)("\u5220\u9664\u3010" + page.getDesignation() + "\u3011\u9875\u9762"));
        }
        this.pageserviceInterface.delPage(pageId);
        if (active != null) {
            return new ModelAndView((View)new RedirectView("initSetting.htm?active=0"));
        }
        return new ModelAndView((View)new RedirectView("jumpForPageView.htm"));
    }

    @RequestMapping(value={"/batchDelPage"})
    public ModelAndView batchDelPage(Long[] pageIds, String active, Long pageId) {
        if (active == null) {
            this.pageserviceInterface.batchDelPage(pageIds);
            return new ModelAndView((View)new RedirectView("jumpForPageView.htm"));
        }
        this.pageserviceInterface.newBatchDelPage(pageId);
        return new ModelAndView((View)new RedirectView("initSetting.htm?active=0"));
    }

    @RequestMapping(value={"/savePage"})
    public ModelAndView savePage(Page page, String active, MultipartHttpServletRequest multipartRequest, HttpServletRequest request) {
        if (null != page.getDesignation()) {
            LOGGER.info((Object)("\u589e\u52a0\u3010" + page.getDesignation() + "\u3011\u9875\u9762"));
        }
        this.pageserviceInterface.savePage(page);
        if (active != null) {
            return new ModelAndView((View)new RedirectView("initSetting.htm?active=0"));
        }
        return new ModelAndView((View)new RedirectView("jumpForPageView.htm"));
    }

    public void setPageImgUrl1(Page page, HttpServletRequest request, MultipartHttpServletRequest multipartRequest) {
        String imgUrl = "";
        String imgUrlSelected = "";
        if (multipartRequest.getFile("imgurl") != null && !"".equals(multipartRequest.getFile("imgurl").getOriginalFilename())) {
            imgUrl = UploadUtil.uploadFileOne((MultipartFile)multipartRequest.getFile("imgurl"), (HttpServletRequest)request);
        }
        if (multipartRequest.getFile("imgurlselected") != null && !"".equals(multipartRequest.getFile("imgurlselected").getOriginalFilename())) {
            imgUrlSelected = UploadUtil.uploadFileOne((MultipartFile)multipartRequest.getFile("imgurlselected"), (HttpServletRequest)request);
        }
        page.setImgUrl(imgUrl);
        page.setImgUrlSelected(imgUrlSelected);
    }

    @RequestMapping(value={"/updatePage"})
    public ModelAndView updatePage(Page page, String active, MultipartHttpServletRequest multipartRequest, HttpServletRequest request) {
        if (null != page.getDesignation()) {
            LOGGER.info((Object)("\u66f4\u65b0\u3010" + page.getDesignation() + "\u3011\u9875\u9762"));
        }
        this.pageserviceInterface.updatePage(page);
        if (active != null) {
            return new ModelAndView((View)new RedirectView("initSetting.htm?active=0"));
        }
        return new ModelAndView((View)new RedirectView("jumpForPageView.htm"));
    }

    @RequestMapping(value={"/queryPageById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Page queryPageById(Long pageId) {
        Page page = this.pageserviceInterface.queryPageByPrimaryKey(pageId);
        if (null != page.getDesignation()) {
            LOGGER.info((Object)("\u83b7\u53d6\u3010" + page.getDesignation() + "\u3011\u9875\u9762\u7684\u4fe1\u606f"));
        }
        return page;
    }

    @RequestMapping(value={"/checkDelPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkDel(Long pageId) {
        return this.pageserviceInterface.checkDelWithPageId(pageId);
    }

    @RequestMapping(value={"/queryAllMenuVo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<MenuVo> queruAllPage() {
        return this.pageserviceInterface.queryAllMenuVo();
    }

    @RequestMapping(value={"/queryMenuVoList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryMenuVoList(PageBean pb, SelectBean selectBean) throws UnsupportedEncodingException {
        pb.setList(this.pageserviceInterface.getCateList(pb, selectBean));
        return pb;
    }

    @RequestMapping(value={"/jumpForPageView"})
    public ModelAndView jumpForPageView() {
        return new ModelAndView("jsp/core/manager/menu_list");
    }

    @RequestMapping(value={"/queryAllMenu"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<MenuVo> queryAllMenu() {
        return this.menuServiceInterface.getAllMenu();
    }

    @RequestMapping(value={"/queryAllMenuByLogin"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<MenuVo> queryAllMenuByLogin(HttpServletRequest request) {
        return this.menuServiceInterface.getAllMenuByLogin((Long)request.getSession().getAttribute("loginUserId"));
    }

    public MenuServiceInterface getMenuServiceInterface() {
        return this.menuServiceInterface;
    }

    @Resource(name="menuServiceInterface")
    public void setMenuServiceInterface(MenuServiceInterface menuServiceInterface) {
        this.menuServiceInterface = menuServiceInterface;
    }

    public PageServiceInterface getPageserviceInterface() {
        return this.pageserviceInterface;
    }

    @Resource(name="PageService")
    public void setPageserviceInterface(PageServiceInterface pageserviceInterface) {
        this.pageserviceInterface = pageserviceInterface;
    }
}

