/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.ErrorPage;
import com.qianjiang.system.service.ErrorPageService;
import com.qianjiang.util.PageBean;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ErrorPageController {
    private ErrorPageService errorPageService;

    public ErrorPageService getErrorPageService() {
        return this.errorPageService;
    }

    @Resource(name="ErrorPageService")
    public void setErrorPageService(ErrorPageService errorPageService) {
        this.errorPageService = errorPageService;
    }

    @RequestMapping(value={"/queryErrorPagesByPageBean"})
    public ModelAndView queryErrorPagesByPageBean(PageBean pb) {
        return new ModelAndView("jsp/system/errorPageList", "pb", (Object)this.errorPageService.queryErrorPageByPageBean(pb));
    }

    @RequestMapping(value={"/showErrorPage"})
    public ModelAndView showErrorPage(Long errorPageId) {
        ErrorPage errorPage = new ErrorPage();
        if (null != errorPageId) {
            errorPage = this.errorPageService.getErrorPage(errorPageId);
        }
        return new ModelAndView("jsp/system/showErrorPage", "errorPage", (Object)errorPage);
    }

    @RequestMapping(value={"/addErrorPage"})
    public ModelAndView addErrorPage(ErrorPage errorPage) {
        errorPage.setDelflag("0");
        errorPage.setCreateUserId(Long.valueOf(1L));
        errorPage.setCreateDate(new Date());
        this.errorPageService.saveErrorPage(errorPage);
        return new ModelAndView((View)new RedirectView("queryErrorPagesByPageBean.htm"));
    }

    @RequestMapping(value={"/updateErrorPage"})
    public ModelAndView updateErrorPage(ErrorPage errorPage) {
        errorPage.setUpdateUserId(Long.valueOf(1L));
        errorPage.setUpdateDate(new Date());
        this.errorPageService.updateErrorPage(errorPage);
        return new ModelAndView((View)new RedirectView("queryErrorPagesByPageBean.htm"));
    }

    @RequestMapping(value={"/delErrorPage"})
    public void delErrorPage(HttpServletRequest request, HttpServletResponse response) {
        String[] ids = request.getParameterValues("errorPageIds[]");
        for (int i = 0; i < ids.length; ++i) {
            Long id = Long.valueOf(ids[i]);
            this.errorPageService.delErrorPage(id);
        }
    }
}

