/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.ImageSet;
import com.qianjiang.system.service.ImageSetService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ImageSetController {
    private static final MyLogger LOGGER = new MyLogger(ImageSetController.class);
    @Resource(name="imageSetService")
    private ImageSetService imageSetService;
    private String page = "imageset.htm";

    @RequestMapping(value={"/imageset"})
    public ModelAndView imageSet(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/imagesetup", "pb", (Object)this.imageSetService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/addimageset"})
    public ModelAndView addImageSet(HttpServletRequest request, HttpServletResponse response, ImageSet imageSet) {
        this.imageSetService.insertImageSet(imageSet);
        return new ModelAndView((View)new RedirectView(this.page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/delimageset"})
    public ModelAndView delImageSet(HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter pr = null;){
            pr = response.getWriter();
            pr.print(this.imageSetService.deleteImageSet(request.getParameterValues("ruleIds[]")));
        }
        return null;
    }

    @RequestMapping(value={"/updateimageset"})
    public ModelAndView updateImageSet(HttpServletRequest request, HttpServletResponse response, ImageSet imageSet) {
        this.imageSetService.updateImageSet(imageSet);
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/findone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ImageSet findOne(Long ruleId) {
        return this.imageSetService.findByRuleId(ruleId);
    }
}

