/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempAdverController {
    private static final MyLogger LOGGER = new MyLogger(TempAdverController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYTEMPADVERBYPAGEBEAN_HTM = "queryTempAdverByPageBean.htm?tempId=";
    public static final String ADVERTYPE = "&adverType=";
    public static final String ATID = "&atId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private TempService tempService;
    private ChannelAdverService channelAdverService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryTempAdverByPageBean"})
    public ModelAndView queryTempAdverByPageBean(PageBean pb, Long tempId, Long atId, Long adverType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        map.put("temp", temp);
        map.put("pb", this.channelAdverService.selectchannelAdverByParam(pb, null, tempId, null, null, atId, adverType, null, null));
        map.put("atId", atId);
        map.put("adverType", adverType);
        return new ModelAndView("jsp/temp/temp_adver_list", "map", map);
    }

    @RequestMapping(value={"/querytempadverbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryTempAdverByPageBeanAjax(PageBean pb, Long tempId, Long atId, Long adverType, Long storeyTagId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelAdverService.selectchannelAdverByParam(pb, null, tempId, null, storeyTagId, atId, adverType, null, null));
        map.put("atId", atId);
        return map;
    }

    @RequestMapping(value={"/showTempAdver"})
    public ModelAndView showTempAdver(Long channelAdverId, Long tempId, Long atId, Long adverType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        map.put("temp", temp);
        map.put("atId", atId);
        map.put("adverType", adverType);
        if (null != channelAdverId) {
            ChannelAdver channelAdver = this.channelAdverService.selectByPrimaryKey(channelAdverId);
            map.put("channelAdver", channelAdver);
        }
        return new ModelAndView("jsp/temp/show_temp_adver", "map", map);
    }

    @RequestMapping(value={"/showtempadverajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelAdver showTempAdverAjax(Long channelAdverId) {
        return this.channelAdverService.selectByPrimaryKey(channelAdverId);
    }

    @RequestMapping(value={"/createTempAdver"})
    public ModelAndView createTempAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYTEMPADVERBYPAGEBEAN_HTM + channelAdver.getTempId() + ATID + channelAdver.getAtId() + ADVERTYPE + channelAdver.getAdverType() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setCreateUserId(loginUserId);
        this.channelAdverService.saveChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYTEMPADVERBYPAGEBEAN_HTM + channelAdver.getTempId() + ATID + channelAdver.getAtId() + ADVERTYPE + channelAdver.getAdverType() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/createtempadverajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createTempAdverAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        channelAdver.setCreateUserId(loginUserId);
        return this.channelAdverService.saveChannelAdver(channelAdver);
    }

    @RequestMapping(value={"/updateTempAdver"})
    public ModelAndView updateTempAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYTEMPADVERBYPAGEBEAN_HTM + channelAdver.getTempId() + ATID + channelAdver.getAtId() + ADVERTYPE + channelAdver.getAdverType() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setUpdateUserId(loginUserId);
        this.channelAdverService.updateChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYTEMPADVERBYPAGEBEAN_HTM + channelAdver.getTempId() + ATID + channelAdver.getAtId() + ADVERTYPE + channelAdver.getAdverType() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updatetempadverajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateTempAdverAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        channelAdver.setUpdateUserId(loginUserId);
        return this.channelAdverService.updateChannelAdver(channelAdver);
    }

    @RequestMapping(value={"/deletetempadverajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deleteTempAdverAjax(HttpServletRequest request, HttpServletResponse response, Long[] adverId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (adverId != null && adverId.length > 0) {
            for (int i = 0; i < adverId.length; ++i) {
                this.channelAdverService.deleteChannelAdver(adverId[i], loginUserId);
            }
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6a21\u677f\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deleteTempAdver"})
    public void deleteTempAdver(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String[] adverIds = request.getParameterValues("adverIds[]");
        for (int i = 0; i < adverIds.length; ++i) {
            Long id = Long.valueOf(adverIds[i]);
            this.channelAdverService.deleteChannelAdver(id, loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6a21\u677f\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/serveTempAdverAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int serveTempAdverAjax(HttpServletRequest request, HttpServletResponse response, @RequestBody JSONObject obj) {
        int count = 0;
        int countAddTempAdver = 0;
        int countEditTempAdver = 0;
        LOGGER.info((Object)("temp adver data:" + obj.toJSONString()));
        String data = obj.toJSONString();
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            Integer adverSort;
            String adverHref;
            String adverPath;
            String adverName;
            int i;
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            JSONObject json = JSON.parseObject((String)data);
            String createArr = json.getString("createArr");
            String modifyArr = json.getString("modifyArr");
            String adverTitle = null;
            String adverTitleArr = json.getString("title");
            if (StringUtils.isNotEmpty((String)adverTitleArr)) {
                JSONArray titleArray = JSONArray.parseArray((String)adverTitleArr);
                adverTitle = JSONObject.parseObject((String)JSONObject.toJSONString((Object)titleArray.get(0))).getString("title");
            }
            if (StringUtils.isNotEmpty((String)createArr)) {
                JSONArray createArray = JSONArray.parseArray((String)createArr);
                for (i = 0; i < createArray.size(); ++i) {
                    adverName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("keyword");
                    adverPath = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("imgSrc");
                    adverHref = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("linkAddress");
                    adverSort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getInteger("sort");
                    Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("tempId");
                    String temp5 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("temp5");
                    Long atId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("atId");
                    Long adverType = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("adverType");
                    String temp3 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("temp3");
                    ChannelAdver channelAdver = new ChannelAdver();
                    channelAdver.setAdverName(adverName);
                    channelAdver.setAdverPath(adverPath);
                    channelAdver.setAdverHref(adverHref);
                    channelAdver.setAdverSort(adverSort);
                    channelAdver.setUserStatus("1");
                    channelAdver.setTemp5(temp5);
                    if (StringUtils.isNotEmpty((String)adverTitle)) {
                        channelAdver.setAdverTitle(adverTitle);
                    }
                    channelAdver.setTempId(tempId);
                    channelAdver.setAtId(atId);
                    channelAdver.setAdverType(adverType);
                    channelAdver.setTemp3(temp3);
                    channelAdver.setCreateUserId(loginUserId);
                    countAddTempAdver = this.channelAdverService.saveChannelAdver(channelAdver);
                }
            }
            if (StringUtils.isNotEmpty((String)modifyArr)) {
                JSONArray modifyArray = JSONArray.parseArray((String)modifyArr);
                for (i = 0; i < modifyArray.size(); ++i) {
                    adverName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("keyword");
                    adverPath = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("imgSrc");
                    adverHref = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("linkAddress");
                    adverSort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getInteger("sort");
                    String temp5 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("temp5");
                    Long channelAdverId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("id");
                    Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("tempId");
                    Long atId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("atId");
                    Long adverType = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("adverType");
                    String temp3 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("temp3");
                    ChannelAdver channelAdver = new ChannelAdver();
                    channelAdver.setAdverName(adverName);
                    channelAdver.setAdverPath(adverPath);
                    channelAdver.setAdverHref(adverHref);
                    channelAdver.setAdverSort(adverSort);
                    channelAdver.setTemp5(temp5);
                    if (StringUtils.isNotEmpty((String)adverTitle)) {
                        channelAdver.setAdverTitle(adverTitle);
                    }
                    channelAdver.setChannelAdverId(channelAdverId);
                    channelAdver.setTempId(tempId);
                    channelAdver.setAtId(atId);
                    channelAdver.setAdverType(adverType);
                    channelAdver.setTemp3(temp3);
                    channelAdver.setUpdateUserId(loginUserId);
                    countEditTempAdver = this.channelAdverService.updateChannelAdver(channelAdver);
                }
            }
            if (countAddTempAdver > 0 || countEditTempAdver > 0) {
                count = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u64cd\u4f5c\u6a21\u677f\u5e7f\u544a\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public ChannelAdverService getChannelAdverService() {
        return this.channelAdverService;
    }

    @Resource(name="ChannelAdverService")
    public void setChannelAdverService(ChannelAdverService channelAdverService) {
        this.channelAdverService = channelAdverService;
    }
}

