/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.channel.service.ISysDictionaryBiz;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.information.service.InformationTypeService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelController {
    private static final String LOGINUSERID = "loginUserId";
    private static final Long TEMPTYPE = 139L;
    private static final String INFOTYPELIST = "infoTypeList";
    private static final String CHANNEL = "channel";
    private static final String QUERYCHANNELBYPAGEBEAN = "queryChannelByPageBean.htm?tempId=";
    private static final String USERNAME = ",\u7528\u6237\u540d:";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String GOODSCATELIST = "goodsCateList";
    private static final String SYSTEMPLIST = "sysTempList";
    private SysChannelService channelService;
    private ChannelAdverService channelAdverService;
    private InformationTypeService infoTypeService;
    private GoodsCateService goodsCateService;
    private ISysDictionaryBiz sysDicBiz;
    private TempService tempService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;

    @RequestMapping(value={"/queryChannelByPageBean"})
    public ModelAndView queryChannelByPageBean(PageBean pb, String searchText, Long tempId) {
        HashMap<String, List> map = new HashMap<String, List>();
        List goodsCateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        map.put(GOODSCATELIST, goodsCateList);
        List sysTempList = this.tempService.querySystempByType(TEMPTYPE);
        map.put(SYSTEMPLIST, sysTempList);
        PageBean pageBean = this.channelService.findChannelByPageBean(pb, searchText, tempId);
        return new ModelAndView("jsp/channel/channel_list", "pb", (Object)pageBean).addObject("tempId", (Object)tempId).addObject("map", map);
    }

    @RequestMapping(value={"/queryChannelByChannelId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryChannelByChannelId(Long channelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List goodsCateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        map.put(GOODSCATELIST, goodsCateList);
        List sysTempList = this.tempService.querySystempByType(TEMPTYPE);
        map.put(SYSTEMPLIST, sysTempList);
        Channel channel = this.channelService.findChannelByID(channelId);
        map.put(CHANNEL, channel);
        return map;
    }

    @RequestMapping(value={"/showChannel"})
    public ModelAndView showChannel(Long channelID) {
        HashMap map = new HashMap();
        List goodsCateList = this.goodsCateService.queryAllFirstGradeGoosCate();
        map.put(GOODSCATELIST, goodsCateList);
        List sysTempList = this.tempService.querySystempByType(TEMPTYPE);
        map.put(SYSTEMPLIST, sysTempList);
        List infoTypeList = this.infoTypeService.selectInfoTypeByAttrForTemp();
        map.put(INFOTYPELIST, infoTypeList);
        if (null != channelID) {
            Channel channel = this.channelService.findChannelByID(channelID);
            map.put(CHANNEL, channel);
        }
        return new ModelAndView("jsp/channel/showChannel", "map", map);
    }

    @RequestMapping(value={"/createChannel"})
    public ModelAndView createChannel(HttpServletRequest request, @Valid Channel channel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + channel.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channel.setCreateUserId(loginUserId);
        channel.setUpdateUserId(loginUserId);
        channel.setChannelUrl("channelview/" + channel.getGoodsCatId() + ".html");
        this.channelService.createChannel(channel);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + channel.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateChannel"})
    public ModelAndView updateChannel(HttpServletRequest request, @Valid Channel channel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + channel.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channel.setUpdateUserId(loginUserId);
        this.channelService.updateChannel(channel);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + channel.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateChannelAndTemp"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateChannelTemp(HttpServletRequest request, Channel channel, String expFleid5, Long tempType) {
        SysTemp temp = new SysTemp();
        temp.setExpFleid5(expFleid5);
        temp.setTempId(Integer.parseInt(channel.getTempId() + ""));
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channel.setUpdateUserId(loginUserId);
        int num1 = this.tempService.updateSystemp(temp);
        int num2 = this.channelService.updateChannel(channel);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return num1 + num2;
    }

    @RequestMapping(value={"/deleteChannel"})
    public ModelAndView deleteChannel(HttpServletRequest request, HttpServletResponse response, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String[] channelIDs = request.getParameterValues("channelIDs");
        String[] channelids = channelIDs[0].split(",");
        for (int i = 0; i < channelids.length; ++i) {
            Long id = Long.valueOf(channelids[i]);
            this.channelService.deleteChannel(id, loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + tempId));
    }

    @RequestMapping(value={"/openChannelById"})
    public ModelAndView openChannelById(Long channelId, Long tempId, HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        this.channelService.openChannelByID(channelId, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5f00\u542f\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/closeChannelById"})
    public ModelAndView closeChannelById(Long channelId, Long tempId, HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        this.channelService.closeChannelByID(channelId, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5173\u95ed\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/openAllChannel"})
    public ModelAndView openAllChannel(HttpServletRequest request, Long tempId) {
        this.channelService.openAllChannel();
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5f00\u542f\u6240\u6709\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/closeAllChannel"})
    public ModelAndView closeAllChannel(HttpServletRequest request, Long tempId) {
        this.channelService.closeAllChannel();
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5173\u95ed\u6240\u6709\u9891\u9053", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELBYPAGEBEAN + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/showChannelSet"})
    public ModelAndView showChannelSet(Long channelId, Long goodsCatId) {
        ModelAndView mav = new ModelAndView();
        Channel channel = this.channelService.findChannelByID(channelId);
        mav.addObject(CHANNEL, (Object)channel);
        SysTemp sysTemp = this.tempService.getSystempById(channel.getTempId());
        mav.addObject("sysTemp", (Object)sysTemp);
        List infoTypeList = this.infoTypeService.selectInfoTypeByAttrForTemp();
        mav.addObject(INFOTYPELIST, (Object)infoTypeList);
        mav.addObject("cate", (Object)this.goodsCateService.queryAllFirstGradeGoosCate());
        mav.addObject("brand", (Object)this.goodsBrandService.queryAllBrand());
        mav.addObject("goodsCatId", (Object)goodsCatId);
        mav.setViewName("jsp/channel/setChannel");
        return mav;
    }

    @RequestMapping(value={"/showBarChannelSet"})
    public ModelAndView showBarChannelSet(String barId) {
        ModelAndView mav = new ModelAndView();
        Channel channel = this.channelService.selectByBarId(barId);
        mav.addObject(CHANNEL, (Object)channel);
        SysTemp sysTemp = this.tempService.getSystempById(channel.getTempId());
        mav.addObject("sysTemp", (Object)sysTemp);
        List infoTypeList = this.infoTypeService.selectInfoTypeByAttrForTemp();
        mav.addObject(INFOTYPELIST, (Object)infoTypeList);
        mav.setViewName("jsp/channel/set_bar_channel");
        return mav;
    }

    public SysChannelService getChannelService() {
        return this.channelService;
    }

    @Resource(name="SysChannelService")
    public void setChannelService(SysChannelService channelService) {
        this.channelService = channelService;
    }

    public InformationTypeService getInfoTypeService() {
        return this.infoTypeService;
    }

    @Resource(name="InformationTypeService")
    public void setInfoTypeService(InformationTypeService infoTypeService) {
        this.infoTypeService = infoTypeService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="ChannelGoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public ISysDictionaryBiz getSysDicBiz() {
        return this.sysDicBiz;
    }

    @Resource(name="channelSysDictionaryBizImpl")
    public void setSysDicBiz(ISysDictionaryBiz sysDicBiz) {
        this.sysDicBiz = sysDicBiz;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public ChannelAdverService getChannelAdverService() {
        return this.channelAdverService;
    }

    @Resource(name="ChannelAdverService")
    public void setChannelAdverService(ChannelAdverService channelAdverService) {
        this.channelAdverService = channelAdverService;
    }
}

