/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.HelpCenter;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class HelpCenterController {
    private static final MyLogger LOGGER = new MyLogger(HelpCenterController.class);
    private static final String REDIRECT = "findcenter.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;

    @RequestMapping(value={"/findcenter"})
    public ModelAndView findPageBean(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/helplist", "pageBean", (Object)this.helpCenterService.findByPageBean(pb, selectBean)).addObject("helpcate", (Object)this.helpCateService.findAll());
    }

    @RequestMapping(value={"/findCenterByHelpId"}, method={RequestMethod.GET}, produces={"text/html;charset=UTF-8"})
    public ModelAndView findCenterByHelpId(HttpServletRequest request, HttpServletResponse response, Long helpId, String helpTitle) {
        return new ModelAndView("mobileNew/helpNR").addObject("helpCenter", (Object)this.helpCenterService.findByHelpId(helpId)).addObject("helpTitle", (Object)helpTitle);
    }

    @RequestMapping(value={"/findHelpCenterByCateId"}, method={RequestMethod.GET}, produces={"text/html;charset=UTF-8"})
    public ModelAndView findHelpCateBySort(HttpServletRequest request, HttpServletResponse response, long helpCateId, String helpcateName) {
        return new ModelAndView("mobileNew/helpLB").addObject("HelpCenter", (Object)this.helpCenterService.findByHelpCateId("", helpCateId)).addObject("helpCateId", (Object)helpCateId).addObject("helpcateName", (Object)helpcateName);
    }

    @RequestMapping(value={"/findHelpCenterByContext"})
    public ModelAndView findHelpCateByContext(HttpServletRequest request, HttpServletResponse response, String searchText, String helpcateName) {
        try {
            if (searchText.equals(new String(searchText.getBytes("iso8859-1"), "iso8859-1"))) {
                searchText = new String(searchText.getBytes("iso8859-1"), "utf-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new ModelAndView("mobileNew/helpLB").addObject("HelpCenter", (Object)this.helpCenterService.findByHelpContext(searchText)).addObject("helpCateId", (Object)"").addObject("helpcateName", (Object)helpcateName);
    }

    @RequestMapping(value={"/findHelpCateBySearchText"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String findHelpCateBySearchText(HttpServletRequest request, HttpServletResponse response, String searchText, long helpCateId) {
        if (searchText == null) {
            searchText = "";
        }
        List list = this.helpCenterService.findByHelpCateId(searchText, helpCateId);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("list", list);
        return JSONObject.fromObject(map).toString();
    }

    @RequestMapping(value={"/tohelpcenter"})
    public ModelAndView toHelpCenter(HttpServletRequest request, HttpServletResponse response, Long helpId) {
        if (helpId != null) {
            request.setAttribute("help", (Object)this.helpCenterService.findByHelpId(helpId));
        }
        return new ModelAndView("jsp/system/addhelp", "helpcate", (Object)this.helpCateService.findAll());
    }

    @RequestMapping(value={"/tohelpcenterajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public HelpCenter tohelpcenterajax(Long helpId) {
        return this.helpCenterService.findByHelpId(helpId);
    }

    @RequestMapping(value={"/addhelp"})
    public ModelAndView addHelpCenter(MultipartHttpServletRequest mrequest, HttpServletResponse response, @Valid HelpCenter helpCenter, BindingResult bindingResult) {
        MultipartFile muFile = mrequest.getFile("helpPic");
        if (muFile != null) {
            helpCenter.setHelpImg(UploadUtil.uploadFileOne((MultipartFile)muFile));
        }
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        this.helpCenterService.insertHelpCenter(helpCenter);
        String customerName = (String)mrequest.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)mrequest), (String)customerName, (String)"\u6dfb\u52a0\u5e2e\u52a9\u4fe1\u606f", (String)(mrequest.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d:" + customerName));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/updatehelp"})
    public ModelAndView updateHelpCenter(MultipartHttpServletRequest request, HttpServletResponse response, @Valid HelpCenter helpCenter, BindingResult bindingResult) {
        MultipartFile muFile = request.getFile("helpPic");
        helpCenter.setHelpImg(UploadUtil.uploadFileOne((MultipartFile)muFile));
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        this.helpCenterService.updateHelpCenter(helpCenter);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5e2e\u52a9\u4fe1\u606f", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/delhelp"})
    public ModelAndView updateHelpCenter(HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter pr = null;){
            pr = response.getWriter();
            pr.print(this.helpCenterService.deleteHelpCenter(request.getParameterValues("helpIds[]")));
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5e2e\u52a9\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d:" + customerName));
        }
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }
}

