/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.goods.bean.GoodsSpec;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class SpecController {
    private static final MyLogger LOGGER = new MyLogger(SpecController.class);
    private static final String SPECDETAILNAME = "specDetailName";
    private static final String SPECDETAILSORT = "specDetailSort";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d\uff1a";
    private static final String LOGGERINFO2 = ",\u89c4\u683c\u540d\u79f0\u4e3a\uff1a";
    private static final String LOGGERINFO3 = "\u89c4\u683c\u503c\u540d\u79f0\u3010";
    private static final String LOGGERINFO4 = "\u3011,\u7528\u6237\u540d\uff1a";
    private GoodsSpecService goodsSpecService;

    public GoodsSpecService getGoodsSpecService() {
        return this.goodsSpecService;
    }

    @Resource(name="GoodsSpecService")
    public void setGoodsSpecService(GoodsSpecService goodsSpecService) {
        this.goodsSpecService = goodsSpecService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/saveSpec"})
    public ModelAndView saveSpec(@Valid GoodsSpec goodsSpec, HttpServletRequest request, MultipartHttpServletRequest request2) {
        String[] detailnames = request.getParameterValues(SPECDETAILNAME);
        String[] specDetailNicknames = request.getParameterValues("specDetailNickname");
        String[] specDetailSorts = request.getParameterValues(SPECDETAILSORT);
        List fileList = request2.getFiles("specImage");
        String[] specDetailImgs = new String[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            specDetailImgs[i] = !((MultipartFile)fileList.get(i)).isEmpty() ? (String)UploadUtil.uploadFile((MultipartFile)((MultipartFile)fileList.get(i))).get("oldimg") : "";
        }
        try {
            this.goodsSpecService.saveGoodsSpec(goodsSpec, detailnames, specDetailNicknames, specDetailImgs, specDetailSorts, (String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u89c4\u683c\u548c\u6279\u91cf\u4fdd\u5b58\u89c4\u683c\u503c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("findAllSpec.htm"));
            return modelAndView;
        }
        finally {
            detailnames = null;
            specDetailNicknames = null;
            specDetailImgs = null;
            specDetailSorts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/saveSpecNew"})
    public ModelAndView saveSpecNew(@Valid GoodsSpec goodsSpec, HttpServletRequest request) {
        this.goodsSpecService.saveGoodsSpec(goodsSpec, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u89c4\u683c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
        ModelAndView modelAndView = new ModelAndView((View)new RedirectView("findAllSpec.htm"));
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateSpec"})
    public ModelAndView updateSpec(@Valid GoodsSpec goodsSpec, HttpServletRequest request, MultipartHttpServletRequest request2) {
        GoodsSpecVo goodsSpecVos = this.goodsSpecService.queryBySpecPrimaryKey(goodsSpec.getSpecId());
        LOGGER.info((Object)("\u66f4\u65b0\u89c4\u683c\u4fe1\u606f,\u89c4\u683c\u540d\u79f0\u4e3a\uff1a" + goodsSpecVos.getSpecName()));
        String[] specDetailIds = request.getParameterValues("specDetailId");
        String[] specDetailDelflag = request.getParameterValues("specDetailDelflag");
        String[] specDetailName = request.getParameterValues(SPECDETAILNAME);
        String[] specDetailNickname = request.getParameterValues("specDetailNickname");
        String[] specDetailImg = request.getParameterValues("specDetailImg");
        String[] specDetailSort = request.getParameterValues(SPECDETAILSORT);
        List fileList = request2.getFiles("specImage");
        if (null != fileList && !fileList.isEmpty()) {
            for (int i = 0; i < fileList.size(); ++i) {
                if (((MultipartFile)fileList.get(i)).isEmpty()) continue;
                specDetailImg[i] = (String)UploadUtil.uploadFile((MultipartFile)((MultipartFile)fileList.get(i))).get("oldimg");
            }
        }
        try {
            this.goodsSpecService.updateGoodsSpec(goodsSpec, this.goodsSpecService.changeSpecDetail(specDetailIds, specDetailDelflag, specDetailName, specDetailNickname, specDetailImg, specDetailSort), (String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u89c4\u683c\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO3 + goodsSpec.getSpecName() + LOGGERINFO4 + (String)request.getSession().getAttribute("name")));
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("findAllSpec.htm"));
            return modelAndView;
        }
        finally {
            specDetailIds = null;
            specDetailDelflag = null;
            specDetailName = null;
            specDetailNickname = null;
            specDetailImg = null;
            specDetailSort = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateSpecNew"})
    public ModelAndView updateSpecNew(@Valid GoodsSpec goodsSpec, HttpServletRequest request, PageBean pb) {
        GoodsSpecVo goodsSpecVos = this.goodsSpecService.queryBySpecPrimaryKey(goodsSpec.getSpecId());
        LOGGER.info((Object)("\u66f4\u65b0\u89c4\u683c\u4fe1\u606f,\u89c4\u683c\u540d\u79f0\u4e3a\uff1a" + goodsSpecVos.getSpecName()));
        this.goodsSpecService.updateGoodsSpec(goodsSpec, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u89c4\u683c\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO3 + goodsSpec.getSpecName() + LOGGERINFO4 + (String)request.getSession().getAttribute("name")));
        ModelAndView modelAndView = new ModelAndView((View)new RedirectView("findAllSpec.htm?pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateSpecDetail"})
    public ModelAndView updateSpecDetail(GoodsSpec goodsSpec, HttpServletRequest request, PageBean pb) {
        GoodsSpecVo goodsSpecVos = this.goodsSpecService.queryBySpecPrimaryKey(goodsSpec.getSpecId());
        LOGGER.info((Object)("\u66f4\u65b0\u89c4\u683c\u4fe1\u606f,\u89c4\u683c\u540d\u79f0\u4e3a\uff1a" + goodsSpecVos.getSpecName()));
        String[] specDetailIds = request.getParameterValues("specDetailId");
        String[] specDetailDelflag = request.getParameterValues("specDetailDelflag");
        String[] specDetailName = request.getParameterValues(SPECDETAILNAME);
        String[] specDetailSort = request.getParameterValues(SPECDETAILSORT);
        try {
            this.goodsSpecService.updateGoodsSpec(goodsSpec, this.goodsSpecService.changeSpecDetail(specDetailIds, specDetailDelflag, specDetailName, null, null, specDetailSort), (String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u89c4\u683c\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO3 + goodsSpec.getSpecName() + LOGGERINFO4 + (String)request.getSession().getAttribute("name")));
            ModelAndView modelAndView = new ModelAndView((View)new RedirectView("findAllSpec.htm?pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
            return modelAndView;
        }
        finally {
            specDetailIds = null;
            specDetailDelflag = null;
            specDetailName = null;
            specDetailSort = null;
        }
    }

    @RequestMapping(value={"/findAllSpec"})
    public ModelAndView findAllSpec(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u89c4\u683c\u4fe1\u606f");
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/goods/goods_spec", "pageBean", (Object)this.goodsSpecService.searchSpecListByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/delSpec"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String delSpec(Long specId, HttpServletRequest request) {
        GoodsSpecVo goodsSpecVos = this.goodsSpecService.queryBySpecPrimaryKey(specId);
        if (null != goodsSpecVos.getSpecName()) {
            LOGGER.info((Object)("\u5220\u9664\u89c4\u683c\u4fe1\u606f,\u5546\u54c1\u89c4\u683c\u540d\u79f0\u4e3a:" + goodsSpecVos.getSpecName()));
        }
        this.goodsSpecService.delGoodsSpec(specId, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u89c4\u683c\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO3 + goodsSpecVos.getSpecName() + LOGGERINFO4 + (String)request.getSession().getAttribute("name")));
        return JSON.toJSONString((Object)new ModelAndView((View)new RedirectView("findAllSpec.htm")));
    }

    @RequestMapping(value={"/batchDelSpec"})
    public ModelAndView batchDelSpec(Long[] specIds, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u89c4\u683c\u4fe1\u606f");
        this.goodsSpecService.batchDelGoodsSpec(specIds, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u89c4\u683c\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllSpec.htm"));
    }
}

