/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.license.controller;

import com.qianjiang.license.bean.MultiFile;
import com.qianjiang.license.service.LicenseImportService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LicenseImportController {
    public static final MyLogger LOGGER = new MyLogger(LicenseImportController.class);
    @Resource(name="licenseImportService")
    private LicenseImportService licenseImportService;

    @RequestMapping(value={"/jumpToLicenseImport"})
    public ModelAndView downImportExcel(HttpServletResponse response) {
        return new ModelAndView("jsp/license/license_import");
    }

    @RequestMapping(value={"/licenseImport"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String importGoods(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest request2) throws IOException {
        String flag = "0";
        try {
            MultipartFile file = request2.getFile("importLicense");
            MultiFile multiFile = new MultiFile();
            multiFile.setOriginalFilename(file.getOriginalFilename());
            multiFile.setBytes(file.getBytes());
            flag = this.licenseImportService.importLicenseByLic(multiFile);
            return flag;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("", (Throwable)e);
            return flag;
        }
    }
}

