/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.version.controller;

import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.version.bean.Version;
import com.qianjiang.version.service.VersionService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class VersionController {
    private static final MyLogger LOGGER = new MyLogger(VersionController.class);
    private static final String REDIRECT = "allversion.htm";
    @Resource(name="versionService")
    private VersionService versionService;

    @RequestMapping(value={"/initversion"})
    public ModelAndView initVersion() {
        List list = this.versionService.seleceVersion();
        return new ModelAndView("jsp/version/versionlist", "verList", (Object)list);
    }

    @RequestMapping(value={"/allversion"})
    public ModelAndView allVersion(PageBean pageBean, Version version) {
        pageBean.setUrl(REDIRECT);
        return new ModelAndView("jsp/core/manager/versionlist", "pageBean", (Object)this.versionService.selectAllVersion(pageBean, version));
    }

    @RequestMapping(value={"/addversion"})
    public ModelAndView addVersion(Version version, String date) {
        if (null != version.getVersionCode()) {
            LOGGER.info((Object)("\u65b0\u589e\u7248\u672c\u4fe1\u606f\uff0c\u65b0\u589e\u7684\u7248\u672c\u53f7\u4e3a:" + version.getVersionCode()));
        }
        this.versionService.addVersion(version, date);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/updateversion"})
    public ModelAndView updateVersion(Version version, String date) {
        if (null != version.getVersionCode()) {
            LOGGER.info((Object)("\u4fee\u6539\u7248\u672c\u4fe1\u606f\uff0c\u4fee\u6539\u7684\u7248\u672c\u53f7\u4e3a:" + version.getVersionCode()));
        }
        this.versionService.updateVersion(version, date);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/showversion"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Version showVersion(Long versionId) {
        if (null != versionId) {
            Version version = this.versionService.showVersion(versionId);
            LOGGER.info((Object)("\u83b7\u53d6\u7248\u672c\u53f7\u4e3a\uff1a" + version.getVersionCode() + "\u7684\u7248\u672c\u4fe1\u606f"));
        }
        return this.versionService.showVersion(versionId);
    }

    @RequestMapping(value={"/shownewversion"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Version showNewVersion() {
        Version version = this.versionService.showNewVersion();
        if (null != version.getVersionCode()) {
            LOGGER.info((Object)("\u67e5\u8be2\u6700\u65b0\u7248\u672c\u4fe1\u606f,\u7248\u672c\u53f7\u4e3a\uff1a" + version.getVersionCode()));
        }
        return version;
    }
}

