/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.Empower;
import com.qianjiang.system.bean.EmpowerLog;
import com.qianjiang.system.service.EmpowerService;
import com.qianjiang.util.PageBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class EmpowerController {
    @Resource(name="EmpowerService")
    private EmpowerService empowerService;

    @RequestMapping(value={"/selectemp"})
    public ModelAndView selectEmp(PageBean pageBean) {
        return new ModelAndView("/jsp/system/empower/empower_list").addObject("pageBean", (Object)this.empowerService.list(pageBean));
    }

    @RequestMapping(value={"insertempoer"})
    public ModelAndView insertEmpoer(Empower empower, String sTime, String eTime, HttpServletRequest request) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            empower.setBeginTime(formatDate.parse(sTime));
            empower.setEndTime(formatDate.parse(eTime));
        }
        catch (ParseException e) {
            String operaCode = "\u5916\u90e8\u63a5\u53e3";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u6dfb\u52a0\u5916\u90e8\u63a5\u53e3\u89d2\u8272\u65f6\u95f4\u8f6c\u6362\u9519\u8bef";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        this.empowerService.insertEmpower(empower);
        return new ModelAndView((View)new RedirectView("selectemp.htm"));
    }

    @RequestMapping(value={"updateempower"})
    public ModelAndView updateEmpower(String status, Long appId) {
        this.empowerService.updateEmpower(status, appId);
        return new ModelAndView((View)new RedirectView("selectemp.htm"));
    }

    @RequestMapping(value={"delempower"})
    public ModelAndView delEmpower(Long appId) {
        this.empowerService.delEmpower(appId);
        return new ModelAndView((View)new RedirectView("selectemp.htm"));
    }

    @RequestMapping(value={"/checkusername"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkUserName(String appUserName) {
        return this.empowerService.checkUserName(appUserName);
    }

    @RequestMapping(value={"/selectlog"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<EmpowerLog> selectLog(Long empowerId) {
        return this.empowerService.selectLog(empowerId);
    }
}

