/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.weixin.controller;

import com.qianjiang.operlog.bean.OperationLog;
import com.qianjiang.operlog.service.OperaLogService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UtilDate;
import com.qianjiang.weixin.service.WXActivityService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WXActivityController {
    private static final MyLogger LOGGER = new MyLogger(WXActivityController.class);
    private static final String IMGF = "img_f";
    private OperaLogService operaLogService;
    @Resource(name="wXActivityServicec")
    private WXActivityService wxActivityService;

    @RequestMapping(value={"/selectLogById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public OperationLog selectLogById(Long opId) throws Exception {
        OperationLog operationLog = this.operaLogService.selectLogById(opId);
        if (null != operationLog.getOpCode()) {
            LOGGER.info((Object)("\u83b7\u53d6\u64cd\u4f5c\u5173\u952e\u5b57\u4e3a\uff1a\u3010" + operationLog.getOpCode() + "\u3011\u7684\u64cd\u4f5c\u65e5\u5fd7\u5185\u5bb9\uff01"));
        }
        return operationLog;
    }

    @RequestMapping(value={"/initwxgroup"})
    public ModelAndView findWXGroup() {
        return new ModelAndView("jsp/customer/wxgroup").addObject("groups", (Object)this.wxActivityService.selectAllGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sendactivitynotice"})
    public ModelAndView sendActivityNotice(MultipartHttpServletRequest request, HttpServletResponse response, String content, String title) throws IOException {
        String path = "";
        int res = 0;
        try {
            if (this.checkExtendsName(request, path)) {
                path = this.transfile(request);
            } else {
                res = -1001;
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            res = -1001;
            OperaLogUtil.addOperaException((String)((String)request.getSession().getAttribute("name")), (Exception)e, (HttpServletRequest)request);
        }
        finally {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u53d1\u9001\u5fae\u4fe1\u901a\u77e5", (String)((String)request.getSession().getAttribute("operaPath")));
        }
        return new ModelAndView("redirect:/initwxgroup.htm");
    }

    private String transfile(MultipartHttpServletRequest request) throws IOException {
        String pa = "home";
        MultipartFile mf = request.getFile(IMGF);
        String filePath = pa + "/upload/" + UtilDate.todayFormatString((Date)new Date()) + "/";
        File picSaveFile = new File(filePath);
        if (!picSaveFile.exists()) {
            try {
                picSaveFile.mkdirs();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                e.getLocalizedMessage();
            }
        }
        String path = filePath + mf.getOriginalFilename();
        File file = new File(path);
        mf.transferTo(file);
        return path;
    }

    private boolean checkExtendsName(MultipartHttpServletRequest request, String path) throws IOException {
        if (request.getFile(IMGF) != null) {
            String fileName = request.getFile(IMGF).getOriginalFilename();
            if (fileName.indexOf(".") < 0) {
                return false;
            }
            if (!"jpg".equals(fileName.substring(fileName.lastIndexOf(".") + 1))) {
                return false;
            }
        }
        return true;
    }

    public OperaLogService getOperaLogService() {
        return this.operaLogService;
    }

    @Resource(name="operaLogService")
    public void setOperaLogService(OperaLogService operaLogService) {
        this.operaLogService = operaLogService;
    }
}

