/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelGoods;
import com.qianjiang.channel.service.ChannelSalesGoodsService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelSalesGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ChannelSalesGoodsController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_ACTION = "showChannelSalesGoods.htm?channelGoodsId=";
    private static final String QUERYSALESCHANNELGOODSBYPAGEBEAN_HTM = "querySalesChannelGoodsByPageBean.htm?channelId=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private ChannelSalesGoodsService channelSalesGoodsService;

    @RequestMapping(value={"/querySalesChannelGoodsByPageBean"})
    public ModelAndView queryChannelGoodsByPageBean(PageBean pb, Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        mav.addObject("pb", (Object)this.channelSalesGoodsService.selectChannelGoodsByParam(pb, channelId));
        mav.addObject("tempId", (Object)tempId);
        mav.addObject("channelId", (Object)channelId);
        mav.setViewName("jsp/channel/channel_sales_goods_list");
        return mav;
    }

    @RequestMapping(value={"/createSalesChannelGoods"})
    public ModelAndView createChannelGoods(HttpServletRequest request, @Valid ChannelGoods channelGoods, BindingResult bindingResult, String tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSALESCHANNELGOODSBYPAGEBEAN_HTM + channelId));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelGoods.setChannelGoodsCreateUser(Long.valueOf(1L));
            } else {
                channelGoods.setChannelGoodsCreateUser(loginUserId);
            }
            int n = this.channelSalesGoodsService.insertSelective(channelGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u4fc3\u9500\u5546\u54c1\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(QUERYSALESCHANNELGOODSBYPAGEBEAN_HTM + channelId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u4fc3\u9500\u5546\u54c1\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION + channelGoods.getChannelGoodsId()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u4fc3\u9500\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION + channelGoods.getChannelGoodsId()));
        }
        return mav;
    }

    @RequestMapping(value={"/updateSalesChannelGoods"})
    public ModelAndView updateChannelGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelGoods channelGoods, BindingResult bindingResult, String tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSALESCHANNELGOODSBYPAGEBEAN_HTM + channelId));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelGoods.setChannelGoodsCreateUser(Long.valueOf(1L));
            } else {
                channelGoods.setChannelGoodsCreateUser(loginUserId);
            }
            int n = this.channelSalesGoodsService.updateByPrimaryKeySelective(channelGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u5546\u54c1\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(QUERYSALESCHANNELGOODSBYPAGEBEAN_HTM + channelId));
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u5546\u54c1\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION + channelGoods.getChannelGoodsId()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION + channelGoods.getChannelGoodsId()));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteSalesChannelGoods"})
    public void deleteChannelGoods(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyGoodsIds = request.getParameterValues("channelGoodsIds[]");
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelSalesGoodsService.deleteByPrimaryKey(Long.valueOf(storeyGoodsIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/showChannelSalesGoods"})
    public ModelAndView showChannelGoods(Long channelGoodsId, Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        if (null != channelGoodsId) {
            ChannelGoods channelStoreyGoods = this.channelSalesGoodsService.selectByPrimaryKey(channelGoodsId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        mav.setViewName("jsp/channel/showChannelSalesGoods");
        return mav;
    }

    public ChannelSalesGoodsService getChannelSalesGoodsService() {
        return this.channelSalesGoodsService;
    }

    @Resource(name="ChannelSalesGoodsService")
    public void setChannelSalesGoodsService(ChannelSalesGoodsService channelSalesGoodsService) {
        this.channelSalesGoodsService = channelSalesGoodsService;
    }
}

