/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.FileUploadForm;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdAuthController {
    private static final MyLogger LOGGER = new MyLogger(ThirdAuthController.class);
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String LOGGERINFO2 = "\u5220\u9664\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e";
    @Resource(name="authService")
    private AuthService authService;
    private String page = "authset.htm";
    private String wxpage = "wxLoginSet.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";

    @RequestMapping(value={"/authset"})
    public ModelAndView barSet(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/authset", "pb", (Object)this.authService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/wxLoginSet"})
    public ModelAndView wxLoginSet(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/wxauthset", "pb", (Object)this.authService.findBywxPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/addauth"})
    public ModelAndView addAuth(HttpServletRequest request, HttpServletResponse response, Auth auth, @ModelAttribute(value="uploadForm") FileUploadForm uploadForm) {
        try {
            MultipartFile picPath = uploadForm.getPartPic();
            if (picPath != null && !"".equals(picPath.getName())) {
                auth.setAuthPic(UploadUtil.uploadFileOne((MultipartFile)picPath, (HttpServletRequest)request));
            }
            this.authService.insertAuth(auth);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/delauth"})
    public ModelAndView delAuth(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.authService.deleteAuth(request.getParameterValues("authIds[]")));
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO2, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (IOException e) {
            LOGGER.error("\u5220\u9664\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/delwxAuth"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delwxAuth(HttpServletRequest request, HttpServletResponse response) {
        int n = this.authService.deleteAuth(request.getParameterValues("authIds[]"));
        if (n > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO2, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        return n;
    }

    @RequestMapping(value={"/delauthone"})
    public ModelAndView delAuthOne(Long authId, HttpServletRequest request) {
        this.authService.deleteAuthById(authId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO2, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/delauthbatch"})
    public ModelAndView delAuthBatch(Long[] authIds, HttpServletRequest request) {
        for (Long authId : authIds) {
            this.authService.deleteAuthById(authId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO2, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/findauthone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Auth findAuthOne(Long authId) {
        return this.authService.findAuthByAuthId(authId);
    }

    @RequestMapping(value={"/updateauth"})
    public ModelAndView updateAuth(HttpServletRequest request, HttpServletResponse response, @Valid Auth auth, BindingResult bindingResult, @ModelAttribute(value="uploadForm") FileUploadForm uploadForm) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(this.page));
        }
        try {
            MultipartFile picPath = uploadForm.getPartPic();
            if (picPath != null && !"".equals(picPath.getName())) {
                auth.setAuthPic(UploadUtil.uploadFileOne((MultipartFile)picPath, (HttpServletRequest)request));
            }
            this.authService.updateAuth(auth);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/updatewxAuth"})
    public ModelAndView updatewxAuth(HttpServletRequest request, HttpServletResponse response, @Valid Auth auth, BindingResult bindingResult, @ModelAttribute(value="uploadForm") FileUploadForm uploadForm) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(this.wxpage));
        }
        try {
            MultipartFile picPath = uploadForm.getPartPic();
            if (picPath != null && !"".equals(picPath.getName())) {
                auth.setAuthPic(UploadUtil.uploadFileOne((MultipartFile)picPath, (HttpServletRequest)request));
            }
            this.authService.updateAuth(auth);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.wxpage));
    }

    @RequestMapping(value={"/updateUserdStatusForAuth"})
    public ModelAndView updateUserdStatusForAuth(Long authId, HttpServletRequest request) {
        try {
            this.authService.updateUserdStatus(authId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u542f\u7528\u72b6\u6001", (String)request.getSession().getAttribute(OPERAPATH).toString());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/updateUserdStatusForwx"})
    public ModelAndView updateUserdStatusForwx(Long authId, HttpServletRequest request) {
        try {
            this.authService.updateUserdStatus(authId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u542f\u7528\u72b6\u6001", (String)request.getSession().getAttribute(OPERAPATH).toString());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u767b\u5f55\u63a5\u53e3\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.wxpage));
    }
}

