/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.controller;

import com.qianjiang.information.bean.InforSubjectClassify;
import com.qianjiang.information.service.InforSubjectClassifyService;
import com.qianjiang.information.service.InforSubjectGoodsService;
import com.qianjiang.information.service.InforSubjectServcie;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InforSubjectClassifyController {
    private static final MyLogger LOGGER = new MyLogger(InforSubjectClassifyController.class);
    private static final String TitleClassification = "themaClassification.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="InforSubjectClassifyServiceImpl")
    private InforSubjectClassifyService themaCateService;
    @Resource(name="InforSubjectServcieImpl")
    private InforSubjectServcie subjectService;
    @Resource(name="InforSubjectGoodsServiceImpl")
    private InforSubjectGoodsService specialOrderService;

    @RequestMapping(value={"/findcentere"})
    public ModelAndView findcentere(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        selectBean.setHelpCateStatus("2");
        selectBean.setHelpCateType("1");
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/mobile/inforSubjectClassify", "pb", (Object)this.themaCateService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/querrySiteSubjectClassify"})
    public ModelAndView querrySiteSubjectClassify(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        selectBean.setHelpCateStatus("2");
        selectBean.setHelpCateType("2");
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/site_subjectClassify", "pb", (Object)this.themaCateService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/tohelpcenterL"})
    public ModelAndView toHelpCenter(HttpServletRequest request, HttpServletResponse response, Long helpId) {
        if (helpId != null) {
            request.setAttribute("help", (Object)this.themaCateService.findByHelpcateId(helpId));
        }
        return new ModelAndView("jsp/system/addhelp", "helpcate", (Object)this.themaCateService.findAll());
    }

    @RequestMapping(value={"/addClassKind"})
    public ModelAndView addClassKind(HttpServletRequest request, HttpServletResponse response, InforSubjectClassify inforSubjectClassify, MultipartHttpServletRequest multipartRequest, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = null;
        try {
            String picImage = "";
            if (multipartRequest.getFile("picFiles") != null && !"".equals(multipartRequest.getFile("picFiles").getOriginalFilename())) {
                picImage = UploadUtil.uploadFileOne((MultipartFile)multipartRequest.getFile("picFiles"));
            }
            inforSubjectClassify.setHelpcateImg(picImage);
            this.themaCateService.insertHelpCate(inforSubjectClassify);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u4e13\u9898\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d:" + customerName));
            mav = inforSubjectClassify.getHelpcateType() == 1L ? new ModelAndView((View)new RedirectView("findcentere.htm")) : new ModelAndView((View)new RedirectView("querrySiteSubjectClassify.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/updateClasKind"})
    public ModelAndView updateHelpCenter(MultipartHttpServletRequest request, HttpServletResponse response, MultipartHttpServletRequest multipartRequest, @Valid InforSubjectClassify inforSubjectClassify, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = null;
        String picImage = "";
        if (multipartRequest.getFile("picFiles") != null && !"".equals(multipartRequest.getFile("picFiles").getOriginalFilename())) {
            picImage = UploadUtil.uploadFileOne((MultipartFile)multipartRequest.getFile("picFiles"));
        }
        inforSubjectClassify.setHelpcateImg(picImage);
        this.themaCateService.updateHelpCate(inforSubjectClassify);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u4e13\u9898\u5206\u7c7b\u4fe1\u606f", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        mav = inforSubjectClassify.getHelpcateType() == 1L ? new ModelAndView((View)new RedirectView("findcentere.htm")) : new ModelAndView((View)new RedirectView("querrySiteSubjectClassify.htm"));
        return mav;
    }

    @RequestMapping(value={"/updateClassKindById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public InforSubjectClassify updateClassKindById(Long helpcateId) {
        return this.themaCateService.findByHelpcateId(helpcateId);
    }

    @RequestMapping(value={"/delClassKind"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delClassKind(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        int number = 0;
        try {
            String[] helpCateType = request.getParameterValues("helpcateType");
            String[] subjectIds = request.getParameterValues("helpIds[]");
            if (subjectIds.length > 0) {
                for (int i = 0; i < subjectIds.length; ++i) {
                    List subjectList = this.subjectService.selectListByCateId(Long.valueOf(subjectIds[i]), Long.valueOf(helpCateType[0]));
                    if (subjectList.size() > 0) continue;
                    number += this.themaCateService.deleteHelpCate(subjectIds[i]);
                }
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u4e13\u9898\u5206\u7c7b\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d:" + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u4e13\u9898\u5206\u7c7b\u4fe1\u606f\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return number;
    }
}

