/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.ImageManager;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.IImageManagerBiz;
import com.qianjiang.system.service.ISysDictionaryBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="imageManagerController")
public class ImageManagerController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(ImageManagerController.class);
    private ImageManager imageManager;
    private IImageManagerBiz imageManagerBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    private IDictionarysCache dictionarysCache;
    private ISysDictionaryBiz sysDictionaryBizImpl;
    public static final int DIC_IMAGE_TAG = 129;
    private static final String INIT_IMAGEMANAGER = "initImageManager.htm";
    private static final String ADD_IMAGEMANAGER_JSP = "jsp/system/image/imagemanager_add";
    private static final String IMAGEMANAGER_LIST_JSP = "jsp/system/image/imagemanager_list";
    private static final String UPDATE_IMAGEMANAGER_JSP = "jsp/system/image/imagemanager_update";
    private static final String READ_IMAGEMANAGER_JSP = "jsp/system/image/imagemanager_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String IMAGEMANAGER = "imageManager";
    private static final String IDS = "ids";
    private static final String TITLE = "title";
    private static final String TAG = "tag";

    @RequestMapping(value={"/initImageManager"})
    public final ModelAndView initImageManager(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        pageBean.setUrl(INIT_IMAGEMANAGER);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(IMAGEMANAGER_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject("pageBean", (Object)this.imageManagerBizImpl.getImageManagerByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        this.fullDictionarys(mav);
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.imageManagerBizImpl.getImageManagerByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddImageManagerPage"})
    public final ModelAndView openAddImageManagerPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_IMAGEMANAGER_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addImageManager"})
    public final ModelAndView addImageManager(ImageManager imageManager, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            imageManager.setInsertDate(new Date());
            imageManager.setInsertId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            imageManager.setDeleteStatus(0);
            boolean flag = this.imageManagerBizImpl.saveImageManager(imageManager);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
                return this.backAddPage(imageManager, mav);
            }
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u56fe\u7247\u7ba1\u7406\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_IMAGEMANAGER));
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
            return this.backAddPage(imageManager, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(ImageManager imageManager, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(IMAGEMANAGER, (Object)imageManager);
        mav.setViewName(ADD_IMAGEMANAGER_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateImageManagerPage"})
    public final ModelAndView openUpdateImageManagerPage(@RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(IMAGEMANAGER, (Object)this.imageManagerBizImpl.getImageManagerById(id));
            mav.setViewName(UPDATE_IMAGEMANAGER_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_IMAGEMANAGER));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/updateImageManager"})
    public final ModelAndView updateImageManager(ImageManager imageManager, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            imageManager.setModifyDate(new Date());
            imageManager.setModifyId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            if (this.imageManagerBizImpl.updateImageManager(imageManager) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
                return this.backUpdatePage(imageManager, mav);
            }
            mav.addObject(MSG, (Object)"\u4fee\u6539\u56fe\u7247\u7ba1\u7406\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_IMAGEMANAGER));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
            return this.backUpdatePage(imageManager, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(ImageManager imageManager, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(IMAGEMANAGER, (Object)imageManager);
        mav.setViewName(UPDATE_IMAGEMANAGER_JSP);
        return mav;
    }

    @RequestMapping(value={"/readImageManager"})
    public final ModelAndView readImageManager(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_IMAGEMANAGER));
        } else {
            mav.setViewName(READ_IMAGEMANAGER_JSP);
            mav.addObject(IMAGEMANAGER, (Object)this.imageManagerBizImpl.getImageManagerById(id));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteImageManager"})
    public final ModelAndView deleteImageManager(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_IMAGEMANAGER));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u56fe\u7247\u7ba1\u7406\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.imageManagerBizImpl.deleteImageManager(ids) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.imageManagerBizImpl.updateImageManagerFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreImageManager"})
    public final ModelAndView restoreImageManager(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_IMAGEMANAGER));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u56fe\u7247\u7ba1\u7406\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.imageManagerBizImpl.updateImageManagerFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u56fe\u7247\u7ba1\u7406\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/queryImageManager"})
    public final ModelAndView queryImageManager(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="tag", required=false, defaultValue="0") Integer tag, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (title != null && title.trim().length() != 0) {
            param.put(TITLE, title);
            queryParam.put(TITLE, title);
            queryParam.put("searchField", TITLE);
            queryParam.put("searchValue", title);
            queryParam.put("searchName", "\u56fe\u7247\u6807\u9898");
        }
        if (tag != 0) {
            param.put(TAG, tag);
            queryParam.put(TAG, tag);
            queryParam.put("searchField", TAG);
            queryParam.put("searchValue", tag);
            queryParam.put("searchName", "\u6807\u7b7e");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(IMAGEMANAGER_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject("pageBean", (Object)this.imageManagerBizImpl.getImageManagerByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u56fe\u7247\u7ba1\u7406\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        this.fullDictionarys(mav);
        return mav;
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
        PageBean pg = new PageBean();
        int pageSize = 200;
        pg.setPageSize(pageSize);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(2);
        pa.put("parentId", 129);
        pa.put("status", 1);
        try {
            mav.addObject("sysDicImageTag", (Object)this.sysDictionaryBizImpl.getSysDictionaryByField(pa, pg).getList());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u8d27\u5e01\u8bbe\u7f6e\u5b57\u5178\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public final ImageManager getImageManager() {
        return this.imageManager;
    }

    @Resource(name="imageManager")
    public final void setImageManager(ImageManager imageManager) {
        this.imageManager = imageManager;
    }

    public final IImageManagerBiz getImageManagerBizImpl() {
        return this.imageManagerBizImpl;
    }

    @Resource(name="imageManagerBizImpl")
    public final void setImageManagerBizImpl(IImageManagerBiz imageManagerBizImpl) {
        this.imageManagerBizImpl = imageManagerBizImpl;
    }

    public final IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public final void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }

    public final ISysDictionaryBiz getSysDictionaryBizImpl() {
        return this.sysDictionaryBizImpl;
    }

    @Resource(name="sysDictionaryBizImpl")
    public final void setSysDictionaryBizImpl(ISysDictionaryBiz sysDictionaryBizImpl) {
        this.sysDictionaryBizImpl = sysDictionaryBizImpl;
    }
}

