/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.StatisticsCode;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.service.IStatisticsCodeBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class StatisticsCodeController {
    private static final MyLogger LOGGER = new MyLogger(StatisticsCodeController.class);
    private StatisticsCode statisticsCode;
    private IStatisticsCodeBiz statisticsCodeBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    private IDictionarysCache dictionarysCache;
    private static final String INIT_STATISTICSCODE = "initStatisticsCode.htm";
    private static final String ADD_STATISTICSCODE_JSP = "jsp/system/sta/statisticscode_add";
    private static final String STATISTICSCODE_LIST_JSP = "jsp/system/sta/statisticscode_list";
    private static final String UPDATE_STATISTICSCODE_JSP = "jsp/system/sta/statisticscode_update";
    private static final String READ_STATISTICSCODE_JSP = "jsp/system/sta/statisticscode_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String STATISTICSCODE = "statisticsCode";
    private static final String IDS = "ids";
    private static final String STATITLE = "staTitle";
    private static final String MODULE = "module";
    private static final String STASTYLE = "staStyle";
    private static final String SEARCHFIELD = "searchField";
    private static final String SEARCHVALUE = "searchValue";
    private static final String SEARCHNAME = "searchName";

    @RequestMapping(value={"/initStatisticsCode"})
    public ModelAndView initStatisticsCode(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        if (null == deleteStatus) {
            deleteStatus = 0;
        }
        pageBean.setUrl(INIT_STATISTICSCODE);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(STATISTICSCODE_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject("pageBean", (Object)this.statisticsCodeBizImpl.getStatisticsCodeByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.statisticsCodeBizImpl.getStatisticsCodeByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddStatisticsCodePage"})
    public ModelAndView openAddStatisticsCodePage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_STATISTICSCODE_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addStatisticsCode"})
    public ModelAndView addStatisticsCode(@Valid StatisticsCode statisticsCode, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(INIT_STATISTICSCODE));
        }
        ModelAndView mav = new ModelAndView();
        try {
            statisticsCode.setInsertDate(new Date());
            statisticsCode.setInsertId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            statisticsCode.setDeleteStatus(0);
            boolean flag = this.statisticsCodeBizImpl.saveStatisticsCode(statisticsCode);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
                return this.backAddPage(statisticsCode, mav);
            }
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7edf\u8ba1\u4ee3\u7801\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_STATISTICSCODE));
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
            return this.backAddPage(statisticsCode, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(StatisticsCode statisticsCode, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(STATISTICSCODE, (Object)statisticsCode);
        mav.setViewName(ADD_STATISTICSCODE_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateStatisticsCodePage"})
    public ModelAndView openUpdateStatisticsCodePage(@RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(STATISTICSCODE, (Object)this.statisticsCodeBizImpl.getStatisticsCodeById(id));
            mav.setViewName(UPDATE_STATISTICSCODE_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_STATISTICSCODE));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/openUpdateStatisticsCodePageAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> openUpdateStatisticsCodePageAjax(@RequestParam(value="id") int id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATISTICSCODE, this.statisticsCodeBizImpl.getStatisticsCodeById(id));
        return map;
    }

    @RequestMapping(value={"/updateStatisticsCode"})
    public ModelAndView updateStatisticsCode(@Valid StatisticsCode statisticsCode, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(INIT_STATISTICSCODE));
        }
        ModelAndView mav = new ModelAndView();
        try {
            statisticsCode.setModifyDate(new Date());
            statisticsCode.setModifyId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            if (this.statisticsCodeBizImpl.updateStatisticsCode(statisticsCode) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
                return this.backUpdatePage(statisticsCode, mav);
            }
            mav.addObject(MSG, (Object)"\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_STATISTICSCODE));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
            return this.backUpdatePage(statisticsCode, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(StatisticsCode statisticsCode, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(STATISTICSCODE, (Object)statisticsCode);
        mav.setViewName(UPDATE_STATISTICSCODE_JSP);
        return mav;
    }

    @RequestMapping(value={"/readStatisticsCode"})
    public ModelAndView readStatisticsCode(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") Integer id) {
        if (null == deleteStatus) {
            deleteStatus = 0;
        }
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_STATISTICSCODE));
        } else {
            mav.setViewName(READ_STATISTICSCODE_JSP);
            mav.addObject(STATISTICSCODE, (Object)this.statisticsCodeBizImpl.getStatisticsCodeById(id.intValue()));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteStatisticsCode"})
    public ModelAndView deleteStatisticsCode(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids) {
        if (null == deleteStatus) {
            deleteStatus = 0;
        }
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_STATISTICSCODE));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.statisticsCodeBizImpl.deleteStatisticsCode(ids) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.statisticsCodeBizImpl.updateStatisticsCodeFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreStatisticsCode"})
    public ModelAndView restoreStatisticsCode(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_STATISTICSCODE));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.statisticsCodeBizImpl.updateStatisticsCodeFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/queryStatisticsCode"})
    public ModelAndView queryStatisticsCode(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="staTitle", required=false, defaultValue="") String staTitle, @RequestParam(value="staStyle", required=false, defaultValue="") String staStyle, @RequestParam(value="module", required=false, defaultValue="") String module, PageBean pageBean) {
        if (null == deleteStatus) {
            deleteStatus = 0;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (staTitle != null && staTitle.trim().length() != 0) {
            param.put(STATITLE, staTitle);
            queryParam.put(STATITLE, staTitle);
            queryParam.put(SEARCHFIELD, STATITLE);
            queryParam.put(SEARCHVALUE, staTitle);
            queryParam.put(SEARCHNAME, "\u7edf\u8ba1\u65b9\u6848\u6807\u9898");
        }
        if (staStyle != null && staStyle.trim().length() != 0) {
            param.put(STASTYLE, staStyle);
            queryParam.put(STASTYLE, staStyle);
            queryParam.put(SEARCHFIELD, STASTYLE);
            queryParam.put(SEARCHVALUE, staStyle);
            queryParam.put(SEARCHNAME, "\u7edf\u8ba1\u65b9\u6848\u4ee3\u7801");
        }
        if (module != null && module.trim().length() != 0) {
            param.put(MODULE, module);
            queryParam.put(MODULE, module);
            queryParam.put(SEARCHFIELD, MODULE);
            queryParam.put(SEARCHVALUE, module);
            queryParam.put(SEARCHNAME, "\u6a21\u5757\u540d");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(STATISTICSCODE_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject("pageBean", (Object)this.statisticsCodeBizImpl.getStatisticsCodeByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7edf\u8ba1\u4ee3\u7801\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/changeUserdStatusForScode"})
    public ModelAndView changeUserdStatusForScode(Long scodeId) {
        try {
            if (this.statisticsCodeBizImpl.changeUserdStatus(scodeId)) {
                LOGGER.debug("===============\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u542f\u7528\u72b6\u6001\u6210\u529f");
            } else {
                LOGGER.debug("===============\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u542f\u7528\u72b6\u6001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7edf\u8ba1\u4ee3\u7801\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(INIT_STATISTICSCODE));
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
    }

    public StatisticsCode getStatisticsCode() {
        return this.statisticsCode;
    }

    @Resource(name="statisticsCode")
    public void setStatisticsCode(StatisticsCode statisticsCode) {
        this.statisticsCode = statisticsCode;
    }

    public IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }

    public IStatisticsCodeBiz getStatisticsCodeBizImpl() {
        return this.statisticsCodeBizImpl;
    }

    @Resource(name="statisticsCodeBizImpl")
    public void setStatisticsCodeBizImpl(IStatisticsCodeBiz statisticsCodeBizImpl) {
        this.statisticsCodeBizImpl = statisticsCodeBizImpl;
    }
}

