/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ISysDictionaryBiz;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyAdverController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyAdverController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final Long ATID = 161L;
    private static final Long ADVERTTYPE = 151L;
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYCHANNELSTOREYADVERBYPAGEBEAN_HTM = "queryChannelStoreyAdverByPageBean.htm?storeyId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    private ChannelStoreyService channelStoreyService;
    private ChannelAdverService channelAdverService;
    private ISysDictionaryBiz sysDicBiz;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryChannelStoreyAdverByPageBean"})
    public ModelAndView queryChannelStoreyAdverByPageBean(PageBean pb, Long storeyId, HttpServletRequest request) {
        LOGGER.debug("======\u5206\u9875\u67e5\u770b\u9891\u9053\u697c\u5c42\u5e7f\u544a\u8bbe\u7f6e======");
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        pb.setUrl(QUERYCHANNELSTOREYADVERBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken"));
        return new ModelAndView("jsp/channel/channel_storey_adver_list", "pb", (Object)this.channelAdverService.selectchannelAdverByParam(pb, null, null, storeyId, null, ATID, ADVERTTYPE, null, null)).addObject("channelStorey", (Object)channelStorey);
    }

    @RequestMapping(value={"/querychannelstoreyadverbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryChannelStoreyAdverByPageBeanAjax(PageBean pb, Long storeyId, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelAdverService.selectchannelAdverByParam(pb, null, null, storeyId, null, ATID, ADVERTTYPE, null, null));
        return map;
    }

    @RequestMapping(value={"/showChannelStoreyAdver"})
    public ModelAndView showChannelStoreyAdver(Long channelAdverId, Long storeyId) {
        LOGGER.debug("======\u67e5\u770b\u9891\u9053\u697c\u5c42\u5e7f\u544a======");
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelStorey", channelStorey);
        if (null != channelAdverId) {
            ChannelAdver channelAdver = this.channelAdverService.selectByPrimaryKey(channelAdverId);
            map.put("channelAdver", channelAdver);
        }
        return new ModelAndView("jsp/channel/showChannelStoreyAdver", "map", map);
    }

    @RequestMapping(value={"/createChannelStoreyAdver"})
    public ModelAndView createChannelStoreyAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYADVERBYPAGEBEAN_HTM + channelAdver.getFloorId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u6dfb\u52a0\u9891\u9053\u697c\u5c42\u5e7f\u544a======");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setCreateUserId(loginUserId);
        this.channelAdverService.saveChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYADVERBYPAGEBEAN_HTM + channelAdver.getFloorId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateChannelStoreyAdver"})
    public ModelAndView updateChannelStoreyAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYADVERBYPAGEBEAN_HTM + channelAdver.getFloorId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u4fee\u6539\u9891\u9053\u697c\u5c42\u5e7f\u544a======");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setUpdateUserId(loginUserId);
        this.channelAdverService.updateChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYADVERBYPAGEBEAN_HTM + channelAdver.getFloorId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteChannelStoreyAdver"})
    public void deleteChannelStoreyAdver(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("======\u5220\u9664\u9891\u9053\u697c\u5c42\u5e7f\u544a======");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String[] adverIds = request.getParameterValues("adverIds[]");
        for (int i = 0; i < adverIds.length; ++i) {
            Long id = Long.valueOf(adverIds[i]);
            this.channelAdverService.deleteChannelAdver(id, loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelAdverService getChannelAdverService() {
        return this.channelAdverService;
    }

    @Resource(name="ChannelAdverService")
    public void setChannelAdverService(ChannelAdverService channelAdverService) {
        this.channelAdverService = channelAdverService;
    }

    public ISysDictionaryBiz getSysDicBiz() {
        return this.sysDicBiz;
    }

    @Resource(name="channelSysDictionaryBizImpl")
    public void setSysDicBiz(ISysDictionaryBiz sysDicBiz) {
        this.sysDicBiz = sysDicBiz;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }
}

