/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.StreetBean;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ExportCustomerController {
    private static final MyLogger LOGGER = new MyLogger(ExportCustomerController.class);
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    @RequestMapping(value={"/exportCustomerCheck"})
    public void exportCustomerCheck(HttpServletResponse response, Long[] customerIds) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u4f1a\u5458\u4fe1\u606f");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 4000);
        sheet.setColumnWidth(6, 4000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u7528\u6237\u540d");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u6027\u522b");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u624b\u673a");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u90ae\u7bb1");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u8eab\u4efd\u8bc1");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u6240\u5728\u5730");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u79ef\u5206");
        cell.setCellStyle(style);
        List list = this.customerServiceMapper.queryListForExportByCustomerIds(customerIds);
        for (int i = 0; i < list.size(); ++i) {
            StreetBean streetBean;
            String detailAddress = "";
            row = sheet.createRow(i + 1);
            CustomerAllInfo cus = (CustomerAllInfo)list.get(i);
            row.createCell(0).setCellValue(cus.getCustomerUsername());
            if (cus.getInfoGender() != null) {
                if ("1".equals(cus.getInfoGender())) {
                    row.createCell(1).setCellValue("\u7537");
                } else if ("2".equals(cus.getInfoGender())) {
                    row.createCell(1).setCellValue("\u5973");
                } else {
                    row.createCell(1).setCellValue("\u4fdd\u5bc6");
                }
            }
            if (cus.getInfoMobile() != null) {
                row.createCell(2).setCellValue(cus.getInfoMobile());
            }
            if (cus.getInfoEmail() != null) {
                row.createCell(3).setCellValue(cus.getInfoEmail());
            }
            if (cus.getInfoCardid() != null) {
                row.createCell(4).setCellValue(cus.getInfoCardid());
            }
            if (cus.getProvince() != null) {
                detailAddress = detailAddress + cus.getProvince().getProvinceName();
            }
            if (cus.getCity() != null) {
                detailAddress = detailAddress + cus.getCity().getCityName();
            }
            if (cus.getDistrict() != null) {
                detailAddress = detailAddress + cus.getDistrict().getDistrictName();
            }
            if (StringUtils.isNotEmpty((String)cus.getInfoStreet()) && null != (streetBean = this.customerServiceMapper.queryStreetBeanById(cus.getInfoStreet()))) {
                detailAddress = detailAddress + streetBean.getStreetName();
            }
            if (cus.getInfoAddress() != null) {
                detailAddress = detailAddress + cus.getInfoAddress();
            }
            if (StringUtils.isNotEmpty((String)detailAddress)) {
                row.createCell(5).setCellValue(detailAddress);
            }
            if (cus.getInfoPointSum() == null) continue;
            row.createCell(6).setCellValue((double)cus.getInfoPointSum().intValue());
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u539f\u56e0", (Throwable)e);
        }
    }

    @RequestMapping(value={"exportallcustomer"})
    public void exportCustomer(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u4f1a\u5458\u4fe1\u606f");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 4000);
        sheet.setColumnWidth(6, 4000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u7528\u6237\u540d");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u6027\u522b");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u624b\u673a");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u90ae\u7bb1");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u8eab\u4efd\u8bc1");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u6240\u5728\u5730");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u79ef\u5206");
        cell.setCellStyle(style);
        List list = this.customerServiceMapper.selectCustomerAllInfomation();
        for (int i = 0; i < list.size(); ++i) {
            StreetBean streetBean;
            String detailAddress = "";
            row = sheet.createRow(i + 1);
            CustomerAllInfo cus = (CustomerAllInfo)list.get(i);
            row.createCell(0).setCellValue(cus.getCustomerUsername());
            if (cus.getInfoGender() != null) {
                if ("1".equals(cus.getInfoGender())) {
                    row.createCell(1).setCellValue("\u7537");
                } else if ("2".equals(cus.getInfoGender())) {
                    row.createCell(1).setCellValue("\u5973");
                } else {
                    row.createCell(1).setCellValue("\u4fdd\u5bc6");
                }
            }
            if (cus.getInfoMobile() != null) {
                row.createCell(2).setCellValue(cus.getInfoMobile());
            }
            if (cus.getInfoEmail() != null) {
                row.createCell(3).setCellValue(cus.getInfoEmail());
            }
            if (cus.getInfoCardid() != null) {
                row.createCell(4).setCellValue(cus.getInfoCardid());
            }
            if (cus.getProvince() != null) {
                detailAddress = detailAddress + cus.getProvince().getProvinceName();
            }
            if (cus.getCity() != null) {
                detailAddress = detailAddress + cus.getCity().getCityName();
            }
            if (cus.getDistrict() != null) {
                detailAddress = detailAddress + cus.getDistrict().getDistrictName();
            }
            if (StringUtils.isNotEmpty((String)cus.getInfoStreet()) && null != (streetBean = this.customerServiceMapper.queryStreetBeanById(cus.getInfoStreet()))) {
                detailAddress = detailAddress + streetBean.getStreetName();
            }
            if (cus.getInfoAddress() != null) {
                detailAddress = detailAddress + cus.getInfoAddress();
            }
            if (StringUtils.isNotEmpty((String)detailAddress)) {
                row.createCell(5).setCellValue(detailAddress);
            }
            if (cus.getInfoPointSum() == null) continue;
            row.createCell(6).setCellValue((double)cus.getInfoPointSum().intValue());
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u539f\u56e0", (Throwable)e);
        }
    }
}

