/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsLackRegisterService;
import com.qianjiang.goods.util.LackRegisterSearchBean;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class StockNotifyController {
    private GoodsLackRegisterService goodsLackRegisterService;
    private static final MyLogger LOGGER = new MyLogger(StockNotifyController.class);

    public GoodsLackRegisterService getGoodsLackRegisterService() {
        return this.goodsLackRegisterService;
    }

    @Resource(name="GoodsLackRegisterService")
    public void setGoodsLackRegisterService(GoodsLackRegisterService goodsLackRegisterService) {
        this.goodsLackRegisterService = goodsLackRegisterService;
    }

    @RequestMapping(value={"/findAllLackRegister"})
    public ModelAndView findAllLackRegister(PageBean pb) {
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u5230\u8d27\u901a\u77e5\u5217\u8868");
        pb.setUrl("findAllLackRegister.htm");
        return new ModelAndView("jsp/goods/goods_arrival_notice", "pb", (Object)this.goodsLackRegisterService.queryByPageBean(pb));
    }

    @RequestMapping(value={"/batchNotice"})
    public ModelAndView batchNotice(Long[] lackCheck, HttpServletRequest request) {
        this.goodsLackRegisterService.updateLackRegisterStatus(lackCheck);
        LOGGER.info((Object)"\u6279\u91cf\u8fdb\u884c\u901a\u77e5");
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u8fdb\u884c\u901a\u77e5", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllLackRegister.htm"));
    }

    @RequestMapping(value={"/queryLackRegisterByParam"})
    public ModelAndView queryByParam(PageBean pb, LackRegisterSearchBean searchBean) {
        pb.setUrl("queryLackRegisterByParam.htm");
        LOGGER.info((Object)"\u67e5\u8be2\u5230\u8d27\u901a\u77e5");
        return new ModelAndView("jsp/goods/goods_arrival_notice", "pb", (Object)this.goodsLackRegisterService.queryByPageBeanAndSearchBean(pb, searchBean)).addObject("searchBean", (Object)searchBean);
    }

    @RequestMapping(value={"/batchDelLack"})
    public ModelAndView batchDelLack(Long[] lackCheck, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5230\u8d27\u901a\u77e5");
        this.goodsLackRegisterService.batchDel(lackCheck);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5230\u8d27\u901a\u77e5", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllLackRegister.htm"));
    }
}

