/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HotGoodsController {
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Autowired
    private GoodsProductService goodsProductService;

    @RequestMapping(value={"/hotGoods"})
    public ModelAndView toHotGoodsPage(PageBean pageBean, GoodsProduct goodsProduct) {
        ModelAndView mav = new ModelAndView("jsp/goods/hot_goods_list");
        Map result = null;
        pageBean.setUrl("hotGoods.htm");
        result = this.goodsProductService.selectHotGoods(goodsProduct, pageBean);
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(result.get("pageBean")), PageBean.class);
        mav.addObject("map", (Object)result);
        mav.addObject("pageBean", (Object)pageBean);
        mav.addObject("goodsProduct", (Object)goodsProduct);
        return mav;
    }

    @RequestMapping(value={"/addHotGoods"})
    public ModelAndView addHotGoods(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView("redirect:/hotGoods.htm");
        String[] productIds = request.getParameterValues("productId[]");
        if (productIds.length > 0) {
            for (int i = 0; i < productIds.length; ++i) {
                Long productId = Long.valueOf(productIds[i]);
                int rows = this.goodsProductService.addHotGoods(productId);
                GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(productId);
                this.searchAsyncService.updateOneGoodsIndexToEs(goodsProductDetailViewVo.getGoodsId());
            }
        }
        return mav;
    }

    @RequestMapping(value={"/delHotGoods"})
    public ModelAndView delHotGoods(Long goodsId) {
        ModelAndView mav = new ModelAndView("redirect:/hotGoods.htm");
        int rows = this.goodsProductService.delHotGoods(goodsId);
        GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(goodsId);
        this.searchAsyncService.updateOneGoodsIndexToEs(goodsProductDetailViewVo.getGoodsId());
        return mav;
    }
}

