/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.redis.RedisAdapter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Controller
public class SystemInterceptor
extends HandlerInterceptorAdapter {
    private static final String BASEURL = "baseUrl";
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource
    private RedisAdapter redisAdapter;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String baseUrl;
        String uri1 = request.getServletPath();
        if (uri1.indexOf("uploadgallery") == -1 && ((baseUrl = (String)request.getSession().getAttribute(BASEURL)) == null || "".equals(baseUrl))) {
            request.getSession().setAttribute(BASEURL, (Object)"");
        }
        String[] noFilterUrls = new String[]{"/securitycenter.htm", "/myinfo", "/queryMyConsume", "/queryMyCoupon", "/refundlist"};
        String uri = request.getServletPath();
        boolean beFilter = false;
        boolean isDecorateFilter = false;
        for (String s : noFilterUrls) {
            if (uri.indexOf(s) == -1) continue;
            beFilter = true;
            break;
        }
        String path = request.getContextPath();
        HttpSession session = request.getSession();
        if (beFilter && uri1.indexOf("uploadgallery") == -1) {
            Long customerId = (Long)session.getAttribute("customerId");
            Long decorateId = (Long)session.getAttribute("decorateId");
            int custCount = this.customerServiceMapper.selectCustCount(customerId);
            if (customerId == null || custCount <= 0) {
                response.sendRedirect(path + "/login.html");
                return false;
            }
            if (isDecorateFilter && decorateId == null) {
                response.sendRedirect(path + "/index.html");
                return false;
            }
            return true;
        }
        return true;
    }
}

