/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.service;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.bean.Trade;
import com.qianjiang.deposit.service.TradeService;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.site.customer.deposit.bean.DepositConst;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.system.bean.Receivables;
import com.qianjiang.system.service.ReceivablesService;
import com.qianjiang.utils.SecurityUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SiteDepositService
extends DepositService {
    @Autowired
    private TradeService tradeService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="receivablesService")
    private ReceivablesService receivablesService;
    @Resource(name="SiteOrderService")
    private SiteOrderService siteOrderService;
    @Autowired
    OrderService orderService;

    @Transactional
    public JSONObject pay(BigDecimal totalFee, Deposit deposit, String payPassword, Long orderId, String orderCode) {
        JSONObject retjson = new JSONObject();
        JSONObject checkjson = this.payCheck(totalFee, deposit, payPassword, orderId, orderCode);
        String retcode = checkjson.getString("retcode");
        if ("-1".equals(retcode)) {
            return checkjson;
        }
        Order order = this.siteOrderService.getPayOrder(orderId);
        List orderslist = this.siteOrderService.getPayOrderByOldCode(order.getOrderOldCode());
        if (!CollectionUtils.isEmpty((Collection)orderslist)) {
            for (int i = 0; i < orderslist.size(); ++i) {
                Order childOrder = (Order)orderslist.get(i);
                this.chechOrderStatus(childOrder);
            }
        } else {
            this.chechOrderStatus(order);
        }
        retjson.put("msg", (Object)"\u652f\u4ed8\u5b8c\u6210");
        retjson.put("retcode", (Object)"0");
        return retjson;
    }

    @Transactional
    public void genTradeByOrder(Order order, Long customerId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("customerId", customerId);
        Deposit deposit = this.getDeposit(queryMap);
        BigDecimal preDeposit = deposit.getPreDeposit();
        BigDecimal totalFee = order.getOrderPrice();
        String orderCode = order.getOrderCode();
        Trade tTrade = new Trade();
        tTrade.setCustomerId(customerId);
        tTrade.setOrderPrice(totalFee);
        tTrade.setCreatePerson(customerId);
        tTrade.setCreateTime(new Date());
        tTrade.setOrderCode(orderCode);
        tTrade.setOrderType("3");
        tTrade.setDelFlag("0");
        tTrade.setTradeSource("\u8ba2\u5355\u6d88\u8d39");
        StringBuilder sb = new StringBuilder();
        sb.append("\u8ba2\u5355\u7f16\u53f7:").append(orderCode);
        tTrade.setTradeRemark(sb.toString());
        deposit.setPreDeposit(preDeposit.subtract(totalFee));
        tTrade.setCurrentPrice(deposit.getPreDeposit().add(deposit.getFreezePreDeposit()));
        HashMap<String, Number> updateParam = new HashMap<String, Number>();
        updateParam.put("customerId", customerId);
        updateParam.put("preDeposit", preDeposit.subtract(totalFee));
        this.updateDeposit(updateParam);
        this.tradeService.saveTrade(tTrade);
    }

    public void chechOrderStatus(Order order) {
        Order or = order;
        String orderCode = or.getOrderCode();
        if ("0".equals(or.getOrderStatus())) {
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("orderId", or.getOrderId());
            updateMap.put("status", "1");
            updateMap.put("payId", DepositConst.PAY_ID);
            this.orderService.updateOrderStatusAndPayId(updateMap);
            Receivables receivables = this.receivablesService.queryByOrderCode(orderCode);
            if (null != receivables) {
                receivables.setReceivablesTime(new Date());
                this.receivablesService.updatePayStatus(receivables);
            }
            this.genTradeByOrder(order, order.getCustomerId());
        }
    }

    public JSONObject preCheck(BigDecimal totalFee, Deposit deposit, String payPassword, Long orderId, String orderCode) {
        JSONObject retjson = new JSONObject();
        int errorCount = deposit.getPasswordErrorCount();
        String tpayPassword = deposit.getPayPassword();
        long customerId = deposit.getCustomerId();
        if (StringUtils.isBlank((CharSequence)tpayPassword)) {
            retjson.put("retcode", (Object)"-1");
            retjson.put("predeposit", (Object)deposit.getPreDeposit());
            retjson.put("msg", (Object)DepositConst.NOT_SET_DEPOSIT_PAY_PASSWORD);
            retjson.put("depositerror", (Object)DepositConst.NOT_SET_DEPOSIT_PAY_PASSWORD);
            retjson.put("errorcode", (Object)"1");
            return retjson;
        }
        if (errorCount >= DepositConst.ERROR_TRY_COUNT) {
            retjson.put("retcode", (Object)"-1");
            retjson.put("msg", (Object)DepositConst.REACH_ERROR_COUNT_THRESHOLD);
            retjson.put("passwordError", (Object)DepositConst.REACH_ERROR_COUNT_THRESHOLD);
            retjson.put("predeposit", (Object)deposit.getPreDeposit());
            retjson.put("orderprice", (Object)totalFee);
            retjson.put("errorcode", (Object)"2");
            return retjson;
        }
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            retjson.put("msg", (Object)"\u8ba2\u5355code\u4e3a\u7a7a");
            retjson.put("retcode", (Object)"-1");
            return retjson;
        }
        BigDecimal preDeposit = deposit.getPreDeposit();
        retjson.put("predeposit", (Object)preDeposit);
        retjson.put("orderprice", (Object)totalFee);
        if (preDeposit.compareTo(totalFee) < 0) {
            retjson.put("msg", (Object)DepositConst.INSUFFICIENCE_DEPOSIT);
            retjson.put("retcode", (Object)"-1");
        } else {
            retjson.put("msg", (Object)DepositConst.OK);
            retjson.put("retcode", (Object)"0");
        }
        return retjson;
    }

    @Transactional
    public JSONObject payCheck(BigDecimal totalFee, Deposit deposit, String payPassword, Long orderId, String orderCode) {
        JSONObject retjson = new JSONObject();
        int errorCount = deposit.getPasswordErrorCount();
        String tpayPassword = deposit.getPayPassword();
        long customerId = deposit.getCustomerId();
        if (StringUtils.isBlank((CharSequence)tpayPassword)) {
            retjson.put("retcode", (Object)"-1");
            retjson.put("msg", (Object)DepositConst.NOT_SET_DEPOSIT_PAY_PASSWORD);
            return retjson;
        }
        if (errorCount >= DepositConst.ERROR_TRY_COUNT) {
            retjson.put("retcode", (Object)"-1");
            retjson.put("msg", (Object)DepositConst.REACH_ERROR_COUNT_THRESHOLD);
            return retjson;
        }
        CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(Long.valueOf(customerId));
        String encodePwd = SecurityUtil.getStoreLogpwd((String)customer.getUniqueCode(), (String)payPassword, (String)customer.getSaltVal());
        if (!StringUtils.equals((CharSequence)encodePwd, (CharSequence)tpayPassword)) {
            int leftCount;
            retjson.put("retcode", (Object)"-1");
            retjson.put("msg", (Object)DepositConst.PIN_ERROR);
            HashMap<String, Number> updataParam = new HashMap<String, Number>();
            updataParam.put("customerId", deposit.getCustomerId());
            updataParam.put("passwordErrorCount", ++errorCount);
            this.updateDeposit(updataParam);
            if (errorCount >= DepositConst.ERROR_TRY_COUNT) {
                retjson.put("msg", (Object)DepositConst.REACH_ERROR_COUNT_THRESHOLD);
            }
            if ((leftCount = DepositConst.ERROR_TRY_COUNT - errorCount) > 0) {
                retjson.put("msg", (Object)("\u652f\u4ed8\u5bc6\u7801\u9519\u8bef\uff0c\u60a8\u8fd8\u6709" + leftCount + "\u6b21\u673a\u4f1a"));
            }
            return retjson;
        }
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            retjson.put("msg", (Object)"\u8ba2\u5355code\u4e3a\u7a7a");
            retjson.put("retcode", (Object)"-1");
        }
        BigDecimal preDeposit = deposit.getPreDeposit();
        retjson.put("predeposit", (Object)preDeposit);
        retjson.put("orderprice", (Object)totalFee);
        if (preDeposit.compareTo(totalFee) < 0) {
            retjson.put("msg", (Object)DepositConst.INSUFFICIENCE_DEPOSIT);
            retjson.put("retcode", (Object)"-1");
        } else {
            retjson.put("msg", (Object)DepositConst.OK);
        }
        return retjson;
    }
}

