/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.threepart.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.site.shoppingcart.service.ShoppingCartService;
import com.qianjiang.site.threepart.controller.AfterLoginQQController;
import com.qianjiang.site.threepart.util.StringUtil;
import com.qianjiang.site.threepart.util.WeiXinMessage;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.threepart.bean.ThreePart;
import com.qianjiang.threepart.service.ThreePartService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AfterLoginWeixinController
extends HttpServlet {
    private static final MyLogger LOGGER = new MyLogger(AfterLoginQQController.class);
    private AuthService authService;
    private CustomerServiceMapper customerServiceMapper;
    private ThreePartService threePartService;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="ShoppingCartService1")
    private ShoppingCartService shoppingCartService;

    @RequestMapping(value={"afterloginweixin"})
    public ModelAndView afterLoginWeixin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        String preurl = request.getParameter("myurl");
        try {
            Auth auth = this.authService.findAuthByAuthType("7");
            if (auth != null) {
                String appID = auth.getAuthClientId();
                String appKEY = auth.getAuthClientSecret();
                String code = request.getParameter("code");
                String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appID + "&secret=" + appKEY + "&code=" + code + "&grant_type=authorization_code";
                GetMethod getMethod = new GetMethod(url);
                HttpClient client = new HttpClient();
                Map<String, String> pmap = null;
                client.executeMethod((HttpMethod)getMethod);
                String userInfo = getMethod.getResponseBodyAsString();
                pmap = StringUtil.formatString(userInfo);
                if (pmap == null) {
                    return new ModelAndView((View)new RedirectView("404.html"));
                }
                String accessToken = pmap.get("access_token");
                String openid = pmap.get("openid");
                ThreePart tp = this.threePartService.selectThreePart(openid);
                if (tp != null) {
                    CustomerAllInfo cus = this.customerServiceMapper.queryCustomerById(tp.getThreePartMemberId());
                    request.getSession().setAttribute("cust", (Object)cus);
                    request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
                    request.getSession().setAttribute("isThirdLogin", (Object)"1");
                } else {
                    Map<String, String> userData = WeiXinMessage.getWeiXinMessage(accessToken, openid);
                    CustomerAllInfo allInfo = new CustomerAllInfo();
                    allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
                    allInfo.setPointLevelId(Long.valueOf(2L));
                    allInfo.setCustomerUsername(userData.get("nickname"));
                    allInfo.setCustomerPassword("");
                    allInfo.setCustomerNickname(userData.get("nickname"));
                    allInfo.setInfoGender("1".equals(userData.get("sex")) ? "1" : "2");
                    allInfo.setCustomerImg(userData.get("headimgurl").toString());
                    int f = this.customerServiceMapper.addCustomer(allInfo);
                    if (f == 1) {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("username", userData.get("nickname"));
                        paramMap.put("password", "");
                        Customer customer = this.customerService.selectCustomerByNamePwd(paramMap);
                        tp = new ThreePart();
                        tp.setThreePartUid(openid);
                        tp.setThreePartToken(accessToken);
                        tp.setThreePartMemberId(customer.getCustomerId());
                        this.threePartService.insertThreePart(tp);
                        CustomerAllInfo cus = this.customerServiceMapper.queryCustomerById(tp.getThreePartMemberId());
                        request.getSession().setAttribute("cust", (Object)cus);
                        request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
                        request.getSession().setAttribute("isThirdLogin", (Object)"1");
                    }
                }
                this.shoppingCartService.loadCoodeShopping(request);
                Cookie cook = new Cookie("_mall_store_shopcar", null);
                cook.setMaxAge(-1);
                cook.setPath("/");
                response.addCookie(cook);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5fae\u4fe1\u9519\u8bef" + e);
        }
        if (StringUtils.isNotEmpty((String)preurl) && preurl.indexOf("myshoppingcart") != -1) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/myshoppingcart.html"));
        }
        return new ModelAndView("redirect:/");
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    @Resource(name="authService")
    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public ThreePartService getThreePartService() {
        return this.threePartService;
    }

    @Resource(name="ThreePartService")
    public void setThreePartService(ThreePartService threePartService) {
        this.threePartService = threePartService;
    }
}

