/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.util;

import com.qianjiang.common.util.NpCookieUtil;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SearchCookieController {
    public static final String COOKIENAME = "searchProduct";
    public static final int MAXAGE = 259200;
    private static final MyLogger LOGGER = new MyLogger(SearchCookieController.class);

    @ResponseBody
    @RequestMapping(value={"/getSearchCookieTop10"}, produces={"application/json;charset=UTF-8"})
    public String[] getSearchCookieTop10(HttpServletRequest request, HttpServletResponse response) {
        String[] searchs = null;
        Cookie cookie = NpCookieUtil.getCookieByName(request, COOKIENAME);
        if (null != cookie) {
            try {
                String cookies = URLDecoder.decode(cookie.getValue(), "utf-8");
                searchs = cookies.split(",");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return searchs;
    }

    @ResponseBody
    @RequestMapping(value={"/delSearchCookie"}, produces={"application/json;charset=UTF-8"})
    public void delSearchCookie(String title, HttpServletRequest request, HttpServletResponse response) {
        String list = "";
        String[] searchs = null;
        Cookie cookie = NpCookieUtil.getCookieByName(request, COOKIENAME);
        if (null != cookie) {
            try {
                String cookies = URLDecoder.decode(cookie.getValue(), "utf-8");
                searchs = cookies.split(",");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
            }
            for (int i = 0; i < searchs.length; ++i) {
                if (searchs[i].equals(title)) continue;
                list = "".equals(list) ? searchs[i] + "," : list + searchs[i] + ",";
            }
            try {
                if ("".equals(list)) {
                    NpCookieUtil.addCookie(response, COOKIENAME, list, 0);
                } else {
                    NpCookieUtil.addCookie(response, COOKIENAME, list, 259200);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

