/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.util;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.des.DESCoder;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.MyLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class GenerateLinkUtils {
    private static final String CHECK_CODE = "checkCode";
    private static final String KEY = "5qian2mi0";
    private static final MyLogger LOGGER = new MyLogger(GenerateLinkUtils.class);

    private GenerateLinkUtils() {
    }

    public static String generateActivateLink(HttpServletRequest request, CustomerAllInfo user) throws Exception {
        String url = request.getRequestURL().toString();
        String key = DESCoder.initKey();
        while (key.indexOf("+") >= 0) {
            key = DESCoder.initKey();
        }
        byte[] inputData1 = user.getCustomerId().toString().getBytes();
        inputData1 = DESCoder.encrypt((byte[])inputData1, (String)key);
        byte[] inputData2 = user.getInfoEmail().getBytes();
        inputData2 = DESCoder.encrypt((byte[])inputData2, (String)key);
        if ((url = url.substring(0, url.lastIndexOf("/")) + "/validbindemail.html?" + CHECK_CODE + "=" + GenerateLinkUtils.generatePwdCheckcode((Customer)user) + "&d=" + DESCoder.encryptBASE64((byte[])inputData1) + "&mail=" + DESCoder.encryptBASE64((byte[])inputData2) + "&k=" + key).indexOf("+") > 0) {
            url = url.replaceAll("\\+", KEY);
        }
        return url;
    }

    public static String forgetgenerateActivateLink(HttpServletRequest request, CustomerAllInfo user) throws Exception {
        String url = request.getRequestURL().toString();
        String key = DESCoder.initKey();
        while (key.indexOf("+") >= 0) {
            key = DESCoder.initKey();
        }
        byte[] inputData1 = user.getCustomerId().toString().getBytes();
        inputData1 = DESCoder.encrypt((byte[])inputData1, (String)key);
        byte[] inputData2 = user.getInfoEmail().getBytes();
        inputData2 = DESCoder.encrypt((byte[])inputData2, (String)key);
        String checkCode = GenerateLinkUtils.generatePwdCheckcode((Customer)user);
        if ((url = url.substring(0, url.lastIndexOf("/")) + "/validate/newvalidbindemail.html?" + CHECK_CODE + "=" + checkCode + "&d=" + DESCoder.encryptBASE64((byte[])inputData1) + "&mail=" + DESCoder.encryptBASE64((byte[])inputData2) + "&k=" + key).indexOf("+") > 0) {
            url = url.replaceAll("\\+", KEY);
        }
        request.getSession().setAttribute("user", (Object)user);
        request.getSession().setAttribute("uId", (Object)user.getCustomerId());
        request.getSession().setAttribute("email_checkCode", (Object)checkCode);
        return url;
    }

    public static String generateFindPwdLink(HttpServletRequest request, Customer user) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.lastIndexOf("/")) + "/validpwdemail.html?" + CHECK_CODE + "=" + GenerateLinkUtils.generatePwdCheckcode(user) + "&d=" + user.getCustomerId();
    }

    public static String generateCheckEmailLink(HttpServletRequest request, Customer user) throws Exception {
        String url = request.getRequestURL().toString();
        String key = DESCoder.initKey();
        while (key.indexOf("+") >= 0) {
            key = DESCoder.initKey();
        }
        byte[] inputData1 = user.getCustomerId().toString().getBytes();
        inputData1 = DESCoder.encrypt((byte[])inputData1, (String)key);
        byte[] inputData2 = request.getSession().getAttribute("utype").toString().getBytes();
        inputData2 = DESCoder.encrypt((byte[])inputData2, (String)key);
        if ((url = url.substring(0, url.lastIndexOf("/")) + "/valididemail.html?" + CHECK_CODE + "=" + GenerateLinkUtils.generatePwdCheckcode(user) + "&type=" + DESCoder.encryptBASE64((byte[])inputData2) + "&d=" + DESCoder.encryptBASE64((byte[])inputData1) + "&k=" + key).indexOf("+") >= 0) {
            url = url.replaceAll("\\+", KEY);
        }
        return url;
    }

    public static String generateCheckcode(Customer user) {
        return GenerateLinkUtils.md5(String.valueOf(new Date().getTime()));
    }

    public static String generatePwdCheckcode(Customer user) {
        Date d = new Date();
        user.setPwdAeadTime(d);
        user.setPwdCaptcha(GenerateLinkUtils.md5(String.valueOf(d.getTime())));
        return user.getPwdCaptcha();
    }

    public static int verifyCheckcode(Customer user, ServletRequest request) {
        String checkCode = request.getParameter(CHECK_CODE);
        if (GenerateLinkUtils.generateCheckcode(user).equals(checkCode)) {
            return 1;
        }
        return 0;
    }

    public static String md5(String string) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("md5");
            md.update(string.getBytes());
            byte[] md5Bytes = md.digest();
            return GenerateLinkUtils.bytes2Hex(md5Bytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("", (Throwable)e);
            return new String();
        }
    }

    private static String bytes2Hex(byte[] byteArray) {
        StringBuilder strBuf = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] >= 0 && byteArray[i] < 16) {
                strBuf.append("0");
            }
            strBuf.append(Integer.toHexString(byteArray[i] & 0xFF));
        }
        return strBuf.toString();
    }
}

