/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.login.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.license.service.LicenseImportService;
import com.qianjiang.site.login.service.LoginService;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LoginController {
    private static final MyLogger LOGGER = new MyLogger(LoginController.class);
    private static final String MEMBER_LOGIN = "/login/memberlogin";
    private static final String INDEX_HTML = "index.html";
    private static final String _MALL_USERNAME = "_mall_username";
    private static final Long LOGINMAXERRORCOUNT = 5L;
    private static final Long LOCKMAXTIME = 30L;
    @Resource(name="LoginService")
    private LoginService loginService;
    @Resource(name="authService")
    private AuthService authService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerService;
    @Resource(name="licenseImportService")
    public LicenseImportService licenseImportService;

    @RequestMapping(value={"/customer/login"})
    public ModelAndView login(HttpServletRequest request, String url, String isTemp, Long[] box) {
        ModelAndView mav = new ModelAndView();
        request.getSession().removeAttribute("is_temp_cust");
        String urlEmp = url;
        try {
            String status;
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            List findByShow = this.authService.findByShow();
            resultMap.put("isTemp", isTemp);
            resultMap.put("box", box);
            resultMap.put("t", findByShow);
            String preUrl = request.getHeader("Referer");
            if (this.isNotUseReferUrl(url)) {
                preUrl = null;
            }
            if (StringUtils.isNotEmpty((String)preUrl)) {
                preUrl = URLDecoder.decode(preUrl, "utf-8");
            }
            if ("1".equals(status = request.getParameter("status"))) {
                this.setResultMap(request, resultMap, urlEmp);
                mav.addAllObjects(resultMap);
                mav.setViewName(MEMBER_LOGIN);
                return this.topAndBottomService.getBottom(mav);
            }
            if (preUrl != null) {
                String strRegex = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([0-9a-z][0-9a-z-]{0,61}))(:[0-9]{1,5})?" + request.getContextPath() + "/";
                urlEmp = preUrl.replaceFirst(strRegex, "");
            } else {
                preUrl = (String)request.getSession().getAttribute("preferUrl");
                if (this.isNotUseReferUrl(url)) {
                    preUrl = null;
                }
                preUrl = preUrl == null ? urlEmp : preUrl;
                urlEmp = preUrl != null ? preUrl : INDEX_HTML;
            }
            if (urlEmp.indexOf("register") != -1 || urlEmp.indexOf("success") != -1 || urlEmp.length() == 0 || urlEmp.indexOf("updatesucess") != -1) {
                urlEmp = INDEX_HTML;
            }
            if (urlEmp.indexOf("validateidentity") != -1 || urlEmp.indexOf("reirectpem") != -1) {
                urlEmp = "customer/securitycenter.html";
            }
            this.setResultMap(request, resultMap, urlEmp);
            mav.addAllObjects(resultMap);
            mav.setViewName(MEMBER_LOGIN);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u767b\u5f55\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getBottom(mav);
    }

    private boolean isNotUseReferUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        return url.indexOf("cosult/") != -1;
    }

    @RequestMapping(value={"/customer/logout"})
    public ModelAndView loginOut(HttpServletRequest request, String url) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List findByShow = this.authService.findByShow();
        resultMap.put("t", findByShow);
        String url1 = url;
        if (url1 == null) {
            url1 = INDEX_HTML;
        }
        request.getSession().removeAttribute("cust");
        request.getSession().removeAttribute("customerId");
        request.getSession().removeAttribute("isThirdLogin");
        request.getSession().removeAttribute("bsetDomain");
        this.setResultMap(request, resultMap, url1);
        return this.topAndBottomService.getBottom(new ModelAndView(MEMBER_LOGIN).addAllObjects(resultMap));
    }

    @RequestMapping(value={"/checklogin"})
    @ResponseBody
    public Object checkLogin(HttpServletRequest request, HttpServletResponse response, String username, String password, String url, String type) {
        Object result = null;
        String url1 = url;
        try {
            String flag = this.licenseImportService.isQualified("user");
            if (!"1".equals(flag)) {
                result = flag;
                return result;
            }
            int status = this.loginService.checkCustomerExists(request, username, password);
            if (status == 1) {
                Customer customer = this.customerService.getCustomerByUsernameType(username);
                if (customer != null && null != customer.getLoginLockTime() && ((status = this.getTimeDifference(customer.getLoginLockTime(), customer.getLoginTime(), customer, request, username, password)) == 4 || status == 8)) {
                    result = status;
                    return result;
                }
                if ("0".equals(type)) {
                    Cookie cookie = new Cookie(_MALL_USERNAME, URLEncoder.encode(username, "utf-8"));
                    cookie.setMaxAge(604800);
                    response.addCookie(cookie);
                } else if ("1".equals(type)) {
                    Cookie nameCookie = new Cookie(_MALL_USERNAME, URLEncoder.encode(username, "utf-8"));
                    nameCookie.setMaxAge(604800);
                    response.addCookie(nameCookie);
                }
                Cookie cook = new Cookie("_mall_store_shopcar", null);
                cook.setMaxAge(-1);
                cook.setPath("/");
                response.addCookie(cook);
                if ("order/suborder.html".equals(url1) || "suborder.html".equals(url1)) {
                    url1 = INDEX_HTML;
                }
                if ("order/subgrouponorder.html".equals(url1) || "subgrouponorder.html".equals(url1)) {
                    url1 = INDEX_HTML;
                }
                if ("order/submrorder.html".equals(url1) || "submrorder.html".equals(url1)) {
                    url1 = INDEX_HTML;
                }
                LOGGER.info((Object)("\u9a8c\u8bc1\u4f1a\u5458\u3010" + username + "\u3011\u767b\u9646"));
                customer.setLoginErrorCount(Long.valueOf(0L));
                this.customerService.updateCusErrorCount(customer);
                url1 = this.encodeURL(url1, "utf-8");
                result = url1;
                return result;
            }
            if (status == 3) {
                result = status;
                return result;
            }
            if (status == 2) {
                result = status;
                return result;
            }
            result = this.updateOrrerCountNew(username, request, password);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u9a8c\u8bc1\u767b\u5f55\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public Object updateOrrerCount(String username, HttpServletRequest request, String password) {
        Customer customer = this.customerService.getCustomerByUsername(username);
        if (null != customer) {
            if (null == customer.getLoginLockTime()) {
                Long loginErrorCount = Long.valueOf(customer.getLoginErrorCount()) + 1L;
                customer.setLoginErrorCount(loginErrorCount);
                this.customerService.updateCusErrorCount(customer);
            }
            if (customer.getLoginErrorCount() > LOGINMAXERRORCOUNT) {
                if (null != customer.getLoginLockTime()) {
                    return this.getTimeDifference(customer.getLoginLockTime(), new Date(), customer, request, username, password);
                }
                customer.setLoginLockTime(new Date());
                this.customerService.updateCusLock(customer);
            }
        }
        return 0;
    }

    public Object updateOrrerCountNew(String username, HttpServletRequest request, String password) {
        Customer customer = this.customerService.getCustomerByUsername(username);
        if (null != customer) {
            if (null == customer.getLoginLockTime()) {
                Long loginErrorCount = Long.valueOf(customer.getLoginErrorCount()) + 1L;
                customer.setLoginErrorCount(loginErrorCount);
                this.customerService.updateCusErrorCount(customer);
            }
            if (customer.getLoginErrorCount() > LOGINMAXERRORCOUNT) {
                if (null != customer.getLoginLockTime()) {
                    return this.getTimeDifference(customer.getLoginLockTime(), new Date(), customer, request, username, password);
                }
                customer.setLoginLockTime(new Date());
                this.customerService.updateCusLock(customer);
            }
            customer.setLoginKey(null);
            customer.setCustomerPassword(null);
        }
        return customer;
    }

    public int getTimeDifference(Date loginLockTime, Date loginTime, Customer customer, HttpServletRequest request, String username, String password) {
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        String lockTimeYear = loginLockTime.toString();
        String loginTimeYear = loginTime.toString();
        lockTimeYear = lockTimeYear.substring(lockTimeYear.length() - 4, lockTimeYear.length());
        loginTimeYear = loginTimeYear.substring(loginTimeYear.length() - 4, loginTimeYear.length());
        c1.set(Integer.valueOf(lockTimeYear), loginLockTime.getMonth() + 1, loginLockTime.getDate(), loginLockTime.getHours(), loginLockTime.getMinutes());
        c2.set(Integer.valueOf(loginTimeYear), loginTime.getMonth() + 1, loginTime.getDate(), loginTime.getHours(), loginTime.getMinutes());
        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long diff = time2 - time1;
        long diffMin = diff / 60000L;
        if (diffMin < LOCKMAXTIME) {
            customer.setLoginLockTime(new Date());
            this.customerService.updateCusLock(customer);
            return 8;
        }
        customer.setLoginLockTime(null);
        customer.setLoginErrorCount(Long.valueOf(0L));
        this.customerService.updateCusErrorCount(customer);
        int status = this.loginService.checkCustomerExists(request, username, password);
        if (status == 1) {
            return 1;
        }
        return 4;
    }

    public void setResultMap(HttpServletRequest request, Map<String, Object> resultMap, String url) {
        String username = "";
        Cookie[] cookies = request.getCookies();
        try {
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (cookie == null || !_MALL_USERNAME.equals(cookie.getName())) continue;
                    username = URLDecoder.decode(cookie.getValue(), "utf-8");
                    break;
                }
            }
            resultMap.put("username", username);
            resultMap.put("url", url);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8bbe\u7f6e\u7ed3\u679c\u96c6\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    private String encodeURL(String url, String encode) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        StringBuilder noAsciiPart = new StringBuilder();
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c > '\u00ff') {
                noAsciiPart.append(c);
                continue;
            }
            if (noAsciiPart.length() != 0) {
                sb.append(URLEncoder.encode(noAsciiPart.toString(), encode));
                noAsciiPart.delete(0, noAsciiPart.length());
            }
            sb.append(c);
        }
        return sb.append(URLEncoder.encode(noAsciiPart.toString(), encode)).toString();
    }
}

