/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index;

import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.channel.service.ChannelGoodsService;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.hotsearch.bean.HotSearch;
import com.qianjiang.hotsearch.service.HotSearchService;
import com.qianjiang.index.bean.IndexClassifyBar;
import com.qianjiang.index.service.IndexSiteService;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.bean.HelpCateBean;
import com.qianjiang.system.bean.SeoConf;
import com.qianjiang.system.mobile.bean.MobSiteBasic;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.service.IOnLineServiceBiz;
import com.qianjiang.system.service.IOnLineServiceItemBiz;
import com.qianjiang.system.service.ISeoConfBiz;
import com.qianjiang.system.service.IStatisticsCodeBiz;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PreviewTempController {
    private static final Long ATID1 = 157L;
    private static final Long ATID2 = 159L;
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;
    private static final MyLogger LOGGER = new MyLogger(PreviewTempController.class);
    @Resource(name="seoConfBizImpl")
    private ISeoConfBiz seoconfbiz;
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="IndexSiteService")
    private IndexSiteService indexSiteService;
    @Resource(name="ChannelBarService")
    private ChannelBarService channelBarService;
    @Resource(name="hotSearchService")
    private HotSearchService hotSearchService;
    @Resource(name="InformationService")
    private InformationService infoService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="InformationOnePageService")
    private InformationOnePageService onePageService;
    @Resource(name="shareServiceNew")
    private ShareService shareService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="ChannelGoodsService")
    private ChannelGoodsService channelGoodsService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="statisticsCodeBizImpl")
    private IStatisticsCodeBiz statisticsCodeBizImpl;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="ChannelTrademarkService")
    private ChannelTrademarkService channelTrademarkService;
    @Resource(name="onLineServiceItemBizImpl")
    private IOnLineServiceItemBiz onLineServiceItemService;
    @Resource(name="onLineServiceBizImpl")
    private IOnLineServiceBiz onLineServiceBiz;

    @RequestMapping(value={"preview"})
    public ModelAndView indexView(HttpServletRequest request, Long tempId) {
        ModelAndView mav = new ModelAndView();
        SysTemp temp = this.getTempByTempId(tempId);
        mav.setViewName("preview/" + temp.getTempUrl());
        mav.addObject("sys", (Object)this.basicSetService.findBasicSet());
        mav.addObject("temp", (Object)temp);
        mav.addObject("floor", (Object)this.indexSiteService.getStoreys(Long.valueOf(temp.getTempId())));
        String expFleid2 = temp.getExpFleid2();
        mav.addObject("infoName", (Object)expFleid2);
        mav.addObject("infoList", (Object)this.infoService.selectByInfoType(Long.valueOf(temp.getExpFleid1())));
        mav.addObject("avc", (Object)this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID1, ADVERTTYPE, null, "0", null, "0"));
        mav.addObject("avs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID2, ADVERTTYPE, null, "0", null, "0"));
        mav.addObject("pageAdvs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID3, ADVERTTYPE, null, "0", null, "0"));
        mav.addObject("hotSale", (Object)this.channelGoodsService.selectchannelStoreyGoodsByParamForSite(String.valueOf(temp.getTempId()), null, null));
        mav.addObject("tags", (Object)this.indexSiteService.getTagListForTempId(Long.valueOf(temp.getTempId())));
        if (null != temp.getStandby4()) {
            mav.addObject("onepages", (Object)this.onePageService.selectInfoOPByTempAndTag(Long.valueOf(temp.getTempId()), Long.valueOf(temp.getStandby4())));
        }
        mav.addObject("shares", (Object)this.shareService.getTopShare(10));
        mav.addObject("sCodeList", (Object)this.statisticsCodeBizImpl.getCurrStatisticsCode());
        mav.addObject("notice", (Object)this.customerServiceInterface.selectNotice((Long)request.getSession().getAttribute("customerId")));
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        MobSiteBasic mobSiteBasic = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
        if (null != mobSiteBasic) {
            String mobProjectUrl = mobSiteBasic.getSiteAddress();
            mav.addObject("mobProjectUrl", (Object)mobProjectUrl);
        }
        HashMap<String, List> bottom = new HashMap<String, List>();
        HashMap<String, Object> topmap = new HashMap<String, Object>();
        mav.addObject("temp", (Object)temp);
        topmap.put("temp", temp);
        topmap.put("seo", this.getSeo());
        topmap.put("systembase", this.basicSetService.findBasicSet());
        bottom.put("helpCates", this.getHelpCateList());
        bottom.put("helpCenters", this.helpCenterService.selectAllIsFoot());
        mav.addObject("bottom", bottom);
        HashMap<String, Object> top = new HashMap<String, Object>();
        top.put("temp", temp);
        List pageAdvList = this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID3, ADVERTTYPE, null, "0", null, "0");
        if (!pageAdvList.isEmpty()) {
            top.put("logoAdv", pageAdvList.get(0));
        }
        topmap.put("hotsearch", this.getRandomHotSearch(this.hotSearchService.selectHotBySelectiveForSite(Long.valueOf(temp.getTempId()), null)));
        IndexClassifyBar classifyBar = this.indexSiteService.getClassifyBar(Long.valueOf(temp.getTempId()));
        topmap.put("classifyBar", classifyBar);
        topmap.put("systembase", this.basicSetService.findBasicSet());
        topmap.put("seo", this.getSeo());
        topmap.put("navList", this.getNav(temp.getTempId()));
        mav.addObject("trademarkList", (Object)this.channelTrademarkService.selectTrademarkByTempId(Long.valueOf(temp.getTempId())));
        mav.addObject("QQs", (Object)this.onLineServiceItemService.selectItemsByType(0));
        mav.addObject("customerService", (Object)this.onLineServiceBiz.selectSetting());
        mav.addObject("topmap", topmap);
        return mav;
    }

    private List<ChannelBar> getNav(int tempId) {
        try {
            return this.channelBarService.selectAllChannelBarByParam(null, Long.valueOf(tempId), null);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5bfc\u822a\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return new ArrayList<ChannelBar>();
        }
    }

    private SysTemp getTempByTempId(Long tempId) {
        try {
            return this.tempService.getSystempById(tempId);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u9996\u9875\u9ed8\u8ba4\u6a21\u677f\u5f02\u5e38\uff01", (Throwable)e);
            return new SysTemp();
        }
    }

    private Set<HotSearch> getRandomHotSearch(List<HotSearch> hotSearchList) {
        HashSet<HotSearch> hotSearchSet = new HashSet<HotSearch>();
        for (HotSearch hotSearch : hotSearchList) {
            hotSearchSet.add(hotSearch);
        }
        return hotSearchSet;
    }

    public SeoConf getSeo() {
        SeoConf seo = this.seoconfbiz.querySeoByUsedStatus();
        if (null == seo) {
            seo = new SeoConf();
            seo.setMeteKey("");
            seo.setMeteDes("");
        }
        return seo;
    }

    private List<HelpCateBean> getHelpCateList() {
        ArrayList<HelpCateBean> helpCateBeans = new ArrayList<HelpCateBean>();
        List helpcates = this.helpCateService.findAll();
        if (null != helpcates && !helpcates.isEmpty()) {
            for (HelpCate helpCate : helpcates) {
                HelpCateBean helpCateBean = new HelpCateBean();
                helpCateBean.setHelpcateId(helpCate.getHelpcateId());
                helpCateBean.setHelpcateName(helpCate.getHelpcateName());
                helpCateBean.setHelpcateImg(helpCate.getHelpcateImg());
                helpCateBean.setHelpCenters(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
                helpCateBeans.add(helpCateBean);
            }
        }
        return helpCateBeans;
    }
}

