/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.controller;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.common.annotation.LoginRequired;
import com.qianjiang.common.util.BaseSiteController;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.bean.WithdrawForm;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.deposit.service.impl.WithdrawService;
import com.qianjiang.deposit.vo.WithdrawVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.util.PageBean;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WithdrawController
extends BaseSiteController {
    @Autowired
    TopAndBottomService topAndBottomService;
    @Autowired
    private WithdrawService siteWithdrawService;
    @Autowired
    private DepositService depositService;

    @RequestMapping(value={"/deposit/withdraw-list"}, method={RequestMethod.GET})
    @LoginRequired
    public ModelAndView list(WithdrawForm form) {
        Long customerId = this.customerId();
        form.setCustomerId(customerId);
        PageBean pb = this.siteWithdrawService.findByCustomerIdAndStatus(form);
        Deposit deposit = this.depositService.findByCustomerId(customerId);
        ModelAndView mav = new ModelAndView("deposit/withdraw_list");
        mav.addObject("pb", (Object)pb);
        mav.addObject("form", (Object)form);
        mav.addObject("pwdExist", (Object)StringUtils.isNotBlank((String)deposit.getPayPassword()));
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/withdraw"}, params={"id"}, method={RequestMethod.GET})
    public ModelAndView info(Long id) {
        WithdrawVo vo = this.siteWithdrawService.findVoById(id, this.customerId());
        ModelAndView mav = new ModelAndView("deposit/withdraw_edit");
        mav.addObject("vo", (Object)vo);
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/withdraw/new"}, method={RequestMethod.GET})
    @LoginRequired
    public ModelAndView add() {
        Deposit deposit = this.depositService.findByCustomerId(this.customerId());
        ModelAndView mav = new ModelAndView("deposit/withdraw_new");
        mav.addObject("deposit", (Object)deposit);
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/withdraw"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONObject create(WithdrawVo vo) {
        vo.setCustomerId(this.customerId());
        return this.siteWithdrawService.create(vo);
    }

    @RequestMapping(value={"/deposit/withdraw/cancel"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONObject cancel(Long id) {
        return this.siteWithdrawService.cancel(id, this.customerId());
    }

    @RequestMapping(value={"/deposit/withdraw/confirm"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONObject confirm(Long id) {
        return this.siteWithdrawService.confirm(id, this.customerId());
    }

    private ModelAndView withTopAndBottom(ModelAndView mav) {
        return this.topAndBottomService.getTopAndBottom(mav);
    }
}

