/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index.service;

import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.channel.service.ChannelGoodsService;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.hotsearch.bean.HotSearch;
import com.qianjiang.hotsearch.service.HotSearchService;
import com.qianjiang.index.bean.IndexClassifyBar;
import com.qianjiang.index.service.IndexSiteService;
import com.qianjiang.index.util.IndexStaticizeUtil;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.bean.HelpCateBean;
import com.qianjiang.system.bean.SeoConf;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.service.IOnLineServiceBiz;
import com.qianjiang.system.service.IOnLineServiceItemBiz;
import com.qianjiang.system.service.ISeoConfBiz;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.bean.TempToken;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.temp.service.TempTokenService;
import com.qianjiang.util.MyLogger;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Service(value="TopAndBottomService")
public class TopAndBottomService {
    private static final MyLogger LOGGER = new MyLogger(TopAndBottomService.class);
    private static final Long ATID1 = 157L;
    private static final Long ATID2 = 159L;
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;
    private static final String SYSTEMBASE = "systembase";
    private static final String TOPMAP = "topmap";
    private static final String HELPCATES = "helpCates";
    private static final String HELPCENTERS = "helpCenters";
    private static final String BOTTOM = "bottom";
    private static final String VIEW_INDEX = "/view/index";
    private static final String TOKEN = "token";
    private static final String REQUEST = "request";
    private static final String LOGGERINFO1 = "\u751f\u6210\u9759\u6001\u5934\u90e8\u9519\u8bef\uff1a=>";
    private static final String LOGGERINFO2 = "\u751f\u6210\u9759\u6001\u9996\u9875\u9519\u8bef\uff1a=>";
    @Autowired
    private HttpServletRequest request;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="seoConfBizImpl")
    private ISeoConfBiz seoconfbiz;
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="IndexSiteService")
    private IndexSiteService indexSiteService;
    @Resource(name="ChannelBarService")
    private ChannelBarService channelBarService;
    @Resource(name="hotSearchService")
    private HotSearchService hotSearchService;
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="InformationService")
    private InformationService infoService;
    @Resource(name="ChannelGoodsService")
    private ChannelGoodsService channelGoodsService;
    @Resource(name="TempTokenService")
    private TempTokenService tokenService;
    @Resource(name="InformationOnePageService")
    private InformationOnePageService onePageService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="onLineServiceItemBizImpl")
    private IOnLineServiceItemBiz onLineServiceItemService;
    @Resource(name="onLineServiceBizImpl")
    private IOnLineServiceBiz onLineServiceBiz;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="ChannelTrademarkService")
    private ChannelTrademarkService channelTrademarkService;
    @Resource
    private RedisAdapter redisAdapter;
    @Resource(name="authService")
    private AuthService authService;

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public ModelAndView getTopAndBottom(ModelAndView mav) {
        SysTemp sysTemp = this.getIndexDefalutTemp();
        int tempId = sysTemp.getTempId();
        this.checkChangeTemp();
        HashMap<String, Object> topmap = new HashMap<String, Object>();
        topmap.put("temp", sysTemp);
        topmap.put("seo", this.getSeo());
        topmap.put("hotsearch", this.getRandomHotSearch(this.hotSearchService.selectHotBySelectiveForSite(Long.valueOf(tempId), null)));
        IndexClassifyBar classifyBar = new IndexClassifyBar();
        classifyBar = this.indexSiteService.getClassifyBar(Long.valueOf(tempId));
        topmap.put("classifyBar", classifyBar);
        topmap.put(SYSTEMBASE, this.basicSetService.findBasicSet());
        String path = this.request.getContextPath();
        String basePath = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + path + "/";
        topmap.put("mobSite", this.mobSiteBasicService.selectCurrMobSiteBasic(basePath));
        mav.addObject(TOPMAP, topmap);
        HashMap<String, List> bottom = new HashMap<String, List>();
        bottom.put(HELPCATES, this.getHelpCateList());
        bottom.put(HELPCENTERS, this.helpCenterService.selectAllIsFoot());
        mav.addObject(BOTTOM, bottom);
        return mav;
    }

    public ModelAndView getBottom(ModelAndView mav) {
        SysTemp temp = this.getIndexDefalutTemp();
        this.checkChangeTemp();
        HashMap<String, List> bottom = new HashMap<String, List>();
        HashMap<String, Object> topmap = new HashMap<String, Object>();
        mav.addObject("temp", (Object)temp);
        topmap.put("temp", temp);
        topmap.put("seo", this.getSeo());
        topmap.put(SYSTEMBASE, this.basicSetService.findBasicSet());
        bottom.put(HELPCATES, this.getHelpCateList());
        bottom.put(HELPCENTERS, this.helpCenterService.selectAllIsFoot());
        List pageAdvList = this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID3, ADVERTTYPE, null, "0", null, "0");
        if (!pageAdvList.isEmpty()) {
            topmap.put("logoAdv", pageAdvList.get(0));
        }
        topmap.put("qqCode", this.authService.findAuthByAuthId(Long.valueOf(17L)));
        topmap.put("sinaCode", this.authService.findAuthByAuthId(Long.valueOf(19L)));
        mav.addObject(BOTTOM, bottom);
        mav.addObject(TOPMAP, topmap);
        return mav;
    }

    public ModelAndView getSimpleTopAndBottom(ModelAndView mav) {
        HashMap<String, Object> top = new HashMap<String, Object>();
        SysTemp temp = this.getIndexDefalutTemp();
        top.put("temp", temp);
        top.put(SYSTEMBASE, this.basicSetService.findBasicSet());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("usedStatus", "1");
        map.put("deleteStatus", "0");
        top.put("seo", this.getSeo());
        mav.addObject(TOPMAP, top);
        HashMap<String, List> bottom = new HashMap<String, List>();
        bottom.put(HELPCATES, this.getHelpCateList());
        bottom.put(HELPCENTERS, this.helpCenterService.selectAllIsFoot());
        mav.addObject(BOTTOM, bottom);
        return mav;
    }

    private void checkChangeTemp() {
        if (this.checkToken(this.request)) {
            String indexHtmlPath;
            File indexHtml;
            String templatePath = this.request.getRealPath("/") + VIEW_INDEX;
            String topHtmlPath = templatePath + "/newheader21.html";
            File topHtml = new File(topHtmlPath);
            if (!topHtml.exists()) {
                try {
                    this.staticizeTop(this.request);
                }
                catch (Exception e) {
                    LOGGER.info((Object)e);
                }
            }
            if (!(indexHtml = new File(indexHtmlPath = templatePath + "/index21.html")).exists()) {
                try {
                    this.staticizeIndex(this.request);
                }
                catch (Exception e) {
                    LOGGER.info((Object)e);
                }
            }
        } else {
            this.staticizeTop(this.request);
            this.staticizeIndex(this.request);
        }
    }

    public boolean checkToken(HttpServletRequest request) {
        boolean flag = true;
        ServletContext application = request.getSession().getServletContext();
        String token = (String)application.getAttribute(TOKEN);
        if (null == token || "".equals(token)) {
            TempToken tk = this.tokenService.selectTokenByType("1");
            if (null != tk) {
                application.setAttribute(TOKEN, (Object)tk.getToken());
            } else {
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update(new Date().toString().getBytes());
                    String tokenValue = new BigInteger(1, md.digest()).toString(16);
                    tk = new TempToken();
                    tk.setTemp1("1");
                    tk.setToken(tokenValue);
                    this.tokenService.createToken(tk);
                    this.redisAdapter.delete("TEMPTOKEN_KEY");
                    application.setAttribute(TOKEN, (Object)tokenValue);
                }
                catch (Exception e) {
                    LOGGER.error("\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
                }
            }
            flag = false;
        } else {
            String tokenValue = this.tokenService.selectTokenByType("1").getToken();
            if (!token.equals(tokenValue)) {
                flag = false;
                application.setAttribute(TOKEN, (Object)tokenValue);
            }
        }
        return flag;
    }

    public void staticizeTop(HttpServletRequest request) {
        String templatePath = request.getRealPath("/") + VIEW_INDEX;
        String templateName = "/newheader21_ftl.ftl";
        String fileName = templatePath + "/newheader21.html";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REQUEST, request);
        try {
            Map<String, Object> topmap = this.getTop();
            map.put(TOPMAP, topmap);
            IndexStaticizeUtil.analysisTemplate(templatePath, templateName, fileName, map);
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO1, (Throwable)e);
        }
    }

    public void staticizeIndex(HttpServletRequest request) {
        String templatePath = request.getRealPath("/") + VIEW_INDEX;
        String templateName = "/index21_ftl.ftl";
        String fileName = templatePath + "/index21.html";
        try {
            IndexStaticizeUtil.analysisTemplate(templatePath, templateName, fileName, this.getIndexInfo(request));
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO2, (Throwable)e);
        }
    }

    public Map<String, Object> getIndexInfo(HttpServletRequest request) {
        SysTemp temp = this.getIndexDefalutTemp();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REQUEST, request);
        map.put("sys", this.basicSetService.findBasicSet());
        map.put("temp", temp);
        map.put("floor", this.indexSiteService.getStoreys(Long.valueOf(temp.getTempId())));
        String expFleid2 = temp.getExpFleid2();
        map.put("infoName", expFleid2);
        map.put("infoList", this.infoService.selectByInfoType(Long.valueOf(temp.getExpFleid1())));
        map.put("avc", this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID1, ADVERTTYPE, null, "0", null, "0"));
        map.put("avs", this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID2, ADVERTTYPE, null, "0", null, "0"));
        map.put("pageAdvs", this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID3, ADVERTTYPE, null, "0", null, "0"));
        map.put("hotSale", this.channelGoodsService.selectchannelStoreyGoodsByParamForSite(String.valueOf(temp.getTempId()), null, null));
        map.put("tags", this.indexSiteService.getTagListForTempId(Long.valueOf(temp.getTempId())));
        map.put("trademarkList", this.channelTrademarkService.selectTrademarkByTempId(Long.valueOf(temp.getTempId())));
        if (null != temp.getStandby4()) {
            map.put("onepages", this.onePageService.selectInfoOPByTempAndTag(Long.valueOf(temp.getTempId()), Long.valueOf(temp.getStandby4())));
        }
        map.put("QQs", this.onLineServiceItemService.selectItemsByType(0));
        map.put("customerService", this.onLineServiceBiz.selectSetting());
        return map;
    }

    public Map<String, Object> getTop() {
        HashMap<String, Object> top = new HashMap<String, Object>();
        SysTemp temp = this.getIndexDefalutTemp();
        top.put("temp", temp);
        List pageAdvList = this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID3, ADVERTTYPE, null, "0", null, "0");
        if (!pageAdvList.isEmpty()) {
            top.put("logoAdv", pageAdvList.get(0));
            if (pageAdvList.size() > 2) {
                top.put("topAdv", pageAdvList.get(2));
            }
        }
        top.put("hotsearch", this.hotSearchService.selectHotBySelectiveForSite(Long.valueOf(temp.getTempId()), null));
        IndexClassifyBar classifyBar = this.indexSiteService.getClassifyBar(Long.valueOf(temp.getTempId()));
        top.put("classifyBar", classifyBar);
        top.put(SYSTEMBASE, this.basicSetService.findBasicSet());
        top.put("seo", this.getSeo());
        top.put("navList", this.getNav(temp.getTempId()));
        top.put("notice", this.customerServiceInterface.selectNotice((Long)this.request.getSession().getAttribute("customerId")));
        top.put("couponNum", this.couponService.myCouponNoCount((Long)this.request.getSession().getAttribute("customerId")));
        top.put("cust", this.request.getSession().getAttribute("cust"));
        String expFleid2 = temp.getExpFleid2();
        top.put("infoName", expFleid2);
        top.put("infoList", this.infoService.selectByInfoType(Long.valueOf(temp.getExpFleid1())));
        return top;
    }

    public SeoConf getSeo() {
        SeoConf seo = (SeoConf)this.redisAdapter.get("SEO_KEY");
        if (null != seo) {
            return seo;
        }
        seo = this.seoconfbiz.querySeoByUsedStatus();
        if (null == seo) {
            seo = new SeoConf();
            seo.setMeteKey("");
            seo.setMeteDes("");
        }
        this.redisAdapter.put("SEO_KEY", (Serializable)seo);
        return seo;
    }

    public SysTemp getIndexDefalutTemp() {
        try {
            return this.tempService.getCurrTemp();
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u9996\u9875\u9ed8\u8ba4\u6a21\u677f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    private Set<HotSearch> getRandomHotSearch(List<HotSearch> hotSearchList) {
        HashSet<HotSearch> hotSearchSet = new HashSet<HotSearch>();
        for (HotSearch hotSearch : hotSearchList) {
            hotSearchSet.add(hotSearch);
        }
        return hotSearchSet;
    }

    private List<ChannelBar> getNav(int tempId) {
        try {
            return this.channelBarService.selectAllChannelBarByParam(null, Long.valueOf(tempId), null);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5bfc\u822a\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return new ArrayList<ChannelBar>();
        }
    }

    private List<HelpCateBean> getHelpCateList() {
        ArrayList<HelpCateBean> helpCateBeans = (ArrayList<HelpCateBean>)this.redisAdapter.get("HELPCATELIST_KEY");
        if (!CollectionUtils.isEmpty((Collection)helpCateBeans)) {
            return helpCateBeans;
        }
        helpCateBeans = new ArrayList<HelpCateBean>();
        List helpcates = this.helpCateService.findAll();
        if (null != helpcates && !helpcates.isEmpty()) {
            for (HelpCate helpCate : helpcates) {
                HelpCateBean helpCateBean = new HelpCateBean();
                helpCateBean.setHelpcateId(helpCate.getHelpcateId());
                helpCateBean.setHelpcateName(helpCate.getHelpcateName());
                helpCateBean.setHelpcateImg(helpCate.getHelpcateImg());
                helpCateBean.setHelpCenters(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
                helpCateBeans.add(helpCateBean);
            }
        }
        this.redisAdapter.put("HELPCATELIST_KEY", new ArrayList(helpCateBeans));
        return helpCateBeans;
    }
}

