/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index;

import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.channel.service.ChannelGoodsService;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.hotsearch.bean.HotSearch;
import com.qianjiang.hotsearch.service.HotSearchService;
import com.qianjiang.index.bean.IndexClassifyBar;
import com.qianjiang.index.service.IndexSiteService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.information.vo.InformationVo;
import com.qianjiang.site.shoppingcart.bean.MiniShoppingCart;
import com.qianjiang.site.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.bean.HelpCateBean;
import com.qianjiang.system.bean.Province;
import com.qianjiang.system.mobile.bean.MobSiteBasic;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.CityService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.FriendLinkService;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.service.IStatisticsCodeBiz;
import com.qianjiang.system.service.ProvinceService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.system.vo.CityVo;
import com.qianjiang.system.vo.DistrictVo;
import com.qianjiang.temp.bean.HomeConfig;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IndexSiteController {
    private static final MyLogger LOGGER = new MyLogger(IndexSiteController.class);
    private static final String EMAILCHECKPWD = "emailCheckPwd";
    private static final String VALIDPWD = "validPwd";
    private static final Long ATID1 = 157L;
    private static final Long ATID2 = 159L;
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="IndexSiteService")
    private IndexSiteService indexSiteService;
    @Resource(name="ChannelBarService")
    private ChannelBarService channelBarService;
    @Resource(name="hotSearchService")
    private HotSearchService hotSearchService;
    @Resource(name="InformationService")
    private InformationService infoService;
    @Resource(name="ShoppingCartService1")
    private ShoppingCartService shoppingcat;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="InformationOnePageService")
    private InformationOnePageService onePageService;
    @Resource(name="shareServiceNew")
    private ShareService shareService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="ChannelGoodsService")
    private ChannelGoodsService channelGoodsService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="statisticsCodeBizImpl")
    private IStatisticsCodeBiz statisticsCodeBizImpl;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="ProvinceService")
    private ProvinceService provinceService;
    @Resource(name="CityService")
    private CityService cityService;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    @Resource(name="friendLinkService")
    private FriendLinkService friendLinkService;

    @RequestMapping(value={"/indexview"})
    public ModelAndView indexView(HttpServletRequest request) {
        if (request.getSession().getAttribute(EMAILCHECKPWD) != null && !"".equals(request.getSession().getAttribute(EMAILCHECKPWD))) {
            request.getSession().setAttribute(EMAILCHECKPWD, (Object)"");
        }
        if (request.getSession().getAttribute(VALIDPWD) != null && !"".equals(request.getSession().getAttribute(VALIDPWD))) {
            request.getSession().setAttribute(VALIDPWD, (Object)"");
        }
        ModelAndView mav = new ModelAndView();
        SysTemp temp = this.getIndexDefalutTemp();
        mav.setViewName(temp.getTempUrl());
        if ("index/index".equals(temp.getTempUrl())) {
            mav = this.initOldTemp(mav, temp);
        } else {
            if (null != temp.getStandby4()) {
                mav.addObject("onepages", (Object)this.onePageService.selectInfoOPByTempAndTag(Long.valueOf(temp.getTempId()), Long.valueOf(temp.getStandby4())));
            }
            mav.addObject("shares", (Object)this.shareService.getTopShare(10));
            mav.addObject("sCodeList", (Object)this.statisticsCodeBizImpl.getCurrStatisticsCode());
            mav = this.topAndBottomService.getBottom(mav);
            String path = request.getContextPath();
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
            MobSiteBasic mobSiteBasic = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
            if (null != mobSiteBasic) {
                String mobProjectUrl = mobSiteBasic.getSiteAddress();
                mav.addObject("mobProjectUrl", (Object)mobProjectUrl);
            }
            mav.addObject("row1", this.tempService.queryHomePageConfigByFloor(Long.valueOf(1L)).get(0));
            mav.addObject("row2", this.tempService.queryHomePageConfigByFloor(Long.valueOf(2L)).get(0));
            HomeConfig row4HomeConfig = new HomeConfig();
            row4HomeConfig.setFloor(3);
            row4HomeConfig.setTag("1");
            mav.addObject("row31", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("2");
            mav.addObject("row32", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("3");
            mav.addObject("row33", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("4");
            mav.addObject("row34", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("5");
            mav.addObject("row35", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("6");
            mav.addObject("row36", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("7");
            mav.addObject("row37", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setFloor(4);
            row4HomeConfig.setTag("text");
            mav.addObject("row4text", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("image");
            mav.addObject("row4image", (Object)this.tempService.queryHomePageConfig(row4HomeConfig));
            row4HomeConfig.setFloor(5);
            row4HomeConfig.setTag("text");
            mav.addObject("row5text", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("qr1");
            mav.addObject("row5qr1", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
            row4HomeConfig.setTag("qr2");
            mav.addObject("row5qr2", this.tempService.queryHomePageConfig(row4HomeConfig).get(0));
        }
        return mav;
    }

    private SysTemp getIndexDefalutTemp() {
        try {
            return this.tempService.getCurrTemp();
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u9996\u9875\u9ed8\u8ba4\u6a21\u677f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    private ModelAndView initOldTemp(ModelAndView mav, SysTemp temp) {
        mav.addObject("sys", (Object)this.basicSetService.findBasicSet());
        mav.addObject("temp", (Object)temp);
        mav.addObject("floor", (Object)this.indexSiteService.getStoreys(Long.valueOf(temp.getTempId())));
        System.out.println("\u65b0\u95fb\u516c\u544a\u6a21\u5757\u540d\u79f0:" + temp.getExpFleid2());
        String expFleid2 = temp.getExpFleid2();
        mav.addObject("infoName", (Object)expFleid2);
        mav.addObject("infoList", (Object)this.infoService.selectByInfoType(Long.valueOf(temp.getExpFleid1())));
        mav.addObject("avc", (Object)this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID1, ADVERTTYPE, null, "0", null, "0"));
        mav.addObject("avs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID2, ADVERTTYPE, null, "0", null, "0"));
        List channelAdverList = this.channelAdverService.selectchannelAdverByParamForSite(null, Long.valueOf(temp.getTempId()), null, null, ATID3, ADVERTTYPE, null, "0", null, "0");
        mav.addObject("pageAdvs", (Object)channelAdverList);
        mav.addObject("hotSale", (Object)this.channelGoodsService.selectchannelStoreyGoodsByParamForSite(String.valueOf(temp.getTempId()), null, null));
        mav.addObject("tags", (Object)this.indexSiteService.getTagListForTempId(Long.valueOf(temp.getTempId())));
        if (null != temp.getStandby4()) {
            mav.addObject("onepages", (Object)this.onePageService.selectInfoOPByTempAndTag(Long.valueOf(temp.getTempId()), Long.valueOf(temp.getStandby4())));
        }
        mav.addObject("shares", (Object)this.shareService.getTopShare(10));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/tops"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> top2(HttpServletRequest request, String flag) {
        HashMap<String, Object> returnmap = new HashMap<String, Object>();
        SysTemp temp = this.getIndexDefalutTemp();
        returnmap.put("temp", temp);
        returnmap.put("hotsearch", this.getRandomHotSearch(this.hotSearchService.selectHotBySelectiveForSite(Long.valueOf(temp.getTempId()), null)));
        IndexClassifyBar classifyBar = this.indexSiteService.getClassifyBar(Long.valueOf(temp.getTempId()));
        returnmap.put("classifyBar", classifyBar);
        returnmap.put("systembase", this.basicSetService.findBasicSet());
        returnmap.put("navList", this.getNav(temp.getTempId()));
        returnmap.put("cust", request.getSession().getAttribute("cust"));
        returnmap.put("flag", request.getParameter("flag"));
        return returnmap;
    }

    @RequestMapping(value={"/getBottom"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getBottom(HttpServletRequest request) {
        HashMap<String, Object> returnmap = new HashMap<String, Object>();
        returnmap.put("sys", this.basicSetService.findBasicSet());
        returnmap.put("helpCates", this.getHelpCateList());
        returnmap.put("helpCenters", this.helpCenterService.selectAllIsFoot());
        return returnmap;
    }

    @RequestMapping(value={"/minicart"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> miniCart(HttpServletRequest request, String flag) {
        HashMap<String, Object> returnmap = new HashMap<String, Object>();
        returnmap.put("shopcart", this.shoppingcat.miniShoppingCart(request));
        returnmap.put("cust", request.getSession().getAttribute("cust"));
        return returnmap;
    }

    @RequestMapping(value={"/minisscart"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> minissCart(HttpServletRequest request, String flag) {
        HashMap<String, Object> returnmap = new HashMap<String, Object>();
        try {
            MiniShoppingCart miniShoppingCart = this.shoppingcat.miniShoppingCart(request);
            returnmap.put("shopcart", miniShoppingCart);
            returnmap.put("cust", request.getSession().getAttribute("cust") == null ? null : new Customer());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u52a0\u8f7d\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return returnmap;
    }

    @RequestMapping(value={"/delminicartfit"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delMiniCartFit(HttpServletRequest request, Long shoppingCartId, Long goodsInfoId, Long fitId, HttpServletResponse response) {
        try {
            this.shoppingcat.delGoodsGroupByS(shoppingCartId, goodsInfoId, fitId, request, response);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/ajaxLoadInfor"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<InformationVo> ajaxLoadInfor(HttpServletRequest request) {
        SysTemp temp = this.getIndexDefalutTemp();
        return this.infoService.selectByInfoType(Long.valueOf(temp.getExpFleid1()));
    }

    @RequestMapping(value={"/selectCity"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateProvince(Long provinceId, HttpServletRequest request) {
        Province province = this.provinceService.findProvinceByPrimaryKey(provinceId);
        request.getSession().setAttribute("chProvince", (Object)province.getProvinceName());
        List cityVos = this.cityService.queryCityByProvinceId(provinceId);
        CityVo city = !cityVos.isEmpty() ? (CityVo)cityVos.get(0) : new CityVo();
        request.getSession().setAttribute("chCity", (Object)city.getCityName());
        List districtVos = this.districtService.queryDistrictByCityId(city.getCityId());
        DistrictVo district = !districtVos.isEmpty() ? (DistrictVo)districtVos.get(0) : new DistrictVo();
        request.getSession().setAttribute("distinctId", (Object)district.getDistrictId());
        request.getSession().setAttribute("chAddress", (Object)(province.getProvinceName() + city.getCityName() + district.getDistrictName()));
        request.getSession().setAttribute("chDistinct", (Object)district.getDistrictName());
        return 1;
    }

    @RequestMapping(value={"/defaulteProvince"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int defaulteProvince(HttpServletRequest request) {
        request.getSession().setAttribute("chProvince", (Object)"\u4e0a\u6d77");
        request.getSession().setAttribute("chCity", (Object)"\u4e0a\u6d77\u5e02");
        request.getSession().setAttribute("chDistinct", (Object)"\u5f90\u6c47\u533a");
        request.getSession().setAttribute("distinctId", (Object)"749");
        request.getSession().setAttribute("chAddress", (Object)"\u4e0a\u6d77\u5e02\u5f90\u6c47\u533a");
        return 1;
    }

    private Set<HotSearch> getRandomHotSearch(List<HotSearch> hotSearchList) {
        HashSet<HotSearch> hotSearchSet = new HashSet<HotSearch>();
        for (HotSearch hotSearch : hotSearchList) {
            hotSearchSet.add(hotSearch);
        }
        return hotSearchSet;
    }

    private List<ChannelBar> getNav(int tempId) {
        try {
            return this.channelBarService.selectAllChannelBarByParam(null, Long.valueOf(tempId), null);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u5bfc\u822a\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
            return new ArrayList<ChannelBar>();
        }
    }

    private List<HelpCateBean> getHelpCateList() {
        ArrayList<HelpCateBean> helpCateBeans = new ArrayList<HelpCateBean>();
        List helpcates = this.helpCateService.findAll();
        if (null != helpcates && !helpcates.isEmpty()) {
            for (HelpCate helpCate : helpcates) {
                HelpCateBean helpCateBean = new HelpCateBean();
                helpCateBean.setHelpcateId(helpCate.getHelpcateId());
                helpCateBean.setHelpcateName(helpCate.getHelpcateName());
                helpCateBean.setHelpcateImg(helpCate.getHelpcateImg());
                helpCateBean.setHelpCenters(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
                helpCateBeans.add(helpCateBean);
            }
        }
        return helpCateBeans;
    }

    @RequestMapping(value={"toFriendLink"})
    public ModelAndView friendLink(PageBean pageBean, SelectBean selectBean) {
        pageBean.setPageSize(100);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.friendLinkService.findByPageBean(pageBean, selectBean));
        map.put("fls", this.friendLinkService.selectAllFriendLink());
        ModelAndView mav = new ModelAndView("help/friendlink");
        mav.addObject("map", map);
        return this.topAndBottomService.getTopAndBottom(mav);
    }
}

