/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.alibaba.fastjson.JSON;
import com.itextpdf.xmp.impl.Base64;
import com.qianjiang.comment.bean.GoodsProductReleSpecVo;
import com.qianjiang.common.util.EmailUtils;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.bean.OrderComplainBack;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.customer.service.CustomerOrderService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.InsideLetterServiceMapper;
import com.qianjiang.customer.service.OrderComplainBackService;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.des.DESCoder;
import com.qianjiang.goods.bean.GoodsProductSon;
import com.qianjiang.goods.service.BrowserecordService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSonService;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderContainerRelation;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderGoodsService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.GoodsBean;
import com.qianjiang.other.bean.OrderInfoBean;
import com.qianjiang.promotion.service.RushCustomerService;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.site.util.HttpRequestUtils;
import com.qianjiang.system.bean.DeliveryPoint;
import com.qianjiang.system.bean.Receivables;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.system.service.IsBackOrderService;
import com.qianjiang.system.service.ReceivablesService;
import com.qianjiang.temp.service.MegawizardService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.OrderContainerUtil;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="customerControllerSite")
public class CustomerController {
    private static final String EXPLAIN = "explain";
    private static final String REFERER = "referer";
    private static final String CUSTINFO = "custInfo";
    private static final String PATCHCA = "PATCHCA";
    private static final String EMAIL = "email";
    private static final String EFLAG = "eFlag";
    private static final String EMAILCHECKPWD = "emailCheckPwd";
    private static final String VALIDPWD = "validPwd";
    private static final String ERRORINFO = "\u975e\u6cd5\u64cd\u4f5c,\u5730\u5740\u680f\u8f93\u5165\u94fe\u63a5\u6216\u8005\u662f\u5176\u4ed6\u7f51\u7ad9\u7684\u94fe\u63a5,\u5373\u5c06\u8df3\u8f6c\u9996\u9875";
    private static final String LOGGERINFO1 = "\u9a8c\u8bc1\u90ae\u4ef6 --\u5b89\u5168\u4e2d\u5fc3 \u9a8c\u8bc1\u8eab\u4efd<===========\u5f53\u524d\u767b\u5f55\u4f1a\u5458\u4e3a\uff1a";
    private static final String LOGGERINFO2 = "\u9a8c\u8bc1\u90ae\u4ef6 --\u5b89\u5168\u4e2d\u5fc3 \u9a8c\u8bc1\u8eab\u4efd";
    private static final String LOGGERINFO3 = "\u9a8c\u8bc1\u90ae\u7bb1<===========\u5f53\u524d\u767b\u5f55\u4f1a\u5458\u4e3a\uff1a";
    private static final String LOGGERINFO4 = "\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801,\u624b\u673a\u53f7\u7801\u4e3a\uff1a";
    private static final String LOGGERINFO5 = "\u3011\u7684\u8ba2\u5355\uff01";
    private static final String LOGGERINFO6 = "\u67e5\u8be2\u5355\u53f7\u4e3a\uff1a\u3010";
    private static final String INDEX = "/index.html";
    private static final String MYORDER = "/myorder.html";
    private static final String SENDSUCCESS = "/customer/sendsuccess";
    private static final String REFUNDLIST = "/refundlist.html";
    private static final String BROWSERECORD = "/browserecord.html";
    private static final String MYFOLLW = "/myfollw.html";
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    private CouponService couponService;
    @Resource(name="browserecordServiceMix")
    private BrowserecordService browserecordService;
    @Resource(name="customerFollowServiceMapper")
    private CustomerFollowServiceMapper customerFollowService;
    private OrderComplainBackService orderComplainService;
    private EmailUtils emailUtils;
    @Resource(name="SiteOrderService")
    private SiteOrderService siteOrderService;
    @Resource(name="receivablesService")
    private ReceivablesService receivablesService;
    @Resource(name="customerOrderService")
    private CustomerOrderService customerOrderService;
    @Resource(name="OrderService")
    private OrderService OrderService;
    @Autowired
    private GoodsProductSonService goodsProductSonService;
    @Autowired
    private OrderGoodsService orderGoodsService;
    private static final MyLogger LOGGER = new MyLogger(CustomerController.class);
    private OrderCouponService orderCouponService;
    private TopAndBottomService topAndBottomService;
    private MegawizardService megawizardSerivce;
    private TempService tempService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="IsBackOrderService")
    private IsBackOrderService isBackOrderService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="DeliveryPointService")
    private DeliveryPointService deliveryPointService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper addressService;
    @Autowired
    private DepositService depositService;
    @Resource(name="insideLetterServiceMapper")
    private InsideLetterServiceMapper insideLetterServiceMapper;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="rushCustomerService")
    private RushCustomerService rushCustomerService;

    private boolean isExistGoodsInfoId(List<OrderGoods> goodsList, Long goodsInfoId, Long goodsNum, String goodsInfoItemNoS, OrderGoods goods, List<String> goodsInfoItemNoSList, List<String> goodsInfoPriceList) {
        for (OrderGoods orderGoods : goodsList) {
            if (goodsInfoId != orderGoods.getGoodsInfoId() && !orderGoods.equals(orderGoods.getGoodsInfoId())) continue;
            orderGoods.setGoodsInfoNum(Long.valueOf(orderGoods.getGoodsInfoNum() + goodsNum));
            String backGoodsInfoItemNoS = goods.getBackGoodsInfoItemNoS() == null ? "" : goods.getBackGoodsInfoItemNoS();
            List<String> goodsInfoItems = Arrays.asList(goodsInfoItemNoS.split(","));
            List<String> backGoodsInfoItemS = Arrays.asList(backGoodsInfoItemNoS == null ? "".split(",") : backGoodsInfoItemNoS.split(","));
            List<String> goodsInfoPrice = new ArrayList();
            List<String> goodsInfoItem = new ArrayList();
            if (backGoodsInfoItemS.size() != 0) {
                for (String string : goodsInfoItems) {
                    if (backGoodsInfoItemS.contains(string)) continue;
                    goodsInfoPrice = orderGoods.getGoodsInfoPriceList();
                    goodsInfoPrice.add(goods.getGoodsInfoSumPrice().divide(new BigDecimal(goods.getGoodsInfoNum()), 2, 4).subtract(goods.getGoodsCouponPrice().divide(new BigDecimal(goods.getGoodsInfoNum()), 2, 4)).toString());
                    goodsInfoItem = orderGoods.getGoodsInfoItemNoSList();
                    goodsInfoItem.add(string);
                }
            }
            goods.setGoodsInfoPriceList(goodsInfoPrice);
            goods.setGoodsInfoItemNoSList(goodsInfoItem);
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/customer/index"})
    public ModelAndView customerIndex(HttpServletRequest request, HttpServletResponse response, PageBean pb) {
        ModelAndView mav;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SystemsSet isSet = this.customerServiceInterface.getIsBackOrder();
        if (request.getSession().getAttribute("customerId") != null) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            int pointSum = this.customerServiceInterface.querySumByCustId((Long)request.getSession().getAttribute("customerId"));
            CustomerAllInfo info = new CustomerAllInfo();
            info.setCustomerId(customerId);
            info.setInfoPointSum(Integer.valueOf(pointSum));
            this.customerServiceInterface.modifyCustomerInfo(info, null);
            Long levelId = 0L;
            String levelName = "";
            List pointList = this.customerServiceInterface.queryPointLevel();
            if (null != pointList && pointList.size() > 0) {
                for (int i = 0; i < pointList.size(); ++i) {
                    String[] a = ((CustomerPointLevel)pointList.get(i)).getPointNeed().split("~");
                    if (pointSum < Integer.parseInt(a[0]) || pointSum > Integer.parseInt(a[1])) continue;
                    levelId = ((CustomerPointLevel)pointList.get(i)).getPointLevelId();
                    levelName = ((CustomerPointLevel)pointList.get(i)).getPointLevelName();
                    break;
                }
            }
            this.customerServiceInterface.updCustLevel(levelId, levelName, customerId);
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            resultMap.put("couponNum", this.couponService.myCouponNoCount(customerId));
            resultMap.put("browses", this.browserecordService.selectBrowserecord(customerId));
            resultMap.put("notice", this.customerServiceInterface.selectNotice(customerId));
            resultMap.put("isNotReadCount", this.insideLetterServiceMapper.getIsNotReadCount(customerId));
            System.out.println(resultMap.get("isNotReadCount"));
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("customerId", customerId);
            resultMap.put("myFollowList", this.customerFollowService.selectCustomerFollow(paramMap, pb));
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById(customerId);
            customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "")));
            resultMap.put("customer", customerAllInfo);
            BigDecimal orderPrice = this.orderService.countOrderPrice(customerId) == null ? new BigDecimal(0) : this.orderService.countOrderPrice(customerId);
            int countFans = this.customerService.countFans(customerId);
            resultMap.put("countFans", countFans);
            ArrayList new_order = new ArrayList();
            List order = this.orderService.orderDetailList(customerId, "1");
            BigDecimal customerDiscount = new BigDecimal(0);
            if (order.size() != 0) {
                customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(((Order)order.get(0)).getCustomerId());
            }
            if (order.size() != 0 && order != null) {
                ArrayList new_order_goodsList = new ArrayList();
                for (int i = 0; i < order.size(); ++i) {
                    System.out.println("!!!!!\u7528\u6237\u62e5\u6709\u7684\u8ba2\u5355\u5546\u54c1\uff1a" + ((Order)order.get(i)).getOrderId());
                    List goodsList = ((Order)order.get(i)).getOrderGoodsList();
                    new_order_goodsList.addAll(goodsList);
                }
                ArrayList<OrderGoods> new_goodsList = new ArrayList<OrderGoods>();
                ArrayList<Long> goodsInfoIds = new ArrayList<Long>();
                for (OrderGoods goods : new_order_goodsList) {
                    goodsInfoIds.add(goods.getGoodsInfoId());
                }
                boolean index = false;
                for (OrderGoods goods : new_order_goodsList) {
                    String backGoodsInfoItemNoS;
                    ArrayList<String> goodsInfoItemNoSList = new ArrayList<String>();
                    ArrayList<String> goodsInfoPriceList = new ArrayList<String>();
                    goods.setGoodsName(goods.getGoodsInfoNum().toString());
                    Long goodsInfoId = goods.getGoodsInfoId();
                    Long backGoodsNum = goods.getBackGoodsNum();
                    String goodsInfoItemNoS = goods.getGoodsInfoItemNoS() == null ? "" : goods.getGoodsInfoItemNoS();
                    String string = backGoodsInfoItemNoS = goods.getBackGoodsInfoItemNoS() == null ? "" : goods.getBackGoodsInfoItemNoS();
                    if (goodsInfoItemNoS == null) {
                        goodsInfoItemNoS = "";
                    }
                    System.out.println("\u9000\u8d27\u6570\u91cf\uff1a" + backGoodsNum + "\u548c\u5546\u54c1\u6570\u91cf:" + goods.getGoodsInfoNum());
                    if (this.isExistGoodsInfoId(new_goodsList, goodsInfoId, goods.getGoodsInfoNum(), goodsInfoItemNoS, goods, goodsInfoItemNoSList, goodsInfoPriceList)) continue;
                    List<String> goodsInfoItems = Arrays.asList(goodsInfoItemNoS.split(","));
                    List<String> backGoodsInfoItemS = Arrays.asList(backGoodsInfoItemNoS.split(","));
                    if (backGoodsInfoItemS.size() != 0) {
                        for (String string2 : goodsInfoItems) {
                            if (backGoodsInfoItemS.contains(string2)) continue;
                            goodsInfoPriceList.add(goods.getGoodsInfoSumPrice().divide(new BigDecimal(goods.getGoodsInfoNum()), 2, 4).subtract(goods.getGoodsCouponPrice().divide(new BigDecimal(goods.getGoodsInfoNum()), 2, 4)).toString());
                            goodsInfoItemNoSList.add(string2);
                        }
                    }
                    if (backGoodsNum != null && !"".equals(backGoodsNum)) {
                        if (goods.getGoodsInfoNum() - backGoodsNum == 0L) continue;
                        goods.setGoodsInfoNum(Long.valueOf(goods.getGoodsInfoNum() - backGoodsNum));
                        goods.setGoodsInfoPriceList(goodsInfoPriceList);
                        goods.setGoodsInfoItemNoSList(goodsInfoItemNoSList);
                        new_goodsList.add(goods);
                        continue;
                    }
                    goods.setGoodsInfoPriceList(goodsInfoPriceList);
                    goods.setGoodsInfoItemNoSList(goodsInfoItemNoSList);
                    new_goodsList.add(goods);
                }
                new_order.add(order.get(0));
                ((Order)new_order.get(0)).setOrderGoodsList(new_goodsList);
            }
            mav = new ModelAndView("customer/newindex");
            System.out.println(new_order);
            mav.addObject("new_order", new_order);
            mav.addObject("customerAllInfo", (Object)customerAllInfo);
            mav.addObject("orderPriceSum", (Object)orderPrice);
            mav.addObject("order", (Object)order);
            resultMap.put("isBackOrder", isSet.getIsBackOrder());
            mav.addAllObjects(resultMap);
            HashMap<String, Long> queryMap = new HashMap<String, Long>();
            queryMap.put("customerId", customerId);
            Deposit deposit = this.depositService.getDeposit(queryMap);
            mav.addObject("deposit", (Object)deposit);
            List orders = this.customerServiceInterface.selectOrderByCustomerId(customerId);
            mav.addObject("orders", (Object)orders);
            LOGGER.info((Object)("\u8df3\u8f6c\u4f1a\u5458\u4e2d\u5fc3,\u5f53\u524d\u4f1a\u5458\u7684\u7528\u6237\u540d\u662f\u4e3a:" + this.getCustomer(customerId)));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customerINDEX");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    public String getCustomer(Long customerId) {
        if (null != customerId) {
            LOGGER.info((Object)("\u5f53\u524d\u4f1a\u5458\u7684\u7528\u6237\u540d\u662f\uff1a" + this.customerServiceInterface.selectByPrimaryKey(customerId).getCustomerUsername()));
            return this.customerServiceInterface.selectByPrimaryKey(customerId).getCustomerUsername();
        }
        return null;
    }

    @RequestMapping(value={"/securitycenter"})
    public ModelAndView securityCenter(HttpServletRequest request) {
        ModelAndView mav;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            HashMap<String, Long> queryParam = new HashMap<String, Long>();
            queryParam.put("customerId", customerId);
            Deposit deposit = this.depositService.getDeposit(queryParam);
            resultMap.put("customer", this.customerServiceInterface.queryCustomerById(customerId));
            resultMap.put(EXPLAIN, this.megawizardSerivce.selectByType(3, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            mav = new ModelAndView("customer/newaccountsecurity");
            mav.addAllObjects(resultMap);
            mav.addObject("deposit", (Object)deposit);
            LOGGER.info((Object)("\u8df3\u8f6c\u8d26\u6237\u5b89\u5168,\u5f53\u524d\u4f1a\u5458\u7684\u7528\u6237\u540d\u662f\u4e3a\u3010" + this.getCustomer(customerId) + "\u3011"));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/validate/emailcheck"})
    public ModelAndView emailcheck(HttpServletRequest request, String type) {
        ModelAndView mav;
        String url = request.getHeader(REFERER);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            resultMap.put(CUSTINFO, this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            resultMap.put("type", type);
            mav = new ModelAndView("customer/newreirectpem").addAllObjects(resultMap);
            LOGGER.info((Object)("\u8df3\u8f6c\u4fee\u6539\u5bc6\u7801\u3001\u90ae\u7bb1\u3001\u624b\u673a,\u5f53\u524d\u4f1a\u5458\u7684\u7528\u6237\u540d\u662f\u4e3a:" + this.getCustomer(customerId)));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/validate/reirectpem"})
    public ModelAndView modifyPwd(HttpServletRequest request, String type, String ut, String status, String mcode, String password) {
        int i;
        Long customerId;
        int emailCheckPwd;
        int emailCheckPwd2;
        Object emailCheck = request.getSession().getAttribute(EMAILCHECKPWD);
        if ("null".equals(emailCheck) && (emailCheckPwd2 = ((Integer)emailCheck).intValue()) != 1) {
            return new ModelAndView((View)new RedirectView(INDEX));
        }
        if (password != null && password != "" && (emailCheckPwd = this.customerServiceInterface.checkCustomerPassword(customerId = (Long)request.getSession().getAttribute("customerId"), password)) != 1) {
            return new ModelAndView((View)new RedirectView(INDEX));
        }
        String status1 = status;
        if (!this.isAccessValid(ut, request)) {
            if (status == null || "".equals(status)) {
                status1 = ut;
            }
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/validate/validateidentity.htm?type=" + type + "&ut=" + status1 + "&checkedUsing=0"));
        }
        String url = request.getHeader(REFERER);
        ModelAndView mav = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (mcode != null && (i = this.customerServiceInterface.getMCode(request, mcode)) != 1) {
            LOGGER.info((Object)ERRORINFO);
            return new ModelAndView((View)new RedirectView(INDEX));
        }
        if (url == null || "".equals(url)) {
            LOGGER.info((Object)ERRORINFO);
            return new ModelAndView((View)new RedirectView(INDEX));
        }
        if (this.checkLoginStatus(request)) {
            Long customerId2 = (Long)request.getSession().getAttribute("customerId");
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            resultMap.put("customer", this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId")));
            resultMap.put("type", type);
            mav = new ModelAndView("customer/newreirectpem").addAllObjects(resultMap);
            LOGGER.info((Object)("\u8df3\u8f6c\u4fee\u6539\u5bc6\u7801\u3001\u90ae\u7bb1\u3001\u624b\u673a,\u5f53\u524d\u4f1a\u5458\u7684\u7528\u6237\u540d\u662f\u4e3a:" + this.getCustomer(customerId2)));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    private boolean isAccessValid(String ut, HttpServletRequest request) {
        if (ut == null || "".equals(ut)) {
            return false;
        }
        String code = request.getParameter("code");
        if (!((String)request.getSession().getAttribute(PATCHCA)).equals(code)) {
            return false;
        }
        if ("pwd".equals(ut)) {
            String password = request.getParameter("pwd");
            if (password == null) {
                return false;
            }
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            int emailCheckPwd = this.customerServiceInterface.checkCustomerPassword(customerId, password);
            return emailCheckPwd == 1;
        }
        if ("mobile".equals(ut)) {
            String mcode = request.getParameter("mcode");
            if (mcode == null) {
                return false;
            }
            int f = this.customerServiceInterface.getMCode(request, mcode);
            return f == 1;
        }
        return true;
    }

    @RequestMapping(value={"/validate/modifypem"})
    public ModelAndView modifyPem(HttpServletRequest request, HttpServletResponse response, String newStr, String type, String csrFToken, String password) {
        ModelAndView mav;
        String code = request.getParameter("code");
        if (!((String)request.getSession().getAttribute(PATCHCA)).equals(code)) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            resultMap.put(CUSTINFO, this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            resultMap.put("type", type);
            ModelAndView mav2 = new ModelAndView("customer/newreirectpem").addAllObjects(resultMap).addObject("checkedUsing", (Object)"0");
            return this.topAndBottomService.getTopAndBottom(mav2);
        }
        Object tokenInSession = request.getSession().getAttribute("CSRFToken");
        if (csrFToken == null || !csrFToken.equals(tokenInSession)) {
            LOGGER.info((Object)"\u975e\u6cd5\u64cd\u4f5c,CSRFToken\u4e0d\u5339\u914d,\u5373\u5c06\u8df3\u8f6c\u9996\u9875");
            return new ModelAndView((View)new RedirectView(INDEX));
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(customerId);
        if (this.checkLoginStatus(request)) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customer.getCustomerUsername(), (String)"\u4fee\u6539\u8d44\u6599", (String)"\u4fee\u6539\u5bc6\u7801 \u90ae\u7bb1 \u624b\u673a");
            mav = this.customerService.modifyPassword(response, customerId.longValue(), password, newStr) == 1 ? new ModelAndView((View)new RedirectView("sucess.html?type=" + type)) : new ModelAndView((View)new RedirectView("fail.htm?type=" + type));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/index.html");
        }
        return this.topAndBottomService.getBottom(mav);
    }

    @RequestMapping(value={"/validate/sendeamil"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendEamil(HttpServletRequest request, String email, String type) {
        String code = request.getParameter("code");
        if ("".equals(code)) {
            return 2;
        }
        if (!((String)request.getSession().getAttribute(PATCHCA)).equals(code)) {
            return 0;
        }
        if (this.checkLoginStatus(request)) {
            CustomerAllInfo user = (CustomerAllInfo)request.getSession().getAttribute("cust");
            user.setCustomerId((Long)request.getSession().getAttribute("customerId"));
            user.setInfoEmail(email);
            request.setAttribute(EMAIL, (Object)email);
            if (this.emailUtils.sendBindEmail(request, user) == 1) {
                return this.customerServiceInterface.updateFindPwdCode(user);
            }
            return 3;
        }
        return -1;
    }

    @RequestMapping(value={"/validate/sendcheckidemail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendCheckIdEmail(HttpServletRequest request, String email, String type) {
        if (!this.isAccessValid(EMAIL, request)) {
            return -1;
        }
        if (this.checkLoginStatus(request)) {
            CustomerAllInfo user = this.customerServiceInterface.selectCustomerByUname(((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
            request.getSession().setAttribute("utype", (Object)type);
            LOGGER.info((Object)("\u53d1\u9001\u90ae\u4ef6\u9a8c\u8bc1\u8eab\u4efd\uff0c\u5f53\u524d\u767b\u5f55\u4f1a\u5458\u662f:" + user.getCustomerUsername()));
            if (this.emailUtils.sendCheckIdEmail(request, user) == 1) {
                return this.customerServiceInterface.updateFindPwdCode(user);
            }
            return 0;
        }
        return -1;
    }

    @RequestMapping(value={"/validate/valididemail"})
    public ModelAndView validPwdEmail(HttpServletRequest request, String checkCode, String d, String type, String k) {
        ModelAndView mav = null;
        String d1 = d;
        String type1 = type;
        String k1 = k;
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        if (d.indexOf("5qian2mi0") >= 0) {
            d1 = d.replaceAll("5qian2mi0", "\\+");
        }
        if (type.indexOf("5qian2mi0") >= 0) {
            type1 = type.replaceAll("5qian2mi0", "\\+");
        }
        if (k.indexOf("5qian2mi0") >= 0) {
            k1 = k.replaceAll("5qian2mi0", "\\+");
        }
        String outputStr1 = "";
        String outputStr2 = "";
        int err = 0;
        try {
            byte[] inputData1 = DESCoder.decryptBASE64((String)d1);
            byte[] outputData1 = DESCoder.decrypt((byte[])inputData1, (String)k1);
            outputStr1 = new String(outputData1);
            byte[] inputData2 = DESCoder.decryptBASE64((String)type1);
            byte[] outputData2 = DESCoder.decrypt((byte[])inputData2, (String)k1);
            outputStr2 = new String(outputData2);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            ++err;
        }
        if (this.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            int result = this.customerServiceInterface.validPwdEmail(request, checkCode, Long.valueOf(outputStr1));
            if (err > 0) {
                result = -2;
            }
            if (result == 1) {
                return this.topAndBottomService.getBottom(new ModelAndView((View)new RedirectView("/validate/emailcheck.htm?type=" + outputStr2 + "&ut=email")));
            }
            resultMap.put(EFLAG, result);
            resultMap.put(EXPLAIN, (Integer)this.megawizardSerivce.selectByType(3, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            mav = new ModelAndView(SENDSUCCESS);
            mav.addAllObjects(resultMap);
            LOGGER.info((Object)(LOGGERINFO1 + this.getCustomer(customerId)));
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u9a8c\u8bc1\u8eab\u4efd", (String)LOGGERINFO2);
            return this.topAndBottomService.getBottom(mav);
        }
        return new ModelAndView("redirect:/login.html?url=validate/valididemail-" + checkCode + "-" + type1 + "-" + d1 + ".html");
    }

    @RequestMapping(value={"/validate/bindsucess"})
    public ModelAndView bindsucess() {
        return this.topAndBottomService.getTopAndBottom(new ModelAndView("customer/newmodifysuccess")).addObject("type", (Object)EMAIL).addObject(EXPLAIN, (Object)this.megawizardSerivce.selectByType(3, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
    }

    @RequestMapping(value={"validate/validbindemail"})
    public ModelAndView validbindemail(HttpServletRequest request, String d, String checkCode, String mail, String k) {
        ModelAndView mav = null;
        String d1 = d;
        String k1 = k;
        String mail1 = mail;
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        String outputStr1 = "";
        String outputStr2 = "";
        int err = 0;
        if (d.indexOf("5qian2mi0") >= 0) {
            d1 = d.replaceAll("5qian2mi0", "\\+");
        }
        if (k.indexOf("5qian2mi0") >= 0) {
            k1 = k.replaceAll("5qian2mi0", "\\+");
        }
        if (mail.indexOf("5qian2mi0") >= 0) {
            mail1 = mail.replaceAll("5qian2mi0", "\\+");
        }
        try {
            byte[] inputData1 = DESCoder.decryptBASE64((String)d1);
            byte[] outputData1 = DESCoder.decrypt((byte[])inputData1, (String)k1);
            outputStr1 = new String(outputData1);
            byte[] inputData2 = DESCoder.decryptBASE64((String)mail1);
            byte[] outputData2 = DESCoder.decrypt((byte[])inputData2, (String)k1);
            outputStr2 = new String(outputData2);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            ++err;
        }
        if (err > 0) {
            resultMap.put(EFLAG, -2);
            resultMap.put(EXPLAIN, (Integer)this.megawizardSerivce.selectByType(3, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            mav = new ModelAndView(SENDSUCCESS);
            mav.addAllObjects(resultMap);
            LOGGER.info((Object)(LOGGERINFO1 + this.getCustomer(customerId)));
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u9a8c\u8bc1\u8eab\u4efd", (String)LOGGERINFO2);
            return this.topAndBottomService.getBottom(mav);
        }
        if (customerId != null && Long.valueOf(outputStr1).equals(customerId)) {
            int result = this.customerServiceInterface.validPwdEmail(request, checkCode, Long.valueOf(outputStr1));
            if (result != 1) {
                resultMap.put(EFLAG, result);
                resultMap.put(EXPLAIN, (Integer)this.megawizardSerivce.selectByType(3, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
                mav = new ModelAndView(SENDSUCCESS);
                mav.addAllObjects(resultMap);
                LOGGER.info((Object)(LOGGERINFO1 + this.getCustomer(customerId)));
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u9a8c\u8bc1\u8eab\u4efd", (String)LOGGERINFO2);
                return this.topAndBottomService.getBottom(mav);
            }
            this.customerServiceInterface.verifyCheckCode(customerId, customerId, checkCode);
            CustomerAllInfo user = new CustomerAllInfo();
            user.setCustomerId(customerId);
            user.setInfoEmail(outputStr2);
            this.customerServiceInterface.updateCustInfoByPrimaryKey(user);
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey(customerId));
            mav = new ModelAndView("customer/newmodifysuccess").addObject("type", (Object)EMAIL).addObject("ok", (Object)"ok");
            LOGGER.info((Object)(LOGGERINFO3 + this.getCustomer(customerId)));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/index.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"validate/newvalidbindemail"})
    public ModelAndView newvalidbindemail(HttpServletRequest request, String d, String mail, String k, String checkCode) {
        ModelAndView mav = null;
        String d1 = d;
        String k1 = k;
        String mail1 = mail;
        CustomerAllInfo user = (CustomerAllInfo)request.getSession().getAttribute("user");
        String outputStr1 = "";
        Long customerId = null;
        if (user != null) {
            customerId = user.getCustomerId();
        }
        int err = 0;
        if (d.indexOf("5qian2mi0") >= 0) {
            d1 = d.replaceAll("5qian2mi0", "\\+");
        }
        if (k.indexOf("5qian2mi0") >= 0) {
            k1 = k.replaceAll("5qian2mi0", "\\+");
        }
        if (mail.indexOf("5qian2mi0") >= 0) {
            mail1 = mail.replaceAll("5qian2mi0", "\\+");
        }
        try {
            byte[] inputData1 = DESCoder.decryptBASE64((String)d1);
            byte[] outputData1 = DESCoder.decrypt((byte[])inputData1, (String)k1);
            outputStr1 = new String(outputData1);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            ++err;
        }
        if (err == 0 && customerId != null && Long.valueOf(outputStr1).equals(customerId)) {
            mav = new ModelAndView((View)new RedirectView("../resetpwd.htm?emailCode=" + checkCode));
            LOGGER.info((Object)("\u66f4\u6539\u767b\u9646\u5bc6\u7801\u7684\u7528\u6237id\u4e3a:" + this.getCustomer(customerId)));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/index.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"validate/sucess"})
    public ModelAndView modifySucess(HttpServletRequest request, String newStr, String type) {
        ModelAndView mav;
        HashMap<String, CustomerAllInfo> map = new HashMap<String, CustomerAllInfo>();
        map.put("customer", this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId")));
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (this.checkLoginStatus(request)) {
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            mav = new ModelAndView("customer/newmodifysuccess").addObject("type", (Object)type).addAllObjects(map);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html").addAllObjects(map);
        }
        LOGGER.info((Object)(LOGGERINFO3 + this.getCustomer(customerId)));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"validate/fail"})
    public ModelAndView modifyFail(HttpServletRequest request, String newStr, String type) {
        ModelAndView mav;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (this.checkLoginStatus(request)) {
            request.getSession().setAttribute("cust", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
            mav = new ModelAndView("customer/modifyfail").addObject("type", (Object)type);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
        }
        LOGGER.info((Object)(LOGGERINFO3 + this.getCustomer(customerId)));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"validate/validateidentity"})
    public ModelAndView validateIdentity(HttpServletRequest request, String type, String ut, String checkedUsing) {
        String url = request.getHeader(REFERER);
        ModelAndView mav = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        CustomerAllInfo custInfo = null;
        int emailCheckPwd = -1;
        String checkPwd = "";
        if (request.getSession().getAttribute(EMAILCHECKPWD) != null && !"".equals(request.getSession().getAttribute(EMAILCHECKPWD))) {
            emailCheckPwd = Integer.valueOf(request.getSession().getAttribute(EMAILCHECKPWD).toString());
        }
        if (request.getSession().getAttribute(VALIDPWD) != null && !"".equals(request.getSession().getAttribute(VALIDPWD))) {
            checkPwd = request.getSession().getAttribute(VALIDPWD).toString();
        }
        if ((url == null || "".equals(url) || "successPwd".equals(checkPwd) && emailCheckPwd != 1) && type.equals(EMAIL)) {
            LOGGER.info((Object)ERRORINFO);
            return new ModelAndView((View)new RedirectView(INDEX));
        }
        if (this.checkLoginStatus(request)) {
            custInfo = this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"));
            resultMap.put(CUSTINFO, custInfo);
            HashMap<String, CustomerAllInfo> map = new HashMap<String, CustomerAllInfo>();
            map.put("customer", this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId")));
            request.getSession().setAttribute("cust", (Object)custInfo);
            resultMap.put("type", type);
            resultMap.put(EXPLAIN, this.megawizardSerivce.selectByType(4, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            if (ut == null) {
                if ("1".equals(custInfo.getIsMobile()) && custInfo.getInfoMobile() != null && custInfo.getInfoMobile().length() > 3) {
                    resultMap.put("ut", "mobile");
                } else if ("1".equals(custInfo.getIsEmail()) && custInfo.getInfoEmail() != null && custInfo.getInfoEmail().length() > 3) {
                    resultMap.put("ut", EMAIL);
                } else {
                    resultMap.put("ut", "pwd");
                }
            } else {
                resultMap.put("ut", ut);
            }
            request.getSession().setAttribute("CSRFToken", (Object)UUID.randomUUID().toString());
            mav = new ModelAndView("customer/newvalidateidentity").addAllObjects(resultMap).addObject("checkedUsing", (Object)checkedUsing).addAllObjects(map);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
        }
        LOGGER.info((Object)" \u4f1a\u5458\u8eab\u4efd\u9a8c\u8bc1");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"validate/validatemobile"})
    public ModelAndView validateMobile(HttpServletRequest request) {
        ModelAndView mav = this.checkLoginStatus(request) ? new ModelAndView() : new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/securitycenter.html");
        LOGGER.info((Object)"\u786e\u8ba4\u624b\u673a");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/checkcustomerpassword"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkCustomerPassword(Long customerId, String password, HttpServletRequest request) {
        Long customerId1 = customerId;
        customerId1 = (Long)request.getSession().getAttribute("customerId");
        if (this.checkLoginStatus(request)) {
            LOGGER.info((Object)"\u9a8c\u8bc1\u5bc6\u7801");
            int emailCheckPwd = this.customerServiceInterface.checkCustomerPassword(customerId1, password);
            request.getSession().setAttribute(EMAILCHECKPWD, (Object)emailCheckPwd);
            return emailCheckPwd;
        }
        return -1;
    }

    @RequestMapping(value={"/checkemailexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkEmailExist(HttpServletRequest request, String email) {
        if (this.checkLoginStatus(request)) {
            return this.customerServiceInterface.checkEmailExist(email);
        }
        return -1L;
    }

    @RequestMapping(value={"/checkmobileexist"}, produces={"application/json;charset=UTF-8"})
    public Long checkMobileExist(HttpServletRequest request, String mobile) {
        if (this.checkLoginStatus(request)) {
            Long result = this.customerServiceInterface.checkMobileExist(mobile);
            CustomerAllInfo customer = (CustomerAllInfo)request.getSession().getAttribute("cust");
            if (result == 1L && !mobile.equals(customer.getCustomerUsername())) {
                return 1L;
            }
            return 0L;
        }
        return -1L;
    }

    @RequestMapping(value={"/sendcode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendcode(HttpServletRequest request, String moblie, String code) throws IOException {
        if (StringUtils.isEmpty((String)((String)request.getSession().getAttribute("MPATCHCA")))) {
            return 2;
        }
        if (!request.getSession().getAttribute("MPATCHCA").equals(code)) {
            return 2;
        }
        if (this.checkLoginStatus(request)) {
            LOGGER.info((Object)(LOGGERINFO4 + moblie));
            request.getSession().removeAttribute("MPATCHCA");
            return this.customerServiceInterface.sendPost(moblie).getResult();
        }
        return -10010;
    }

    @RequestMapping(value={"/sendcodefindpwd"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendcodeToFindPwd(HttpServletRequest request, String checkCode) throws IOException {
        CustomerAllInfo user = (CustomerAllInfo)request.getSession().getAttribute("user");
        String patchca = (String)request.getSession().getAttribute(PATCHCA);
        if (patchca == null) {
            return -4;
        }
        if (!patchca.equals(checkCode)) {
            return -4;
        }
        if (user == null) {
            return -1;
        }
        LOGGER.info((Object)(LOGGERINFO4 + user.getInfoMobile()));
        return this.customerServiceInterface.sendPost(user.getInfoMobile()).getResult();
    }

    @RequestMapping(value={"/sendcodetovalidate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendcodeToValidate(HttpServletRequest request, String code) throws IOException {
        if (StringUtils.isEmpty((String)((String)request.getSession().getAttribute("MPATCHCA")))) {
            return 2;
        }
        if (!request.getSession().getAttribute("MPATCHCA").equals(code)) {
            return 2;
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo user = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (user == null) {
            return -1;
        }
        LOGGER.info((Object)(LOGGERINFO4 + user.getInfoMobile()));
        request.getSession().removeAttribute("MPATCHCA");
        return this.customerServiceInterface.sendPost(user.getInfoMobile()).getResult();
    }

    @RequestMapping(value={"/validate/getMCode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int getMCode(HttpServletRequest request, String code) throws IOException {
        if (this.checkLoginStatus(request)) {
            return this.customerServiceInterface.getMCode(request, code);
        }
        return -10010;
    }

    @RequestMapping(value={"/validate/getNoLoingMCode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int getNoLoingMCode(HttpServletRequest request, String code) {
        return this.customerServiceInterface.getMCode(request, code);
    }

    @RequestMapping(value={"/myorder"})
    public ModelAndView queryAllOrders(HttpServletRequest request, PageBean pb, String date, String type, String paramString) {
        ModelAndView mav;
        HashMap<String, Object> paramMap = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        pb.setPageSize(5);
        SystemsSet isSet = this.customerServiceInterface.getIsBackOrder();
        if (request.getSession().getAttribute("customerId") != null) {
            paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", (Long)request.getSession().getAttribute("customerId"));
            paramMap.put("date", date);
            paramMap.put("paramString", paramString);
            if (type != null && date != null) {
                pb.setUrl("customer/myorder-" + date + "-" + type);
            } else {
                pb.setUrl("customer/myorder");
            }
            resultMap.put("type", type);
            resultMap.put("paramString", paramString);
            resultMap.put("date", date);
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId"));
            customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint((Long)request.getSession().getAttribute("customerId") + "")));
            resultMap.put("customer", customerAllInfo);
            if (type != null && ("6".equals(type) || "5".equals(type) || "7".equals(type) || "8".equals(type))) {
                if ("6".equals(type)) {
                    paramMap.put("type", "1");
                } else if ("8".equals(type)) {
                    paramMap.put("type", "3");
                } else {
                    paramMap.put("type", type);
                }
                resultMap.put("pb", this.customerServiceInterface.queryAllBackMyOrders(paramMap, pb));
            } else {
                paramMap.put("type", type);
                resultMap.put("pb", this.customerServiceInterface.queryAllMyOrders(paramMap, pb));
            }
            resultMap.put("isBackOrder", isSet.getIsBackOrder());
            mav = new ModelAndView("customer/neworder").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myorder.html").addObject("type", (Object)type);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/orderdetails"})
    public ModelAndView queryOrderByOrderId(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.checkLoginStatus(request)) {
            Coupon coupon;
            mav = new ModelAndView("customer/orderdetail");
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            OrderInfoBean order = this.customerServiceInterface.queryOrderByCustIdAndOrderId(orderId, customerId);
            String expressType = order.getOrderExpressType();
            if ("1".equals(expressType)) {
                DeliveryPoint deliveryPoint = this.deliveryPointService.getDeliveryPoint(order.getAddressId());
                resultMap.put("deliveryPoint", deliveryPoint);
                CustomerAddress customerAddress = null;
                if (customerId != null) {
                    customerAddress = this.addressService.queryDefaultAddr(customerId);
                }
                if (null == customerAddress) {
                    customerAddress = this.addressService.selectByCIdFirst(customerId);
                }
                resultMap.put("shippingAddress", customerAddress);
            }
            if ((coupon = this.couponService.selectCouponByCodeNo(order.getCouponNo())) != null) {
                order.setCouponName(coupon.getCouponName());
            }
            for (int i = 0; i < order.getGoods().size(); ++i) {
                GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(((GoodsBean)order.getGoods().get(i)).getGoodsId());
                ((GoodsBean)order.getGoods().get(i)).setSpecVo(JSON.parseArray((String)JSON.toJSONString((Object)goodsProductDetailViewVo.getSpecVo()), GoodsProductReleSpecVo.class));
            }
            resultMap.put("order", order);
            resultMap.put("unpay", this.megawizardSerivce.selectByType(5, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            resultMap.put("pay", this.megawizardSerivce.selectByType(0, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            if ("1".equals(order.getDirectType())) {
                OrderExpress oe = this.orderService.queryOrderExpress(orderId);
                OrderContainerRelation relation = new OrderContainerRelation();
                relation.setOrderId(orderId);
                relation.setExpressNo(oe.getExpressNo());
                relation.setExpressName(oe.getExpressName());
                relation.setOrderExpressId(oe.getExpressId());
                String url = this.orderService.queryExpressInfoUrl(relation);
                relation.setExpressInfoUrl(url);
                order.setExpressName(oe.getExpressName());
                resultMap.put("relation", relation);
            } else {
                resultMap.put("relations", this.queryContainerRelations(request, orderId));
            }
            mav.addAllObjects(resultMap);
            if (null != order) {
                LOGGER.info((Object)("\u83b7\u53d6\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderNo() + "\u3011\u8ba2\u5355\u7684\u8be6\u7ec6\u4fe1\u606f\uff01"));
            }
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=customer/detail-" + orderId + ".html"));
    }

    @RequestMapping(value={"/cancelorder"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView cancelOrder(HttpServletRequest request, PageBean pb, Long orderId, String fromUrl, String reason) {
        ModelAndView mav = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        reason = Base64.decode((String)reason);
        if (!Pattern.compile("[^\\<\\>]+$").matcher(reason).find()) {
            throw new IllegalArgumentException();
        }
        Order order = this.siteOrderService.getPayOrder(orderId);
        if (customerId != null) {
            if (order != null && order.getCustomerId().equals(customerId) && !"4".equals(order.getOrderStatus())) {
                GoodsProductSon goodsProductSon = new GoodsProductSon();
                List orderGoods = this.orderGoodsService.selectOrderGoodsLists(orderId, "");
                System.out.println("\u5b50\u8d27\u54c1\u5f00\u59cb\u56de\u6eda\u72b6\u6001");
                for (OrderGoods orderGoods2 : orderGoods) {
                    String[] goodsItemS = orderGoods2.getGoodsInfoItemNoS().split(",");
                    for (int i = 0; i < goodsItemS.length; ++i) {
                        goodsProductSon.setGoodsInfoItemNoS(goodsItemS[i]);
                        goodsProductSon.setIsUse("0");
                        int result = this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
                        System.out.println("@@@@@\u5b50\u8d27\u54c1\u7ed3\u675f\u56de\u6eda\u72b6\u6001,result=" + result);
                    }
                }
                this.customerServiceInterface.cancelOrder(orderId, reason);
                this.rushCustomerService.updateRushcustomerByOrderId(orderId);
                this.orderCouponService.modifyCouponStatusNew(orderId);
            }
            if ("index".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + INDEX));
            } else if ("myorder".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + MYORDER));
            }
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myorder.html");
        }
        if (null != order && null != order.getOrderCode()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u53d6\u6d88\u8ba2\u5355", (String)("\u53d6\u6d88\u8ba2\u5355\u5355\u53f7\u3010" + order.getOrderCode() + "\u3011"));
            LOGGER.info((Object)("\u53d6\u6d88\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderCode() + LOGGERINFO5));
        }
        return mav;
    }

    @RequestMapping(value={"/cancelordergetsurplus"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView cancelordergetsurplus(HttpServletRequest request, PageBean pb, Long orderId, String fromUrl, String reason) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        ModelAndView mav = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        reason = Base64.decode((String)reason);
        if (!Pattern.compile("[^\\<\\>]+$").matcher(reason).find()) {
            throw new IllegalArgumentException();
        }
        Order order = this.siteOrderService.getPayOrder(orderId);
        if (customerId != null) {
            if (order != null && order.getCustomerId().equals(customerId) && !"4".equals(order.getOrderStatus())) {
                GoodsProductSon goodsProductSon = new GoodsProductSon();
                List orderGoods = this.orderGoodsService.selectOrderGoodsLists(orderId, "");
                System.out.println("\u5b50\u8d27\u54c1\u5f00\u59cb\u56de\u6eda\u72b6\u6001");
                for (OrderGoods orderGoods2 : orderGoods) {
                    String[] goodsItemS = orderGoods2.getGoodsInfoItemNoS().split(",");
                    for (int i = 0; i < goodsItemS.length; ++i) {
                        goodsProductSon.setGoodsInfoItemNoS(goodsItemS[i]);
                        goodsProductSon.setIsUse("0");
                        int result = this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
                        System.out.println("@@@@@\u5b50\u8d27\u54c1\u7ed3\u675f\u56de\u6eda\u72b6\u6001,result=" + result);
                    }
                }
                if ("32".equals(order.getOrderStatus())) {
                    System.out.println("\u8ba2\u5355\u72b6\u6001\u4e3a32");
                    int i = this.customerOrderService.cancelOrder(orderId, reason);
                    System.out.println("\u8ba2\u5355\u66f4\u65b0\u72b6\u6001---" + i);
                    this.orderCouponService.modifyCouponStatusNew(orderId);
                    Receivables receivables = this.receivablesService.queryByOrderCode(order.getOrderCode());
                    if (!"4".equals(receivables.getPayStatus())) {
                        System.out.println("\u66f4\u65b0\u652f\u4ed8\u5355\u6b65\u9aa4");
                        receivables.setPayStatus("4");
                        int j = this.receivablesService.upDateReceivables(receivables);
                        System.out.println("\u66f4\u65b0\u652f\u4ed8\u5355\u72b6\u6001---" + j);
                        CustomerAllInfo customer = this.addressService.selectByPrimaryKey(customerId);
                        BigDecimal userTotalSurplus = new BigDecimal(0);
                        userTotalSurplus = customer.getUserTotalPrice();
                        userTotalSurplus = userTotalSurplus.add(receivables.getUserSurplus());
                        System.out.println("\u66f4\u65b0\u4f59\u989d\u6b65\u9aa4");
                        int k = this.customerService.updateUserSurplus(customer.getCustomerId(), userTotalSurplus);
                        System.out.println("\u66f4\u65b0\u4f59\u989d---" + k);
                        System.out.println("\u4f1a\u5458\u8d2d\u4e70\u5546\u54c1\u540e\u8c03\u7528\u5411\u5bfc\u63a5\u53e3\u300b\u6263\u6b3e\u5f00\u59cb");
                        String currentRegister = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                        String curr = String.valueOf(System.currentTimeMillis() / 1000L);
                        String s = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                        String results = "";
                        String apisign = "erp_prod_key75dec1805b03407186543937ea09c3bf" + s + "";
                        MessageDigest md5 = MessageDigest.getInstance("MD5");
                        md5.update(apisign.getBytes("UTF-8"));
                        byte[] b = md5.digest();
                        StringBuffer buf = new StringBuffer("");
                        for (int offset = 0; offset < b.length; ++offset) {
                            int o = b[offset];
                            if (o < 0) {
                                o += 256;
                            }
                            if (o < 16) {
                                buf.append("0");
                            }
                            buf.append(Integer.toHexString(o));
                        }
                        results = buf.toString();
                        System.out.println("result = " + results);
                        String string = "{\"apikey\":\"erp_prod_key\",\"apisign\":\"" + results + "\",\"timestamp\":\"" + s + "\",\"vip_no\":\"" + customer.getUserTotalPrice() + "\",\"bill_date\"" + ":\"" + currentRegister + "\",\"prepay_amt\":\"+" + receivables.getUserSurplus() + "\",\"free_amt\":\"0.00\",\"cash_amt\":\"0.00\"," + "\"remark\":\"\u7528\u6237\u53d6\u6d88\u7ec4\u5408\u8ba2\u5355\u589e\u52a0" + receivables.getUserSurplus() + "\u5143\"}";
                        JSONObject resultJsons = HttpRequestUtils.httpPost("http://fsjk.4008713538.cn/Handler/Util/VipPrepayChange.ashx", JSONObject.fromObject((Object)string));
                        System.out.println("~~~~~\u53d6\u6d88\u7ec4\u5408\u8ba2\u5355~~~~ \u8fd4\u56de\u7684\u54cd\u5e94" + resultJsons.getString("code"));
                    }
                    this.orderService.updateRushcustomerByOrderId(orderId);
                }
                this.orderCouponService.modifyCouponStatusNew(orderId);
            }
            if ("index".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + INDEX));
            } else if ("myorder".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + MYORDER));
            }
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myorder.html");
        }
        if (null != order && null != order.getOrderCode()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u53d6\u6d88\u8ba2\u5355", (String)("\u53d6\u6d88\u8ba2\u5355\u5355\u53f7\u3010" + order.getOrderCode() + "\u3011"));
            LOGGER.info((Object)("\u53d6\u6d88\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderCode() + LOGGERINFO5));
        }
        return mav;
    }

    @RequestMapping(value={"/customer/ajaxCancelOrder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int ajaxCancelOrder(HttpServletRequest request, Long orderId) {
        int i = 1;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Order order = this.siteOrderService.getPayOrder(orderId);
        if (!"0".equals(order.getOrderStatus()) && !"32".equals(order.getOrderStatus())) {
            i = 0;
        }
        return i;
    }

    @RequestMapping(value={"/comfirmofgooods"})
    public ModelAndView comfirmofGoods(HttpServletRequest request, PageBean pb, Long orderId, String fromUrl) {
        Order order;
        ModelAndView mav = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (this.checkLoginStatus(request)) {
            order = this.siteOrderService.getPayOrder(orderId);
            if (order != null && order.getPayTime() == null) {
                order.setPayTime(new Date());
            }
            order.setGetGoodsTime(new Date());
            order.setOrderStatus("3");
            order.setFinishSturts("1");
            int rows = this.OrderService.updateOrderStatusByorderIdFortask(order);
            this.orderCouponService.modifyCouponByOrderId(orderId, (Long)request.getSession().getAttribute("customerId"));
            if ("index".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + INDEX));
            } else if ("myorder".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + MYORDER));
            }
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myorder.html");
        }
        order = this.siteOrderService.getPayOrder(orderId);
        if (null != order.getOrderCode()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u786e\u8ba4\u8ba2\u5355", (String)("\u786e\u8ba4\u8ba2\u5355\u5355\u53f7\u3010" + order.getOrderCode() + "\u3011"));
            LOGGER.info((Object)("\u786e\u8ba4\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderCode() + LOGGERINFO5));
        }
        return mav;
    }

    @RequestMapping(value={"/refundlist"})
    public ModelAndView refundList(HttpServletRequest request, PageBean pb) {
        HashMap<String, Object> paramMap = null;
        HashMap<String, PageBean> resultMap = new HashMap<String, PageBean>();
        pb.setPageSize(4);
        ModelAndView mav = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (this.checkLoginStatus(request)) {
            paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", customerId);
            paramMap.put("type", "4");
            pb.setUrl("customer/refundlist");
            resultMap.put("pb", this.customerServiceInterface.queryAllMyOrders(paramMap, pb));
            mav = new ModelAndView("customer/newcancelorder").addAllObjects(resultMap);
            CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(customerId);
            if (null != customer.getCustomerUsername()) {
                LOGGER.info((Object)("\u8df3\u8f6c\u5230\u4f1a\u5458\u3010" + customer.getCustomerUsername() + "\u3011\u7684\u4e2a\u4eba\u8ba2\u5355\u9875\u9762\uff01"));
            }
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/refundlist.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/customer/delorder"})
    public ModelAndView delOrder(HttpServletRequest request, PageBean pb, Long orderId) {
        ModelAndView mav;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (this.checkLoginStatus(request)) {
            this.customerServiceInterface.delOrder(orderId);
            mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + REFUNDLIST));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/refundlist.html");
        }
        Order order = this.siteOrderService.getPayOrder(orderId);
        if (null != order.getOrderCode()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)this.getCustomer(customerId), (String)"\u5220\u9664\u8ba2\u5355", (String)("\u5220\u9664\u8ba2\u5355\u5355\u53f7\u3010" + order.getOrderCode() + "\u3011"));
            LOGGER.info((Object)("\u5220\u9664\u5355\u53f7\u4e3a\uff1a\u3010" + order.getOrderCode() + LOGGERINFO5));
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/myintegral"})
    public ModelAndView queryCustomerIntegral(HttpServletRequest request, PageBean pb, Long date) {
        ModelAndView mav;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        pb.setUrl("1".equals(date.toString()) ? "customer/myintegral" : "customer/myintegral-" + date);
        Long customerId = null;
        pb.setPageSize(8);
        if (this.checkLoginStatus(request)) {
            customerId = (Long)request.getSession().getAttribute("customerId");
            paramMap.put("date", date);
            paramMap.put("customerId", customerId);
            resultMap.put("pb", this.customerServiceInterface.selectAllCustomerPoint(paramMap, pb));
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerByCustomerId(customerId.longValue());
            customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "")));
            resultMap.put("customer", customerAllInfo);
            resultMap.put("date", date);
            mav = new ModelAndView("customer/newintegral").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myintegral.html");
        }
        LOGGER.info((Object)("\u8df3\u8f6c\u4f1a\u5458\u79ef\u5206\u9875,\u5f53\u524d\u767b\u5f55\u6210\u529f\u7684\u4f1a\u5458\u4e3a\uff1a" + this.getCustomer(customerId)));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/myinfo"})
    public ModelAndView showMyInfo(HttpServletRequest request, PageBean pb, Double date) {
        ModelAndView mav;
        if (this.checkLoginStatus(request)) {
            mav = new ModelAndView("customer/newinfo");
            mav.addObject("customer", (Object)this.customerServiceInterface.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId")));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myinfo.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/browserecord"})
    public ModelAndView showMyBrowserecord(HttpServletRequest request, PageBean pb) {
        ModelAndView mav;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.checkLoginStatus(request)) {
            resultMap.put("browses", this.browserecordService.selectBrowserecord((Long)request.getSession().getAttribute("customerId")));
            resultMap.put("today", new Date());
            HashMap<String, Object> followMap = new HashMap<String, Object>();
            followMap.put("customerId", request.getSession().getAttribute("customerId"));
            resultMap.put("goodsIds", this.customerFollowService.selectCustomerFollowForList(followMap));
            resultMap.put("customer", this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId")));
            mav = new ModelAndView("customer/newbrowserecord");
            mav.addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/browserecord.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/myfollw"})
    public ModelAndView showMyFollow(HttpServletRequest request, PageBean pb) {
        ModelAndView mav;
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        pb.setUrl("customer/myfollw");
        HashMap<String, CustomerAllInfo> resultMap = new HashMap<String, CustomerAllInfo>();
        if (this.checkLoginStatus(request)) {
            paramMap.put("customerId", (Long)request.getSession().getAttribute("customerId"));
            resultMap.put("customer", this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId")));
            mav = new ModelAndView("customer/newfollow").addObject("pb", (Object)this.customerFollowService.selectCustomerFollow(paramMap, pb)).addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myfollw.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/cancelfollow"})
    public ModelAndView cancelFollow(HttpServletRequest request, Long followId) {
        ModelAndView mav;
        if (this.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            this.customerFollowService.deleteFollow(followId, customerId);
            mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + MYFOLLW));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/myfollw.html");
        }
        LOGGER.info((Object)("\u53d6\u6d88\u5546\u54c1\u5173\u6ce8\uff0c\u5173\u6ce8ID\u4e3a\uff1a" + followId));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/cancelbrowse"})
    public ModelAndView cancelBrowse(HttpServletRequest request, Long likeId) {
        ModelAndView mav;
        if (this.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            this.browserecordService.deleteByPrimaryKey(likeId, customerId);
            mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + BROWSERECORD));
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/browserecord.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/customer/modifyInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int modifyCustomerInfo(HttpServletRequest request, CustomerAllInfo allInfo, String flag) {
        if (this.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            if ("1".equals(flag)) {
                request.getSession().setAttribute("cust", (Object)allInfo);
            }
            allInfo.setCustomerId(customerId);
            return this.customerServiceInterface.modifyCustomerInfo(allInfo, flag);
        }
        return -1;
    }

    @RequestMapping(value={"/customer/ordercomplain"})
    public ModelAndView orderComplain(HttpServletRequest request, PageBean pb) {
        ModelAndView mav;
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        pb.setUrl("customer/ordercomplain");
        if (this.checkLoginStatus(request)) {
            paramMap.put("customerId", (Long)request.getSession().getAttribute("customerId"));
            resultMap.put("pb", this.customerServiceInterface.queryOrdersForComplain(paramMap, pb));
            resultMap.put("id", "0");
            mav = new ModelAndView("customer/newordercomplain").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/ordercomplain.html");
        }
        LOGGER.info((Object)"\u8df3\u8f6c\u6211\u7684\u6295\u8bc9\u9875\u9762");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/customer/tocomplain"})
    public ModelAndView toComplain(HttpServletRequest request, String orderNo) {
        ModelAndView mav;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (this.checkLoginStatus(request)) {
            resultMap.put("orderNo", orderNo);
            mav = new ModelAndView("customer/newtocomplain").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/index.html");
        }
        LOGGER.info((Object)"\u8df3\u8f6c \u586b\u5199\u6295\u8bc9\u5185\u5bb9\u9875\u9762\u6210\u529f\uff01");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/customer/addcomplain"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addComplain(HttpServletRequest request, @Valid OrderComplainBack orderComplain) {
        CustomerAllInfo customerlain = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (orderComplain != null) {
            if (!orderComplain.getCustomerId().equals(customerId)) {
                return -1;
            }
            Long orderFlag = this.customerServiceInterface.checkexistsByIdAndCode(customerId, orderComplain.getOrderNo());
            if (orderFlag <= 0L) {
                return -1;
            }
        }
        if (null != customerId) {
            customerlain = this.customerServiceInterface.selectByPrimaryKey(customerId);
        }
        if (null != customerAllInfo.getCustomerUsername()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u6dfb\u52a0\u6295\u8bc9", (String)("\u6295\u8bc9\u4eba\u4e3a\u3010" + customerlain.getCustomerUsername() + "\u3011"));
        }
        if (this.checkLoginStatus(request)) {
            return this.orderComplainService.addComplain(orderComplain);
        }
        return -1;
    }

    @RequestMapping(value={"/customer/complainsuccess"})
    public ModelAndView complainSuccess(HttpServletRequest request) {
        if (this.checkLoginStatus(request)) {
            return this.topAndBottomService.getTopAndBottom(new ModelAndView("/customer/success"));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=index.html"));
    }

    @RequestMapping(value={"/customer/complainlist"})
    public ModelAndView complainList(HttpServletRequest request, PageBean pb) {
        ModelAndView mav;
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        pb.setUrl("customer/complainlist");
        if (this.checkLoginStatus(request)) {
            paramMap.put("customerId", (Long)request.getSession().getAttribute("customerId"));
            resultMap.put("pb", this.orderComplainService.queryComplainList1(paramMap, pb));
            resultMap.put("id", "1");
            mav = new ModelAndView("customer/newordercomplain").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/ordercomplain.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/queryorderexpress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<OrderContainerUtil> queryOrderExpress(HttpServletRequest request, Long orderId) {
        if (this.checkLoginStatus(request)) {
            Order order = this.siteOrderService.getPayOrder(orderId);
            if (null != order.getOrderCode()) {
                LOGGER.info((Object)(LOGGERINFO6 + order.getOrderCode() + "\u3011\u7684\u7269\u6d41\u4fe1\u606f\uff01"));
            }
            return this.siteOrderService.getExpressNo(orderId);
        }
        return new ArrayList<OrderContainerUtil>();
    }

    @RequestMapping(value={"/queryContainerRelations"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<OrderContainerRelation> queryContainerRelations(HttpServletRequest request, Long orderId) {
        List relations = this.orderService.queryContainerRalation(orderId);
        for (OrderContainerRelation relation : relations) {
            try {
                relation.setExpressInfoUrl(this.orderService.queryExpressInfoUrl(relation));
                Order order = this.siteOrderService.getPayOrder(orderId);
                if (null == order.getOrderCode()) continue;
                LOGGER.info((Object)(LOGGERINFO6 + order.getOrderCode() + "\u3011\u7684\u7684\u5305\u88f9\uff01"));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u5305\u88f9\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return relations;
    }

    @RequestMapping(value={"/customer/queryContainerRelations"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<OrderContainerRelation> queryContainerRelation(HttpServletRequest request, Long orderId) {
        List relations = this.orderService.queryContainerRalation(orderId);
        for (OrderContainerRelation relation : relations) {
            try {
                relation.setExpressInfoUrl(this.orderService.queryExpressInfoUrl(relation));
                Order order = this.siteOrderService.getPayOrder(orderId);
                if (null == order.getOrderCode()) continue;
                LOGGER.info((Object)(LOGGERINFO6 + order.getOrderCode() + "\u3011\u7684\u7684\u5305\u88f9\uff01"));
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u8be2\u5305\u88f9\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return relations;
    }

    @RequestMapping(value={"/customer/deleteBackOrderById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteBackOrderById(HttpServletRequest request, Long backOrderId) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        return this.siteOrderService.deleteBackOrderById(backOrderId, customerId);
    }

    @RequestMapping(value={"/customer/timeBackOrderById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int timeBackOrderById(HttpServletRequest request, Long OrderId) {
        int time = 1;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Order order = this.orderService.getPayOrder(OrderId);
        SystemsSet systemsSet = this.isBackOrderService.getIsBackOrder();
        Long day = systemsSet.getLimitOrderTime();
        time = order.getGetGoodsTime() != null && new Date().getTime() - order.getGetGoodsTime().getTime() < day * 60L * 60L * 24L * 1000L ? 1 : 0;
        return time;
    }

    @RequestMapping(value={"/customer/selectBackOrderById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int selectBackOrderById(HttpServletRequest request, Long OrderId) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Order order = this.orderService.getPayOrder(OrderId);
        if ("1".equals(order.getOrderStatus())) {
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"/customer/deleteOrderById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteOrderById(HttpServletRequest request, Long orderId) {
        Order order;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        int count = 0;
        if (customerId != null && (order = this.siteOrderService.getPayOrder(orderId)) != null && order.getCustomerId().equals(customerId)) {
            count = this.orderService.deleteOrderById(orderId);
        }
        return count;
    }

    public void jumpLogin(HttpServletRequest request, ModelAndView mav, String url) {
        mav.setView((View)new RedirectView("/customer/login.html"));
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute("cust") != null;
    }

    public OrderCouponService getOrderCouponService() {
        return this.orderCouponService;
    }

    @Resource(name="OrderCouponService")
    public void setOrderCouponService(OrderCouponService orderCouponService) {
        this.orderCouponService = orderCouponService;
    }

    public CouponService getCouponService() {
        return this.couponService;
    }

    @Resource(name="CouponService")
    public void setCouponService(CouponService couponService) {
        this.couponService = couponService;
    }

    public OrderComplainBackService getOrderComplainService() {
        return this.orderComplainService;
    }

    @Resource(name="orderComplainBackService")
    public void setOrderComplainService(OrderComplainBackService orderComplainService) {
        this.orderComplainService = orderComplainService;
    }

    public EmailUtils getEmailUtils() {
        return this.emailUtils;
    }

    @Resource(name="emailUtils")
    public void setEmailUtils(EmailUtils emailUtils) {
        this.emailUtils = emailUtils;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public MegawizardService getMegawizardSerivce() {
        return this.megawizardSerivce;
    }

    @Resource(name="MegawizardService")
    public void setMegawizardSerivce(MegawizardService megawizardSerivce) {
        this.megawizardSerivce = megawizardSerivce;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }
}

