/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.customer.bean.InsideLetter;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.InsideLetterServiceMapper;
import com.qianjiang.customer.vo.InsideLetterVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsideLettersController {
    private static final MyLogger LOGGER = new MyLogger(InsideLettersController.class);
    private static final String LOGOERINFO = "\u3011-->\u7528\u6237\u540d\uff1a";
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    private InsideLetterServiceMapper insideLetterService;
    private CustomerServiceMapper customerServiceInterface;
    private TopAndBottomService topAndBottomService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/customer/insideletter"})
    public ModelAndView showInsideLetter(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = null;
        pb.setUrl("customer/insideletter");
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        HashMap<String, CustomerAllInfo> map = new HashMap<String, CustomerAllInfo>();
        try {
            if (this.checkLoginStatus(request)) {
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId"));
                customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint((Long)request.getSession().getAttribute("customerId") + "")));
                map.put("customer", customerAllInfo);
                resultMap.put("receiveCustomerId", (Long)request.getSession().getAttribute("customerId"));
                mav = new ModelAndView("customer/newinsideletter").addObject("pb", (Object)this.insideLetterService.queryInsideLetter(resultMap, pb));
                mav.addAllObjects(map);
            } else {
                mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/insideletter.html");
            }
            ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(mav);
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/customer/readletter"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int readedLetter(HttpServletRequest request, @Valid InsideLetterVo inside) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId != null) {
            CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
            inside.setCustomerId(customerId);
            if (null != inside.getLetterTitle()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u66f4\u6539\u7ad9\u5185\u4fe1\u72b6\u6001", (String)("\u66f4\u6539\u7ad9\u5185\u4fe1\u72b6\u6001-->\u7ad9\u5185\u4fe1\u6807\u9898\u3010" + inside.getLetterTitle() + LOGOERINFO + customerAllInfo.getCustomerUsername()));
                LOGGER.info((Object)("\u6807\u9898\u4e3a\u3010" + inside.getLetterTitle() + "\u3011\u7684\u7ad9\u5185\u4fe1\u6807\u8bb0\u5df2\u8bfb\uff01"));
            }
            return this.insideLetterService.readedLetter(inside);
        }
        return 0;
    }

    @RequestMapping(value={"/customer/letterisread"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int letterIsRead(HttpServletRequest request, Long letterId) {
        InsideLetter insideLetter = this.insideLetterService.selectByPrimaryKey(letterId);
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customer = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (null != insideLetter.getLetterTitle()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customer.getCustomerUsername(), (String)"\u66f4\u6539\u7ad9\u5185\u4fe1\u72b6\u6001", (String)("\u66f4\u6539\u7ad9\u5185\u4fe1\u72b6\u6001-->\u7ad9\u5185\u4fe1\u6807\u9898\u3010" + insideLetter.getLetterTitle() + LOGOERINFO + customer.getCustomerUsername()));
            LOGGER.info((Object)("\u5224\u65ad\u6807\u9898\u4e3a\u3010" + insideLetter.getLetterTitle() + "\u3011\u7684\u7ad9\u5185\u4fe1\u662f\u5426\u5df2\u8bfb\uff01"));
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("customerId", customerId);
        resultMap.put("letterId", letterId);
        return Integer.parseInt(this.insideLetterService.letterIsRead(resultMap) + "");
    }

    @RequestMapping(value={"/customer/deleteletterno"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteLetter(HttpServletRequest request, InsideLetterVo inside) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customer = this.customerServiceInterface.selectByPrimaryKey(customerId);
        inside.setCustomerId(customerId);
        int result = this.insideLetterService.deleteLetterNo(inside);
        if (null != inside.getLetterTitle() && 1 == result) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customer.getCustomerUsername(), (String)"\u672a\u8bfb\u7ad9\u5185\u4fe1\u5220\u9664", (String)("\u672a\u8bfb\u7ad9\u5185\u4fe1\u5220\u9664-->\u7ad9\u5185\u4fe1\u6807\u9898\u3010" + inside.getLetterTitle() + LOGOERINFO + customer.getCustomerUsername()));
            LOGGER.info((Object)("\u5220\u9664\u6807\u9898\u4e3a\u3010" + inside.getLetterTitle() + "\u3011\u7684\u7ad9\u5185\u4fe1\u6210\u529f\uff01"));
        }
        return result;
    }

    @RequestMapping(value={"/customer/deleteletter"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteLetter(HttpServletRequest request, Long relaId, Long letterId) {
        InsideLetter insideLetter = this.insideLetterService.selectByPrimaryKey(letterId);
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customer = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (null != insideLetter.getLetterTitle()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customer.getCustomerUsername(), (String)"\u7ad9\u5185\u4fe1\u5220\u9664", (String)("\u7ad9\u5185\u4fe1\u5220\u9664-->\u7ad9\u5185\u4fe1\u6807\u9898\u3010" + insideLetter.getLetterTitle() + LOGOERINFO + customer.getCustomerUsername()));
            LOGGER.info((Object)("\u5220\u9664\u6807\u9898\u4e3a\u3010" + insideLetter.getLetterTitle() + "\u3011\u7684\u7ad9\u5185\u4fe1\u6210\u529f\uff01"));
        }
        return this.insideLetterService.deleteLetter(relaId);
    }

    @RequestMapping(value={"/customer/deletebylcid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteByLetterIdCustId(HttpServletRequest request, Long letterId) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        Long customerId = null;
        customerId = (Long)request.getSession().getAttribute("customerId");
        InsideLetter insideLetter = this.insideLetterService.selectByPrimaryKey(letterId);
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        resultMap.put("customerId", customerId);
        resultMap.put("letterId", letterId);
        int count = Integer.parseInt(this.insideLetterService.deleteByLetterIdCustId(resultMap) + "");
        if (1 == count && null != insideLetter.getLetterTitle() && null != customerAllInfo.getCustomerUsername()) {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u5220\u9664\u7ad9\u5185\u4fe1", (String)("\u5220\u9664\u7ad9\u5185\u4fe1-->\u7ad9\u5185\u4fe1\u6807\u9898\u3010" + insideLetter.getLetterTitle() + LOGOERINFO + customerAllInfo.getCustomerUsername()));
            LOGGER.info((Object)("\u5220\u9664\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011,\u6807\u9898\u4e3a\u3010" + insideLetter.getLetterTitle() + "\u3011\u7684\u7ad9\u5185\u4fe1\uff01"));
        }
        return count;
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute("cust") != null;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }

    public InsideLetterServiceMapper getInsideLetterService() {
        return this.insideLetterService;
    }

    @Resource(name="insideLetterServiceMapper")
    public void setInsideLetterService(InsideLetterServiceMapper insideLetterService) {
        this.insideLetterService = insideLetterService;
    }
}

