/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.controller;

import com.qianjiang.common.util.BaseSiteController;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.service.TradeService;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.PageBean;
import com.qianjiang.utils.SecurityUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DepositController
extends BaseSiteController {
    @Resource(name="customerService")
    private CustomerService customerService;
    @Autowired
    TopAndBottomService topAndBottomService;
    @Autowired
    private DepositService depositService;
    @Autowired
    private TradeService tradeService;
    @Autowired
    private CustomerServiceMapper customerServiceInterface;

    @RequestMapping(value={"/depositlist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Deposit> depositList(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return null;
        }
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("customerId", customerId);
        List result = this.depositService.depositList(paramMap);
        return result;
    }

    @RequestMapping(value={"/deposit/mydeposit"})
    public ModelAndView myDeposit(HttpServletRequest request, PageBean pb) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            ModelAndView mav = new ModelAndView("/login/redirect");
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        String time = request.getParameter("time") == null ? "" : request.getParameter("time");
        String type = request.getParameter("type") == null ? "" : request.getParameter("type");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", customerId);
        Deposit deposit = this.depositService.getDeposit(paramMap);
        paramMap.put("time", time);
        String[][] types = new String[][]{{"0", "1"}, {"2", "3"}};
        if (!"0".equals(type) && !"1".equals(type)) {
            type = "";
        }
        if (StringUtils.isNumeric((CharSequence)type)) {
            paramMap.put("types", types[Integer.valueOf(type)]);
        }
        PageBean pageBean = this.tradeService.pageTrade(paramMap, pb);
        pageBean.setUrl("customer/mydeposit");
        ModelAndView mav = new ModelAndView("deposit/mydeposit");
        mav.addObject("customerId", (Object)customerId);
        mav.addObject("deposit", (Object)deposit);
        mav.addObject("pwdExist", (Object)StringUtils.isNotBlank((CharSequence)deposit.getPayPassword()));
        mav.addObject("pb", (Object)pageBean);
        mav.addObject("type", (Object)type);
        mav.addObject("time", (Object)time);
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/changepaypasswordview"})
    public ModelAndView changePayPasswordView(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            ModelAndView mav = new ModelAndView("/login/redirect");
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        ModelAndView mav = new ModelAndView("deposit/setPasswordStep1");
        mav.addObject("customer", (Object)this.customerServiceInterface.queryCustomerById(customerId));
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/sendvalidatecode"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendValidateCode(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(customerId);
        String mobile = customer.getInfoMobile();
        CustomerAllInfo user = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (user == null) {
            return -1;
        }
        int result = this.customerServiceInterface.sendPost(user.getInfoMobile()).getResult();
        return result;
    }

    @RequestMapping(value={"/deposit/validatecode"})
    public ModelAndView validateCode(HttpServletRequest request, String code) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            mav = new ModelAndView("/login/redirect");
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        int result = this.customerServiceInterface.getMCode(request, code);
        if (result == 1) {
            mav = new ModelAndView("deposit/setPasswordStep2");
            request.getSession().setAttribute("mobileCode", (Object)code);
        } else {
            mav = new ModelAndView("deposit/setPasswordStep1");
            mav.addObject("msg", (Object)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            mav.addObject("retcode", (Object)"-1");
            mav.addObject("customer", (Object)this.customerServiceInterface.queryCustomerById(customerId));
        }
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/resetpaypwd"})
    public ModelAndView resetPwd(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            ModelAndView mav = new ModelAndView("/login/redirect");
            return this.withTopAndBottom(mav);
        }
        ModelAndView mav = null;
        String code = (String)request.getSession().getAttribute("mobileCode");
        if (StringUtils.isBlank((CharSequence)code)) {
            mav = new ModelAndView("deposit/setPasswordStep1");
            mav.addObject("customer", (Object)this.customerServiceInterface.queryCustomerById(customerId));
            return this.withTopAndBottom(mav);
        }
        mav = new ModelAndView("deposit/setPasswordStep3");
        String password = request.getParameter("password");
        String repassword = request.getParameter("repassword");
        if (StringUtils.isBlank((CharSequence)password)) {
            mav.addObject("msg", (Object)"\u5bc6\u7801\u4e3a\u7a7a");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        if (StringUtils.isBlank((CharSequence)repassword)) {
            mav.addObject("msg", (Object)"\u786e\u8ba4\u5bc6\u7801\u4e3a\u7a7a");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)repassword)) {
            mav.addObject("msg", (Object)"\u4e24\u6b21\u5bc6\u7801\u4e0d\u4e00\u81f4");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customerId", customerId);
        CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(customerId);
        String encodePwd = SecurityUtil.getStoreLogpwd((String)customer.getUniqueCode(), (String)password, (String)customer.getSaltVal());
        params.put("payPassword", encodePwd);
        int result = this.depositService.resetPayPassword(params);
        if (result == 1) {
            mav.addObject("msg", (Object)"\u606d\u559c\u60a8\uff0c\u5bc6\u7801\u91cd\u7f6e\u6210\u529f\uff01");
            mav.addObject("retcode", (Object)"1");
        } else {
            mav.addObject("retcode", (Object)"-1");
        }
        request.getSession().removeAttribute("mobileCode");
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/setpaypasswordview"})
    public ModelAndView setPayPasswordView(HttpServletRequest request) {
        ModelAndView mav = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            mav = new ModelAndView("/login/redirect");
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        mav = new ModelAndView("deposit/setPayPassword");
        mav.addObject("customer", (Object)this.customerServiceInterface.queryCustomerById(customerId));
        return this.withTopAndBottom(mav);
    }

    @RequestMapping(value={"/deposit/setpaypassword"})
    public ModelAndView setPayPassword(HttpServletRequest request, HttpServletResponse response) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            ModelAndView mav = new ModelAndView("/login/redirect");
            return this.withTopAndBottom(mav);
        }
        CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(customerId);
        ModelAndView mav = new ModelAndView("deposit/setPayPassword");
        mav.addObject("customer", (Object)customer);
        String password = request.getParameter("password");
        String newpassword = request.getParameter("newpassword");
        if (StringUtils.isBlank((CharSequence)password)) {
            mav.addObject("msg", (Object)"\u5bc6\u7801\u4e3a\u7a7a");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        if (StringUtils.isBlank((CharSequence)newpassword)) {
            mav.addObject("msg", (Object)"\u786e\u8ba4\u5bc6\u7801\u4e3a\u7a7a");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        String code = request.getParameter("mobileCode");
        if (StringUtils.isBlank((CharSequence)code)) {
            mav.addObject("msg", (Object)"\u8bf7\u586b\u5199\u9a8c\u8bc1\u7801");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        int val = this.customerServiceInterface.getMCode(request, code);
        if (val != 1) {
            mav.addObject("msg", (Object)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            mav.addObject("retcode", (Object)"-1");
            return this.withTopAndBottom(mav);
        }
        mav.setViewName("deposit/setPayPassword_result");
        int result = this.customerService.modifyPayPassword(response, customerId.longValue(), password, newpassword);
        if (result == 1) {
            mav.addObject("msg", (Object)"\u606d\u559c\u60a8\uff0c\u5bc6\u7801\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.addObject("retcode", (Object)"1");
        } else {
            mav.addObject("msg", (Object)"\u5f88\u62b1\u6b49\uff0c\u5bc6\u7801\u8bbe\u7f6e\u5931\u8d25\uff01");
            mav.addObject("retcode", (Object)"-1");
        }
        return this.withTopAndBottom(mav);
    }

    private ModelAndView withTopAndBottom(ModelAndView mav) {
        return this.topAndBottomService.getTopAndBottom(mav);
    }
}

