/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.express;

import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.freight.service.FreightTemplateService;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsGroupReleProductVo;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExpressTemplateController {
    private static final MyLogger LOGGER = new MyLogger(ExpressTemplateController.class);
    @Resource(name="FreightTemplateService")
    private FreightTemplateService freightTemplateService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="ShoppingCartService1")
    private com.qianjiang.site.shoppingcart.service.ShoppingCartService shoppingCartService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Autowired
    private ShoppingCartService shoppingCartServices;

    @RequestMapping(value={"/getexpressprice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getExpressPrice(Long addressId, HttpServletRequest request, Long distributionId) {
        String thirdId = request.getParameter("thirdIds");
        String cartId = request.getParameter("cartIds");
        String[] thirdIds = thirdId.split(",");
        String[] cartIds = cartId.split(",");
        CustomerAddress ca = this.customerServiceInterface.queryCustAddress(addressId);
        if (ca == null) {
            return "0";
        }
        BigDecimal price = new BigDecimal(0);
        for (int i = 0; i < thirdIds.length; ++i) {
            if (thirdIds[i] == null || "".equals(thirdIds[i])) continue;
            String s = cartIds[i];
            ArrayList<Long> shopIds = new ArrayList<Long>();
            String[] ids = s.split("-");
            if (ids != null && ids.length != 0) {
                for (String id : ids) {
                    shopIds.add(Integer.valueOf(id).longValue());
                }
            }
            Long[] box = new Long[shopIds.size()];
            for (int j = 0; j < shopIds.size(); ++j) {
                box[j] = (Long)shopIds.get(j);
            }
            List shlist = this.shoppingCartService.searchByProduct(request, box);
            BigDecimal weight = new BigDecimal(0);
            Integer nums = 0;
            if (shlist != null && !shlist.isEmpty()) {
                for (com.qianjiang.site.shoppingcart.bean.ShoppingCart sc : shlist) {
                    if (sc.getFitId() == null) {
                        GoodsProductVo goodsProduct = this.goodsProductService.queryByPrimaryId(sc.getGoodsInfoId());
                        if (goodsProduct == null || !"0".equals(goodsProduct.getIsMailBay())) continue;
                        weight = weight.add(goodsProduct.getGoodsInfoWeight().multiply(new BigDecimal(sc.getGoodsNum())));
                        nums = nums + Integer.parseInt(sc.getGoodsNum().toString());
                        continue;
                    }
                    GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(sc.getFitId());
                    for (int j = 0; j < goodsGroupVo.getProductList().size(); ++j) {
                        weight = weight.add(((GoodsGroupReleProductVo)goodsGroupVo.getProductList().get(j)).getProductDetail().getGoodsInfoWeight().multiply(new BigDecimal(sc.getGoodsNum())));
                        nums = nums + Integer.parseInt(sc.getGoodsNum().toString());
                    }
                }
            }
            price = price.add(this.freightTemplateService.getExpressPrice(distributionId, ca.getCity().getCityId(), Long.valueOf(thirdIds[i]), nums, weight));
        }
        return price.toString();
    }

    @RequestMapping(value={"/getnewexpressprice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getnewexpressprice(HttpServletRequest request, Long addressId, String shopIds) {
        Map result = null;
        try {
            String[] shopCartIds = shopIds.split(",");
            if (null == addressId || null == shopCartIds || shopCartIds.length <= 0 || "".equals(shopCartIds[0])) {
                return result;
            }
            CustomerAddress ca = this.customerServiceInterface.queryCustAddress(addressId);
            if (ca == null) {
                return result;
            }
            Long[] cartIds = new Long[shopCartIds.length];
            if (shopCartIds != null && shopCartIds.length != 0) {
                for (int i = 0; i < shopCartIds.length; ++i) {
                    cartIds[i] = Long.valueOf(shopCartIds[i]);
                }
            }
            if (shopCartIds != null && shopCartIds.length != 0) {
                result = this.shoppingCartService.getNewExpressPrice(request, ca.getDistrict().getDistrictId(), ca.getCity().getCityId(), cartIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8ba2\u5355\u786e\u8ba4\u9875\u8ba1\u7b97\u8fd0\u8d39\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getnewbarterexpressprice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getnewbarterexpressprice(HttpServletRequest request, Long addressId, String goodsInfoIds, String goodsInfoNums, String kuaidiPrice) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (null == addressId) {
                return result;
            }
            CustomerAddress ca = this.customerServiceInterface.queryCustAddress(addressId);
            if (ca == null) {
                return result;
            }
            String[] goodsInfoId = goodsInfoIds.split(",");
            String[] goodsInfoNum = goodsInfoNums.split(",");
            ArrayList<ShoppingCart> shoppingCartList = new ArrayList<ShoppingCart>();
            ShoppingCart shoppingCart = new ShoppingCart();
            for (int i = 0; i < goodsInfoId.length; ++i) {
                shoppingCart.setGoodsInfoId(Long.valueOf(Long.parseLong(goodsInfoId[i])));
                shoppingCart.setGoodsNum(Long.valueOf(Long.parseLong(goodsInfoNum[i])));
                shoppingCart.setThirdId(Long.valueOf(0L));
            }
            shoppingCartList.add(shoppingCart);
            BigDecimal expressPrice = this.shoppingCartServices.calExpressPriceByThirdId(Long.valueOf(0L), ca.getCity().getCityId(), shoppingCartList);
            System.out.println("!!!!!!!!!!!\u6839\u636e\u7528\u6237\u9ed8\u8ba4\u5730\u5740\u53d6\u51fa\u9ed8\u8ba4\u5730\u533a\u7684\u8fd0\u8d39\uff1a" + expressPrice);
            result.put("expressPrice", expressPrice);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8ba2\u5355\u786e\u8ba4\u9875\u8ba1\u7b97\u8fd0\u8d39\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

