/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.returns.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderGoodsService;
import com.qianjiang.order.service.OrderMService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.orderbartergoods.model.OrderBarterGoods;
import com.qianjiang.orderbartergoods.service.OrderBarterGoodsService;
import com.qianjiang.orderrepaircost.model.RepairCost;
import com.qianjiang.orderrepaircost.service.RepairCostService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.GoodsBean;
import com.qianjiang.other.bean.OrderInfoBean;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.service.IsBackOrderService;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ReturnGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ReturnGoodsController.class);
    private static final String LOGGERINFO1 = "\u3011-->\u7528\u6237\u540d\uff1a";
    private static final String ORDER = "order";
    private static final String BACKORDER = "backorder";
    private ReturnGoodsService goodsService;
    private TopAndBottomService topAndBottomService;
    private SiteOrderService siteOrderService;
    private BackOrderService backOrderService;
    private OrderService orderService;
    private BackOrderLogService backOrderLogService;
    private IsBackOrderService isbackOrderService;
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Autowired
    private OrderBarterGoodsService orderBarterGoodsService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Autowired
    private OrderGoodsService orderGoodsService;
    @Autowired
    private RepairCostService repairCostService;
    @Autowired
    private OrderMService orderMService;

    @RequestMapping(value={"/saveBackOrderGeneral"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveBackOrderGeneral(HttpServletRequest request, String wlname, String wlno, String orderNo) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (null != orderNo) {
            LOGGER.info((Object)"\u65b0\u589e\u4e00\u6761\u9000\u8d27\u7684\u7269\u6d41\u4fe1\u606f");
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u5355\u7269\u6d41\u4fe1\u606f", (String)("\u65b0\u589e\u9000\u5355\u7269\u6d41\u4fe1\u606f-->\u9700\u8981\u6267\u884c\u9000\u5355\u64cd\u4f5c\u7684\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011,\u7269\u6d41\u4fe1\u606f\uff1a\u540d\u79f0\u3010" + wlname + "\u3011,\u7269\u6d41\u5355\u53f7\u3010" + wlno + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
        }
        return this.goodsService.saveBackOrderGeneral(wlname, wlno, orderNo);
    }

    @RequestMapping(value={"/saveReturnGoodsTake"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveReturnGoodsTake(HttpServletRequest request, HttpServletResponse response, Long orderId, String returnyuanyin, String tuikuanyuanyin) throws Exception {
        String returnyuanyinNew = returnyuanyin;
        Boolean bool = true;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        String tuikuanyuanyin1 = tuikuanyuanyin;
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (null != tuikuanyuanyin1) {
            bool = this.goodsService.saveReturnGoodsDetail(orderId, tuikuanyuanyin1 = URLDecoder.decode(tuikuanyuanyin1, "utf-8"), Long.valueOf(0L));
            if (bool.booleanValue()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55", (String)("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55-->\u9000\u6b3e\u539f\u56e0\u3010" + tuikuanyuanyin + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
            }
        } else {
            bool = this.goodsService.saveReturnGoodsDetail(orderId, returnyuanyinNew = URLDecoder.decode(returnyuanyinNew, "utf-8"), Long.valueOf(1L));
            if (bool.booleanValue()) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u5355\u8bb0\u5f55", (String)("\u65b0\u589e\u9000\u5355\u8bb0\u5f55-->\u9000\u5355\u539f\u56e0\u3010" + returnyuanyinNew + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
            }
        }
        if (bool.booleanValue()) {
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"customer/applybackmoneyprice"})
    public ModelAndView applybackmoneyprice(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        Order order = this.siteOrderService.getPayOrder(orderId);
        mav = new ModelAndView("customer/applybackmoneyprice");
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        OrderInfoBean backorder = this.customerServiceInterface.queryOrderByCustIdAndOrderId(orderId, customerId);
        String str = "";
        for (int i = 0; i < backorder.getGoods().size(); ++i) {
            Long goodsids = ((GoodsBean)backorder.getGoods().get(i)).getGoodsId();
            Long goodsNum = ((GoodsBean)backorder.getGoods().get(i)).getGoodsNum();
            str = str + goodsids + "," + goodsNum + "-";
        }
        SystemsSet systemsSet = this.isbackOrderService.getIsBackOrder();
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("backPriceRemark", (Object)systemsSet.getBackPriceRemark()).addObject("backGoodsIdAndSum", (Object)str);
    }

    @RequestMapping(value={"customer/applybackmoney"})
    public ModelAndView applyBackMoney(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        Order order = this.siteOrderService.getPayOrder(orderId);
        mav = new ModelAndView("customer/applybackmoney");
        BigDecimal price = new BigDecimal(0);
        String staCheck = "0";
        String isUseCoupon = "0";
        if (!"0.00".equals(order.getOrderPrePrice().toString()) || order.getOrderIntegral() != null && order.getOrderIntegral() > 0L) {
            price = order.getOrderPrice().subtract(order.getExpressPrice());
            int calcPrice = price.intValue();
            if (calcPrice < 0) {
                price = new BigDecimal(0.01);
            }
            staCheck = "1";
        }
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        OrderInfoBean backorder = this.customerServiceInterface.queryOrderByCustIdAndOrderId(orderId, customerId);
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < backorder.getGoods().size(); ++i) {
            total = ((GoodsBean)backorder.getGoods().get(i)).getGoodsCouponPrice() == null ? total.add(((GoodsBean)backorder.getGoods().get(i)).getGoodsInfoSumPrice()) : total.add(((GoodsBean)backorder.getGoods().get(i)).getGoodsInfoSumPrice()).subtract(((GoodsBean)backorder.getGoods().get(i)).getGoodsCouponPrice());
        }
        ArrayList<GoodsBean> goodsBeanList = new ArrayList<GoodsBean>();
        GoodsBean goodsBean = new GoodsBean();
        for (GoodsBean iterable_element : backorder.getGoods()) {
            if (iterable_element.getGoodsNum() - iterable_element.getBackGoodsNum() <= 0L) continue;
            iterable_element.setGoodsNum(Long.valueOf(iterable_element.getGoodsNum() - iterable_element.getBackGoodsNum()));
            goodsBeanList.add(iterable_element);
        }
        backorder.getGoods().clear();
        backorder.setGoods(goodsBeanList);
        for (int i = 0; i < backorder.getGoods().size(); ++i) {
            GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(((GoodsBean)backorder.getGoods().get(i)).getGoodsId());
            List<String> goodsInfoItems = Arrays.asList(((GoodsBean)backorder.getGoods().get(i)).getGoodsInfoItemNoS().split(","));
            if (((GoodsBean)backorder.getGoods().get(i)).getBackGoodsInfoItemNoS() != null && !"".equals(((GoodsBean)backorder.getGoods().get(i)).getBackGoodsInfoItemNoS())) {
                List<String> backGoodsInfoItemS = Arrays.asList(((GoodsBean)backorder.getGoods().get(i)).getBackGoodsInfoItemNoS().split(","));
                String goodsInfoItemS = "";
                if (backGoodsInfoItemS.size() != 0) {
                    for (String string : goodsInfoItems) {
                        if (backGoodsInfoItemS.contains(string)) continue;
                        goodsInfoItemS = goodsInfoItemS + string + ",";
                    }
                }
                ((GoodsBean)backorder.getGoods().get(i)).setGoodsInfoItemNoS(goodsInfoItemS.length() == 0 ? goodsInfoItemS : goodsInfoItemS.substring(0, goodsInfoItemS.length() - 1));
            }
            ((GoodsBean)backorder.getGoods().get(i)).setSpecVo((List)JSON.parseObject((String)JSON.toJSONString((Object)goodsProductDetailViewVo.getSpecVo()), List.class));
        }
        Map map = this.isbackOrderService.queryBackInfoRemark();
        String backInfoRemark = (String)map.get("queryBackInfoRemark");
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById(customerId);
        customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "")));
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("backInfoRemark", (Object)backInfoRemark).addObject("price", (Object)price).addObject("staCheck", (Object)staCheck).addObject("cusId", (Object)customerId).addObject("isUseCoupon", (Object)isUseCoupon).addObject("customer", (Object)customerAllInfo);
    }

    @RequestMapping(value={"customer/backdetailprice"})
    public ModelAndView backDetailInfoprice(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        mav = new ModelAndView("customer/backdetailprice");
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        Order order = this.siteOrderService.queryOrderDetailByIds(orderId, customerId);
        if (order == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        Order backorder = this.orderService.getPayOrder(orderId);
        BackOrder bOrder = this.backOrderService.queryBackOrderByOrderCodeAndIsback(backorder.getOrderCode(), "2");
        ArrayList<String> imglist = null;
        if (bOrder.getUploadDocuments() != null && !"".equals(bOrder.getUploadDocuments())) {
            imglist = new ArrayList<String>();
            String[] imgs = bOrder.getUploadDocuments().split(",");
            for (int i = 0; i < imgs.length; ++i) {
                imglist.add(imgs[i]);
            }
        }
        List backOrderLogs = this.backOrderLogService.queryByBackId(bOrder.getBackOrderId());
        return this.topAndBottomService.getTopAndBottom(mav).addObject(ORDER, (Object)order).addObject(BACKORDER, (Object)backorder).addObject("bOrder", (Object)bOrder).addObject("imglist", imglist).addObject("backOrderLogs", (Object)backOrderLogs);
    }

    @RequestMapping(value={"customer/backdetail"})
    public ModelAndView backDetailInfo(HttpServletRequest request, Long orderId) {
        String[] goods;
        ModelAndView mav = null;
        mav = new ModelAndView("customer/backdetail");
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            return new ModelAndView((View)new RedirectView("/login.html"));
        }
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId"));
        customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint((Long)request.getSession().getAttribute("customerId") + "")));
        BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCodeAndIsback(orderId.toString(), "1");
        System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\u9000\u5355\u7f16\u53f7\u662f\uff1a" + backOrder.getBackOrderId());
        Order orders = this.orderMService.getPayOrderByCode(backOrder.getOrderCode());
        Order order = this.orderMService.getPayOrder(orders.getOrderId());
        List goodsProductAll = null;
        List orderBarterGoodsList = null;
        RepairCost repairCost = this.repairCostService.selectAllByBackOrderId(orderId);
        System.out.println("~~~~~~~~\u7ef4\u4fee\u8d39\u7528\u5b9e\u4f53" + repairCost);
        ArrayList<OrderGoods> orderGoodsList = new ArrayList<OrderGoods>();
        String[] goodsItemNoS = backOrder.getBackGoodsIdAndSum().split("-");
        for (int i = 0; i < goodsItemNoS.length; ++i) {
            Long orderGoodsId = Long.parseLong(goodsItemNoS[i].substring(goodsItemNoS[i].lastIndexOf(",") + 1));
            OrderGoods orderGoods = this.orderGoodsService.selectOrderGoodsByOGIds(orderGoodsId);
            orderGoodsList.add(orderGoods);
        }
        order.setOrderGoodsList(orderGoodsList);
        LOGGER.info((Object)("\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6240\u6709\u9000\u8d27\u5546\u54c1\uff1a" + order.getOrderGoodsList().toString()));
        BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(orders.getCustomerId());
        System.out.println("~~~~~~~~\u4f1a\u5458\u7b49\u7ea7\u6298\u6263\u7387~~~~~~~~~" + customerDiscount);
        if ("3".equals(backOrder.getIsBack()) || "3" == backOrder.getIsBack()) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("orderBarterId", backOrder.getBackOrderId());
            orderBarterGoodsList = this.orderBarterGoodsService.selectByOrderBarterIdAll(map);
            if (orderBarterGoodsList.size() > 0) {
                Long[] productGoodsIds = new Long[orderBarterGoodsList.size()];
                int index = 0;
                for (OrderBarterGoods orderBarterGoods : orderBarterGoodsList) {
                    productGoodsIds[index] = orderBarterGoods.getGoodsInfoId();
                    ++index;
                }
                List<Long> list = Arrays.asList(productGoodsIds);
                goodsProductAll = this.goodsProductService.selectAllShoppingByProId(list);
            }
        }
        String backStr = backOrder.getBackGoodsIdAndSum();
        ArrayList<Long> orderGoodIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)backStr) && (goods = backStr.split("-")).length > 0) {
            for (int i = 0; i < goods.length; ++i) {
                if (goods[i].indexOf(",") == goods[i].lastIndexOf(",")) continue;
                orderGoodIds.add(Long.valueOf(goods[i].substring(goods[i].lastIndexOf(",") + 1, goods[i].length())));
            }
        }
        LOGGER.info((Object)("\u6240\u6709\u9000\u8d27\u5546\u54c1id\u96c6\u5408\uff1a" + ((Object)orderGoodIds).toString()));
        if (null != order && CollectionUtils.isNotEmpty((Collection)order.getOrderGoodsList())) {
            for (int i = 0; i < order.getOrderGoodsList().size(); ++i) {
                OrderGoods og = (OrderGoods)order.getOrderGoodsList().get(i);
                if (orderGoodIds.contains(og.getOrderGoodsId())) continue;
                order.getOrderGoodsList().remove(i);
                --i;
            }
        }
        LOGGER.info((Object)("\u90e8\u5206\u9000\u8d27\u5546\u54c1\u96c6\u5408:" + order.getOrderGoodsList().toString()));
        ArrayList<String> imglist = null;
        if (backOrder != null && backOrder.getUploadDocuments() != null && !"".equals(backOrder.getUploadDocuments())) {
            imglist = new ArrayList<String>();
            String[] imgs = backOrder.getUploadDocuments().split(",");
            for (int i = 0; i < imgs.length; ++i) {
                imglist.add(imgs[i]);
            }
        }
        BackOrderGeneral general = this.backOrderService.queryBackOrderGeneral(backOrder.getBackOrderId());
        System.out.println("~~~~~~\u9000\u6362\u8d27\u7269\u6d41\u5b9e\u4f53" + general);
        List backOrderLogs = this.backOrderLogService.queryByBackId(backOrder.getBackOrderId());
        String[] backGoodsIdAndSum = backOrder.getBackGoodsIdAndSum().split("-");
        for (int i = 0; i < order.getOrderGoodsList().size(); ++i) {
            ((OrderGoods)order.getOrderGoodsList().get(i)).setGoodsInfoPriceBuy(((OrderGoods)order.getOrderGoodsList().get(i)).getGoodsInfoNum().toString());
            ((OrderGoods)order.getOrderGoodsList().get(i)).setGoodsInfoNum(Long.valueOf(Long.parseLong(backGoodsIdAndSum[i].substring(backGoodsIdAndSum[i].indexOf(",") + 1, backGoodsIdAndSum[i].lastIndexOf(",")))));
        }
        request.getSession().removeAttribute("customerDiscount");
        mav.addObject(ORDER, (Object)order);
        mav.addObject("backOrder", (Object)backOrder);
        request.getSession().removeAttribute("repairCost");
        mav.addObject("repairCost", (Object)repairCost);
        mav.addObject("backOrderLogs", (Object)backOrderLogs);
        mav.addObject("general", (Object)general);
        mav.addObject("imglist", imglist);
        mav.addObject("customer", (Object)customerAllInfo);
        mav.addObject("customerDiscount", (Object)customerDiscount);
        mav.addObject("goodsProductAll", (Object)goodsProductAll);
        mav.addObject("orderBarterGoodsList", (Object)orderBarterGoodsList);
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    private void removeOrderList(List<OrderGoods> orderGoodses, String acutalId) {
        List<Long> ids = this.getActalIds(acutalId);
        List<Long> orderGoodsIds = this.getOrderGoodsIds(acutalId);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ArrayList<OrderGoods> removeOrderGoods = new ArrayList<OrderGoods>();
        for (OrderGoods orderGoods : orderGoodses) {
            if (orderGoodsIds.contains(orderGoods.getOrderGoodsId())) continue;
            removeOrderGoods.add(orderGoods);
        }
        orderGoodses.removeAll(removeOrderGoods);
    }

    private List<Long> getActalIds(String acutalId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String[] idAndSums;
            for (String idAndSum : idAndSums = acutalId.split("-")) {
                if (!StringUtils.isNotEmpty((String)idAndSum)) continue;
                String[] id = idAndSum.split(",");
                ids.add(Long.parseLong(id[0]));
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error("GetActalIds fail...");
            return ids;
        }
    }

    private List<Long> getOrderGoodsIds(String acutalId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String[] idAndSums;
            for (String idAndSum : idAndSums = acutalId.split("-")) {
                if (!StringUtils.isNotEmpty((String)idAndSum)) continue;
                String[] id = idAndSum.split(",");
                ids.add(Long.parseLong(id[2]));
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error("getOrderGoodsIds fail...");
            return ids;
        }
    }

    public ReturnGoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="ReturnGoodsService")
    public void setGoodsService(ReturnGoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public SiteOrderService getSiteOrderService() {
        return this.siteOrderService;
    }

    public IsBackOrderService getIsbackOrderService() {
        return this.isbackOrderService;
    }

    @Resource(name="IsBackOrderService")
    public void setIsbackOrderService(IsBackOrderService isbackOrderService) {
        this.isbackOrderService = isbackOrderService;
    }

    public BackOrderLogService getBackOrderLogService() {
        return this.backOrderLogService;
    }

    @Resource(name="BackOrderLogService")
    public void setBackOrderLogService(BackOrderLogService backOrderLogService) {
        this.backOrderLogService = backOrderLogService;
    }

    @Resource(name="SiteOrderService")
    public void setSiteOrderService(SiteOrderService siteOrderService) {
        this.siteOrderService = siteOrderService;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }
}

