/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.third.goods.service.ThirdWarnGoodService;
import com.qianjiang.third.goods.util.ThirdGoodsSearchBean;
import com.qianjiang.third.goods.vo.StockWarningVo;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.PageBean;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdWarnGoodController {
    private static final MyLogger LOGGER = new MyLogger(ThirdWarnGoodController.class);
    private static final String THIRDID = "thirdId";
    private ThirdWarnGoodService thirdWarnGoodService;

    public ThirdWarnGoodService getThirdWarnGoodService() {
        return this.thirdWarnGoodService;
    }

    @Resource(name="ThirdWarnGoodService")
    public void setThirdWarnGoodService(ThirdWarnGoodService thirdWarnGoodService) {
        this.thirdWarnGoodService = thirdWarnGoodService;
    }

    @RequestMapping(value={"/selectstock"})
    public ModelAndView selectstock(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        StockWarningVo stockWarningVo = this.thirdWarnGoodService.selectstock((Long)request.getSession().getAttribute(THIRDID));
        return new ModelAndView("goods/thirdwarngoods").addObject("warnstock", (Object)stockWarningVo);
    }

    @RequestMapping(value={"/updatestockgoods"})
    public ModelAndView updatestockgoods(StockWarningVo stockWarningVo, HttpServletRequest request, String n, String l) {
        Customer cust;
        Long storeId = (Long)request.getSession().getAttribute(THIRDID);
        stockWarningVo.setStoreid(storeId);
        this.thirdWarnGoodService.updatestockgoods(stockWarningVo);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u5546\u54c1\u9884\u8b66\u503c", "\u4fee\u6539\u5546\u54c1\u9884\u8b66\u503c-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u4fee\u6539\u5546\u54c1\u9884\u8b66\u503c");
        }
        return new ModelAndView((View)new RedirectView("selectstock.htm"));
    }

    @RequestMapping(value={"/selectwarngoods"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView selectwarngoods(StockWarningVo stockWarningVo, PageBean pb, String n, String l, HttpServletRequest request, ThirdGoodsSearchBean searchBean) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pb.setUrl("selectwarngoods.htm");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("searchBean", searchBean);
        map.put("flag", 2);
        map.put("stock", stockWarningVo.getStock());
        pb.setUrl("selectwarngoods.htm");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        stockWarningVo.setThirdid(thirdId);
        return new ModelAndView("goods/thirdwarning").addObject("pb", (Object)this.thirdWarnGoodService.selectwarngoods(stockWarningVo, pb)).addObject("stockWarningVo", (Object)stockWarningVo).addObject("map", map);
    }

    @RequestMapping(value={"/updatewarnstock"})
    public ModelAndView updatewarnstock(StockWarningVo stockWarningVo, HttpServletRequest request, String n, String l) {
        Customer cust;
        stockWarningVo.setThirdid((Long)request.getSession().getAttribute(THIRDID));
        this.thirdWarnGoodService.updatewarnstock(stockWarningVo);
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u66f4\u65b0\u8d27\u54c1\u9884\u8b66\u4fe1\u606f", "\u66f4\u65b0\u8d27\u54c1\u9884\u8b66\u4fe1\u606f-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u66f4\u65b0\u8d27\u54c1\u9884\u8b66\u4fe1\u606f");
        }
        return new ModelAndView((View)new RedirectView("selectwarngoods.htm"));
    }
}

