/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempStoreyTagController {
    private static final MyLogger LOGGER = new MyLogger(ThirdTempStoreyTagController.class);
    private static final String LIST_ACTION = "queryThirdTempStoreyTagByPageBean.htm";
    private static final String SHOW_ACTION = "showThirdTempStoreyTag.htm";
    private static final String LOGINUSERID = "loginUserId";
    private static final String REDIRECT = "?storeyId=";
    @Resource(name="ChannelStoreyService")
    private ChannelStoreyService channelStoreyService;
    @Resource(name="ChannelStoreyTagService")
    private ChannelStoreyTagService channelStoreyTagService;

    @RequestMapping(value={"/queryThirdTempStoreyTagByPageBean"})
    public ModelAndView queryThirdTempStoreyTagByPageBean(PageBean pb, Long storeyId, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelStorey", this.channelStoreyService.getChannelStoreyById(storeyId));
        pb.setUrl(LIST_ACTION);
        map.put("pb", this.channelStoreyTagService.selectchannelStoreyTagByParam(pb, storeyId, null, null));
        return new ModelAndView("temp/temp_storeytag_list", "map", map);
    }

    @RequestMapping(value={"/showThirdTempStoreyTag"})
    public ModelAndView showThirdTempStoreyTag(Long tagId, Long storeyId) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelStorey", channelStorey);
        if (null != tagId) {
            ChannelStoreyTag channelStoreyTag = this.channelStoreyTagService.getChannelStoreyTagById(tagId);
            map.put("channelStoreyTag", channelStoreyTag);
        }
        return new ModelAndView("temp/show_temp_storeytag", "map", map);
    }

    @RequestMapping(value={"/getChannelStoreyTagById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStoreyTag getChannelStoreyTagById(Long storeyTagId) {
        return this.channelStoreyTagService.getChannelStoreyTagById(storeyTagId);
    }

    @RequestMapping(value={"/createThirdTempStoreyTag"})
    public ModelAndView createThirdTempStoreyTag(HttpServletRequest request, HttpServletResponse response, ChannelStoreyTag channelStoreyTag, Long storeyId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStoreyTag.setCreateUserId(loginUserId);
            int n = this.channelStoreyTagService.saveChannelStoreyTag(channelStoreyTag);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
                mav.setView((View)new RedirectView("queryThirdTempStoreyTagByPageBean.htm?storeyId=" + storeyId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/updateThirdTempStoreyTag"})
    public ModelAndView updateThirdTempStoreyTag(HttpServletRequest request, HttpServletResponse response, ChannelStoreyTag channelStoreyTag, Long storeyId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStoreyTag.setUpdateUserId(loginUserId);
            int n = this.channelStoreyTagService.updateChannelStoreyTag(channelStoreyTag);
            if (n > 0) {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
                mav.setView((View)new RedirectView("queryThirdTempStoreyTagByPageBean.htm?storeyId=" + storeyId));
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteThirdTempStoreyTag"})
    public ModelAndView deleteThirdTempStoreyTag(HttpServletRequest request, Long[] tagIds, Long storeyId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < tagIds.length; ++i) {
            this.channelStoreyTagService.deleteChannelStoreyTag(tagIds[i], loginUserId);
        }
        return new ModelAndView((View)new RedirectView("queryThirdTempStoreyTagByPageBean.htm?storeyId=" + storeyId));
    }
}

