/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.report.controller;

import com.qianjiang.report.bean.Report;
import com.qianjiang.report.service.ReportService;
import com.qianjiang.report.util.DateUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.PageBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ThirdReportController {
    @Resource(name="ReportService")
    private ReportService reportService;
    @Resource(name="auditService")
    private AuditService auditService;

    @RequestMapping(value={"queryCheckReport"})
    public ModelAndView queryCheckReport(Report report, String month, PageBean pb, HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        String endmonth = request.getParameter("endmonth");
        if (month != null && !"".equals(month)) {
            report.setStartDate(month + " 00:00:00");
        }
        if (endmonth != null && !"".equals(endmonth)) {
            report.setEndDate(endmonth + " 23:59:59");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        report.setStoreId((Long)request.getSession().getAttribute("thirdId"));
        map.put("pb", this.reportService.selectReportCateList(report, pb));
        map.put("report", report);
        map.put("month", month);
        map.put("endmonth", endmonth);
        return new ModelAndView("report/thirdreportlist").addObject("map", map);
    }

    @RequestMapping(value={"queryThirdReportBackOrderCate"})
    public ModelAndView queryThirdReportBackOrderCate(PageBean pb, Long storeId, String startTime, String endTime, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date starttime = sdf.parse(startTime);
        Date endtime = sdf.parse(endTime);
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("report/backthirdreportlist").addObject("pb", (Object)this.reportService.selectReportBackOrderCateList(storeId, starttime, endtime, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"queryThirdReportOrderCate"})
    public ModelAndView queryThirdReportOrderCate(PageBean pb, Long storeId, String startTime, String endTime, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date starttime = sdf.parse(startTime);
        Date endtime = sdf.parse(endTime);
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("report/orderthirdreportlist").addObject("pb", (Object)this.reportService.selectReportOrderCateList(storeId, starttime, endtime, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue).addObject("startTime", (Object)startTime).addObject("endTime", (Object)endTime).addObject("storeId", (Object)storeId);
    }

    @RequestMapping(value={"queryThirdReportOrderCateDetail"})
    public ModelAndView queryThirdReportOrderCateDetail(PageBean pb, Long storeId, Long orderId, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("report/orderthirdreportdetail").addObject("pb", (Object)this.reportService.selectReportOrderCateDdetailList(storeId, orderId, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"queryThirdReportBackOrderCateDetail"})
    public ModelAndView queryThirdReportBackOrderCateDetail(PageBean pb, Long storeId, Long orderId, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("report/backthirdreportdetail").addObject("pb", (Object)this.reportService.selectReportBackOrderCateDdetailList(storeId, orderId, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"thirdReportDetail"})
    public ModelAndView thirdReportDetail(Long reportId) {
        return new ModelAndView("report/thirdreportdetail").addObject("report", (Object)this.reportService.select(reportId));
    }

    @RequestMapping(value={"exportThirdReport"})
    public void exportThirdReport(Report report, String month, HttpServletRequest request, HttpServletResponse response) {
        if (month != null && !"".equals(month)) {
            report.setStartDate(month + "-01");
            report.setEndDate(DateUtil.getDateOfLastNMonth((String)(month + "-01"), (int)0));
        }
        report.setTimeType("1");
        report.setStoreId((Long)request.getSession().getAttribute("thirdId"));
        this.reportService.exportCateReport(report);
    }
}

