/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.template.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.freight.bean.FreightExpress;
import com.qianjiang.freight.bean.FreightTemplate;
import com.qianjiang.freight.service.FreightTemplateService;
import com.qianjiang.freight.service.SysCityService;
import com.qianjiang.freight.service.SysDistrictService;
import com.qianjiang.freight.service.SysProvinceService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.seller.bean.Express;
import com.qianjiang.third.seller.service.ExpressInfoService;
import com.qianjiang.third.util.MenuOperationUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class FreightTemplateThirdController {
    private static final Logger LOGGER = Logger.getLogger(FreightTemplateThirdController.class);
    private static final String THIRDID = "thirdId";
    private static final String FREIGHTTEMPLATELISTTHIRD_HTM = "freighttemplatelistthird.html";
    @Resource(name="FreightTemplateService")
    private FreightTemplateService freightTemplateService;
    @Resource(name="SysProvinceService")
    private SysProvinceService sysProvinceService;
    @Resource(name="SysCityService")
    private SysCityService sysCityService;
    @Resource(name="SysDistrictService")
    private SysDistrictService sysDistrictService;
    @Resource(name="expressInfoService")
    private ExpressInfoService expressInfoService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;

    @RequestMapping(value={"freighttemplatelistthird"})
    public ModelAndView searchAllTemplate(FreightTemplate freightTemplate, HttpServletRequest request, String n, String l) {
        freightTemplate.setFreightThirdId(Long.valueOf(request.getSession().getAttribute(THIRDID).toString()));
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        return new ModelAndView("freight/freightlist").addObject("list", (Object)this.freightTemplateService.searchAllTemplate(freightTemplate));
    }

    @RequestMapping(value={"copyfreighttemplatethird"})
    public ModelAndView copyFreightTemplate(HttpServletRequest request, Long freightTemplateId) {
        CustomerAllInfo customerAllInfo;
        FreightTemplate freightTemplate = this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId);
        this.freightTemplateService.copyFreightTemplate(freightTemplateId);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u590d\u5236\u7269\u6d41\u6a21\u677f", "\u590d\u5236\u7269\u6d41\u6a21\u677f\uff0c\u7269\u6d41\u6a21\u677f\u540d\u79f0\uff1a" + freightTemplate.getFreightTemplateName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u590d\u5236\u7269\u6d41\u6a21\u677f");
        }
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELISTTHIRD_HTM));
    }

    @RequestMapping(value={"deletefreighttemplatethird"})
    public ModelAndView deleteFreightTemplate(Long freightTemplateId, HttpServletRequest request, Long freightThirdId) {
        CustomerAllInfo customerAllInfo;
        Long freightThirdIdNew = freightThirdId;
        freightThirdIdNew = (Long)request.getSession().getAttribute(THIRDID);
        FreightTemplate freightTemplate = this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId);
        this.freightTemplateService.deleteFreightTemplate(freightTemplateId, freightThirdIdNew);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5220\u9664\u7269\u6d41\u6a21\u677f", "\u5220\u9664\u7269\u6d41\u6a21\u677f\uff0c\u7269\u6d41\u6a21\u677f\u540d\u79f0\uff1a" + freightTemplate.getFreightTemplateName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5220\u9664\u7269\u6d41\u6a21\u677f");
        }
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELISTTHIRD_HTM));
    }

    @RequestMapping(value={"defaultfreighttemplatethird"})
    public ModelAndView defaultFreightTemplate(HttpServletRequest request, FreightTemplate freightTemplate) {
        freightTemplate.setFreightThirdId(Long.valueOf(request.getSession().getAttribute(THIRDID).toString()));
        this.freightTemplateService.defaultFreightTemplate(freightTemplate);
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELISTTHIRD_HTM));
    }

    @RequestMapping(value={"toupdatefreighttemplatethird"})
    public ModelAndView toUpdateFreightTemplate(Long freightTemplateId, HttpServletRequest request) {
        Express expressmap = new Express();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        expressmap.setStoreId(thirdId);
        FreightTemplate ft = this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId);
        if (thirdId.equals(ft.getFreightThirdId())) {
            return new ModelAndView("freight/updatefreightlist").addObject("provinceList", (Object)this.sysProvinceService.selectAllProvince()).addObject("cityList", (Object)this.sysCityService.selectAllCityByProvinceId(ft.getFreightProvinceId())).addObject("districtList", (Object)this.sysDistrictService.selectAllDistrictByCityId(ft.getFreightCityId())).addObject("freightTemplate", (Object)ft).addObject("companylist", (Object)this.expressInfoService.selectByStoreIds(expressmap));
        }
        return new ModelAndView();
    }

    @RequestMapping(value={"savefreightthird"})
    public ModelAndView saveFreight(HttpServletRequest request, FreightTemplate freightTemplate) {
        CustomerAllInfo customerAllInfo;
        freightTemplate.setFreightThirdId(Long.valueOf(request.getSession().getAttribute(THIRDID).toString()));
        ConcurrentHashMap<String, Object> requestMap = new ConcurrentHashMap<String, Object>();
        requestMap.put("freightTemplateId", request.getParameter("freightTemplateId"));
        requestMap.put("logComId", request.getParameterValues("logComId"));
        requestMap.put(THIRDID, request.getSession().getAttribute(THIRDID));
        for (Object key : request.getParameterMap().keySet()) {
            requestMap.put(String.valueOf(key), request.getParameterMap().get(key));
        }
        this.freightTemplateService.saveFreight(requestMap, freightTemplate);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u7269\u6d41\u6a21\u677f", "\u4fee\u6539\u7269\u6d41\u6a21\u677f\uff0c\u7269\u6d41\u6a21\u677f\u540d\u79f0\uff1a-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u4fee\u6539\u7269\u6d41\u6a21\u677f");
        }
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELISTTHIRD_HTM));
    }

    @RequestMapping(value={"toAddFreightTemplatethird"})
    public ModelAndView toAddFreightTemplate(HttpServletRequest request) {
        Express expressmap = new Express();
        expressmap.setStoreId((Long)request.getSession().getAttribute(THIRDID));
        List expresss = this.expressInfoService.selectByStoreIds(expressmap);
        return new ModelAndView("freight/addfreightlist").addObject("provinceList", (Object)this.sysProvinceService.selectAllProvince()).addObject("companylist", (Object)expresss);
    }

    @RequestMapping(value={"addFreightthird"})
    public ModelAndView addFreight(HttpServletRequest request, FreightTemplate freightTemplate) throws UnsupportedEncodingException {
        CustomerAllInfo customerAllInfo;
        freightTemplate.setFreightThirdId(Long.valueOf(request.getSession().getAttribute(THIRDID).toString()));
        FreightExpress fe = this.freightTemplateService.selectFreightExpressByDistriThirdId(Long.valueOf(request.getSession().getAttribute(THIRDID).toString()));
        if (fe != null) {
            freightTemplate.setFreightIsDefault("0");
        } else {
            freightTemplate.setFreightIsDefault("1");
        }
        ConcurrentHashMap<String, Object> requestMap = new ConcurrentHashMap<String, Object>();
        requestMap.put("freightTemplateId", request.getParameter("freightTemplateId"));
        requestMap.put("logComId", request.getParameterValues("logComId"));
        requestMap.put(THIRDID, request.getSession().getAttribute(THIRDID));
        for (Object key : request.getParameterMap().keySet()) {
            requestMap.put(String.valueOf(key), request.getParameterMap().get(key));
        }
        this.freightTemplateService.addFreight(requestMap, freightTemplate);
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u65b0\u589e\u7269\u6d41\u6a21\u677f", "\u65b0\u589e\u7269\u6d41\u6a21\u677f\uff0c\u7269\u6d41\u6a21\u677f\u540d\u79f0\uff1a" + freightTemplate.getFreightTemplateName() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u65b0\u589e\u7269\u6d41\u6a21\u677f");
        }
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELISTTHIRD_HTM));
    }
}

