/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.index.controller;

import com.qianjiang.common.util.alipay.util.AlipayConfig;
import com.qianjiang.common.util.alipay.util.AlipaySubmit;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.BarterService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.PayService;
import com.qianjiang.third.auth.bean.CustomerConsume;
import com.qianjiang.third.auth.service.CustomerConsumeService;
import com.qianjiang.third.goods.service.ThirdGoodsService;
import com.qianjiang.third.order.service.ThirdOrderService;
import com.qianjiang.third.order.util.DaysOrderUtil;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UtilDate;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class IndexController {
    private static final MyLogger LOGGER = new MyLogger(IndexController.class);
    private static final String OUT_TRADE_NO = "out_trade_no";
    private static final String TRADE_STATUS = "trade_status";
    private static final String TRADE_SUCCESS_D = "TRADE_SUCCESS";
    private SellerService sellerService;
    private PromotionService marketingService;
    private OrderService orderService;
    private ThirdGoodsService goodsService;
    private ThirdOrderService thirdOrderService;
    private BackOrderService backOrderService;
    private BarterService barterService;
    private GoodsProductService goodsProductService;
    private CustomerConsumeService customerConsumeService;
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="payService")
    private PayService payService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/third/index"})
    public ModelAndView index(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        HashMap<String, DaysOrderUtil> resultMap = new HashMap<String, DaysOrderUtil>();
        Long storeId = (Long)request.getSession().getAttribute("thirdId");
        StoreInfo storeInfo = null;
        try {
            storeInfo = this.sellerService.selectByStoreId(storeId);
            resultMap.put("yesOrder", this.thirdOrderService.querySalesOrderCountByFlag(0, storeInfo.getStoreId()));
            resultMap.put("toOrder", this.thirdOrderService.querySalesOrderCountByFlag(1, storeInfo.getStoreId()));
            ModelAndView modelAndView = new ModelAndView("index/index").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/jumpindex"})
    public ModelAndView jumpIndex() {
        return new ModelAndView((View)new RedirectView("index"));
    }

    public SellerService getSellerService() {
        return this.sellerService;
    }

    @Resource(name="sellerService")
    public void setSellerService(SellerService sellerService) {
        this.sellerService = sellerService;
    }

    public PromotionService getMarketingService() {
        return this.marketingService;
    }

    @Resource(name="MarketingService")
    public void setMarketingService(PromotionService marketingService) {
        this.marketingService = marketingService;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public ThirdGoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="ThirdGoodsService")
    public void setGoodsService(ThirdGoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public ThirdOrderService getThirdOrderService() {
        return this.thirdOrderService;
    }

    @Resource(name="ThirdOrderService")
    public void setThirdOrderService(ThirdOrderService thirdOrderService) {
        this.thirdOrderService = thirdOrderService;
    }

    public BackOrderService getBackOrderService() {
        return this.backOrderService;
    }

    @Resource(name="BackOrderService")
    public void setBackOrderService(BackOrderService backOrderService) {
        this.backOrderService = backOrderService;
    }

    public BarterService getBarterService() {
        return this.barterService;
    }

    @Resource(name="barterService")
    public void setBarterService(BarterService barterService) {
        this.barterService = barterService;
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    public CustomerConsumeService getCustomerConsumeService() {
        return this.customerConsumeService;
    }

    @Resource(name="customerConsumeService")
    public void setCustomerConsumeService(CustomerConsumeService customerConsumeService) {
        this.customerConsumeService = customerConsumeService;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/jumpRecharge"})
    public ModelAndView jumpRecharge(HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long storeId = (Long)request.getSession().getAttribute("thirdId");
        StoreInfo storeInfo = null;
        try {
            storeInfo = this.sellerService.selectByStoreId(storeId);
            resultMap.put("paylist", this.payService.queryAllPaySet());
            resultMap.put("seller", storeInfo);
            ModelAndView modelAndView = new ModelAndView("index/recharge").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/recharge"})
    public void recharge(HttpServletRequest request, Long payId, BigDecimal price, HttpServletResponse response, Long customerId, Long storeId) throws UnsupportedEncodingException {
        Order order = new Order();
        String orderCode = UtilDate.mathString((Date)new Date());
        order.setOrderCode(orderCode);
        String orderOldCode = UtilDate.mathString((Date)new Date());
        order.setOrderOldCode(orderOldCode);
        order.setOrderPrice(price);
        order.setOrderOldPrice(price);
        order.setOrderPrePrice(BigDecimal.valueOf(0L));
        order.setOrderStatus("0");
        order.setCustomerId(customerId);
        order.setPayTime(new Date());
        order.setDelFlag("0");
        order.setPayId(payId);
        order.setBusinessId(storeId);
        order.setDealerType("0");
        order.setCreateTime(new Date());
        order.setOrderMType("0");
        order.setOrderLinePay("1");
        order.setExpressPrice(BigDecimal.valueOf(0L));
        Pay p = this.payService.findByPayId(payId);
        if (p != null) {
            AlipayConfig.partner = p.getApiKey();
            AlipayConfig.key = p.getSecretKey();
            String paymentType = "1";
            String notifyUrl = p.getPayUrl() + "third/thirdPaynotifysuccess.html";
            String returnUrl = p.getBackUrl();
            String sellerEmail = p.getPayAccount();
            String outTradeNo = orderCode;
            String subject = "\u7b2c\u4e09\u65b9\u5145\u503c";
            String totalFee = price + "";
            String showUrl = "";
            String antiPhishingKey = "";
            String exterInvokeIp = "";
            HashMap<String, String> sParaTemp = new HashMap<String, String>();
            sParaTemp.put("service", "create_direct_pay_by_user");
            sParaTemp.put("partner", AlipayConfig.partner);
            sParaTemp.put("_input_charset", AlipayConfig.input_charset);
            sParaTemp.put("payment_type", paymentType);
            sParaTemp.put("notify_url", notifyUrl);
            sParaTemp.put("return_url", returnUrl);
            sParaTemp.put("seller_email", sellerEmail);
            sParaTemp.put(OUT_TRADE_NO, outTradeNo);
            sParaTemp.put("subject", subject);
            sParaTemp.put("total_fee", totalFee);
            sParaTemp.put("body", subject);
            sParaTemp.put("show_url", showUrl);
            sParaTemp.put("anti_phishing_key", antiPhishingKey);
            sParaTemp.put("exter_invoke_ip", exterInvokeIp);
            String sHtmlText = AlipaySubmit.buildRequest(sParaTemp, (String)"post", (String)"\u786e\u8ba4");
            response.setContentType("text/html;charsetUTF-8");
            response.setCharacterEncoding("utf-8");
            try {
                response.getWriter().write(sHtmlText);
                LOGGER.info((Object)("\u7ed9\u8ba2\u5355\u53f7\u4e3a\uff1a\u3010" + orderCode + "\u3011\u7684\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f"));
                this.orderService.insertOrder(order);
            }
            catch (IOException e) {
                LOGGER.error("\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25" + e);
            }
        }
    }

    @RequestMapping(value={"/thirdPaysuccess"})
    public ModelAndView unionPaySuccess(HttpServletRequest req, HttpServletResponse resp) {
        try {
            req.setCharacterEncoding("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            LOGGER.error("\u652f\u4ed8\u524d\u53f0\u901a\u77e5\u9519\u8bef" + e1);
        }
        Map<String, String> respParam = IndexController.getAllRequestParam(req);
        if (TRADE_SUCCESS_D.equals(respParam.get(TRADE_STATUS))) {
            if (TRADE_SUCCESS_D.equals(respParam.get(TRADE_STATUS))) {
                String orderCode = respParam.get(OUT_TRADE_NO);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("orderCode", orderCode);
                return new ModelAndView("order/thirdpaysuccess");
            }
            try {
                resp.getWriter().write("\u4ea4\u6613\u5931\u8d25");
            }
            catch (IOException e) {
                LOGGER.error("\u652f\u4ed8\u56de\u8c03\u5931\u8d25" + e);
            }
            return null;
        }
        return null;
    }

    @RequestMapping(value={"/thirdPaynotifysuccess"})
    public void unionpayNotifySuccess(HttpServletRequest req, HttpServletResponse resp) {
        try {
            req.setCharacterEncoding("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u652f\u4ed8\u56de\u8c03\uff0c\u5b57\u7b26\u8f6c\u6362\u9519\u8bef" + e);
        }
        Map<String, String> respParam = IndexController.getAllRequestParam(req);
        if (TRADE_SUCCESS_D.equals(respParam.get(TRADE_STATUS))) {
            String orderCode = respParam.get(OUT_TRADE_NO);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("orderCode", orderCode);
            Order order = (Order)this.orderService.selectByParam(paramMap).get(0);
            String price = respParam.get("total_fee");
            CustomerConsume record = new CustomerConsume();
            record.setBalanceNum(BigDecimal.valueOf(Long.valueOf(price)));
            record.setBalanceRemark("\u7b2c\u4e09\u65b9\u5145\u503c");
            record.setBalanceType("2");
            record.setCreateTime(new Date());
            record.setCustomerId(order.getCustomerId());
            record.setDelFlag("0");
            record.setOrderNo(orderCode);
            record.setPayType("0");
            record.setIsSeller("1");
            this.customerConsumeService.saveConsume(record);
            order.setOrderStatus("11");
            this.thirdOrderService.updateThirdOrderByParam(order);
        }
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
            }
        }
        return res;
    }
}

