/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempBarController {
    private static final MyLogger LOGGER = new MyLogger(ThirdTempBarController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String THIRDID = "thirdId";
    private static final String SHOW_VIEW = "showThirdTempBar.htm?tempId=";
    private static final String LIST_VIEW = "queryThirdTempBarByPageBean.htm?tempId=";
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ChannelBarService")
    private ChannelBarService channelBarService;

    @RequestMapping(value={"/queryThirdTempBarByPageBean"})
    public ModelAndView queryThirdTempBarByPageBean(HttpServletRequest request, PageBean pb, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        return new ModelAndView("temp/temp_nav_list", "pb", (Object)this.channelBarService.selectChannelBarByParam(pb, null, tempId, thirdId.toString())).addObject("temp", (Object)temp);
    }

    @RequestMapping(value={"/showThirdTempBar"})
    public ModelAndView showThirdTempBar(HttpServletRequest request, Long barId, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        map.put("temp", temp);
        map.put(THIRDID, thirdId);
        if (null != barId) {
            ChannelBar channelBar = this.channelBarService.getChannelBarById(barId);
            map.put("channelBar", channelBar);
        }
        return new ModelAndView("temp/show_temp_nav", "map", map);
    }

    @RequestMapping(value={"/createThirdTempBar"})
    public ModelAndView createThirdTempBar(HttpServletRequest request, ChannelBar channelBar, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelBar.setInsertId(loginUserId);
            int n = this.channelBarService.saveChannelBar(channelBar);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
        }
        return mav;
    }

    @RequestMapping(value={"/updateThirdTempBar"})
    public ModelAndView updateThirdTempBar(HttpServletRequest request, ChannelBar channelBar, Long tempId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelBar.setModifyId(loginUserId);
            int n = this.channelBarService.updateChannelBar(channelBar);
            if (n > 0) {
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(LIST_VIEW + tempId));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_VIEW + tempId));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteThirdTempBar"})
    public ModelAndView deleteThirdTempBar(HttpServletRequest request, Long[] barIds, Long tempId) {
        for (int i = 0; i < barIds.length; ++i) {
            this.channelBarService.deleteChannelBar(barIds[i]);
        }
        return new ModelAndView((View)new RedirectView(LIST_VIEW + tempId));
    }
}

