/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.goods.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.third.goods.bean.SelectBean;
import com.qianjiang.third.goods.bean.ThirdCate;
import com.qianjiang.third.goods.service.ThirdCateService;
import com.qianjiang.third.goods.util.CookieUtil;
import com.qianjiang.third.goods.vo.ThirdCateVo;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.ResultData;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdCateController {
    private ThirdCateService thirdCateService;
    private static final MyLogger LOGGER = new MyLogger(ThirdCateController.class);
    @Autowired
    private GoodsService goodsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cateManager"})
    public ModelAndView cateManager(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        try {
            ModelAndView modelAndView = new ModelAndView("goods/thirdcate");
            return modelAndView;
        }
        finally {
            LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u524d\u5f80\u5206\u7c7b\u5217\u8868");
        }
    }

    @RequestMapping(value={"getAllThirdCateForList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryThirdCateForList(SelectBean selectBean, HttpServletRequest request) {
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>AJAX\u67e5\u8be2\u6240\u6709\u7684\u5206\u7c7b\u4fe1\u606fFor \u5217\u8868\u5c55\u793a");
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        return this.thirdCateService.getAllCalcThirdCate(selectBean, Long.valueOf(thirdId));
    }

    @RequestMapping(value={"/getAllThirdCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdCate> getAllThirdCate(HttpServletRequest request) {
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>AJAX\u67e5\u8be2\u6240\u6709\u7684\u5206\u7c7b\u4fe1\u606f");
        return this.thirdCateService.queryAllCate((Long)request.getSession().getAttribute("thirdId"));
    }

    @RequestMapping(value={"/saveThirdCate"})
    public ModelAndView saveThirdCate(ThirdCate cate, HttpServletRequest request, MultipartHttpServletRequest request2) {
        Customer cust;
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u4fdd\u5b58\u5206\u7c7b\u56fe\u7247");
        MultipartFile imageFile = request2.getFile("upCatImg");
        if (!imageFile.isEmpty()) {
            cate.setCatImg((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
        }
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        String storeName = (String)request.getSession().getAttribute("storeName");
        cate.setThirdId(thirdId);
        cate.setThirdName(storeName);
        this.filterXss(cate);
        this.thirdCateService.insertThirdCate(cate, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u5546\u54c1\u5206\u7c7b", "\u6dfb\u52a0\u5546\u54c1\u5206\u7c7b\uff0c\u5206\u7c7b\u540d\u79f0\u4e3a\uff1a" + cate.getCatName() + "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
            LOGGER.info((Object)"\u6dfb\u52a0\u5546\u54c1\u5206\u7c7b");
        }
        return new ModelAndView((View)new RedirectView("cateManager.htm"));
    }

    private void filterXss(ThirdCate cate) {
        if (null != cate) {
            cate.setCatName(this.stripXSS(cate.getCatName()));
            cate.setCatSeoTitle(this.stripXSS(cate.getCatSeoTitle()));
            cate.setCatSeoKeyword(this.stripXSS(cate.getCatSeoKeyword()));
            cate.setCatSeoDesc(this.stripXSS(cate.getCatSeoDesc()));
        }
    }

    private String stripXSS(String value) {
        String valueNew = value;
        if (null != valueNew) {
            valueNew = valueNew.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            valueNew = scriptPattern.matcher(valueNew).replaceAll("");
            scriptPattern = Pattern.compile("[%<>\"]+");
            valueNew = scriptPattern.matcher(valueNew).replaceAll("");
        }
        return valueNew;
    }

    @RequestMapping(value={"/delThirdCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String delThirdCate(HttpServletRequest request) {
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        try {
            String cateId = request.getParameter("cateId");
            if (!StringUtils.isEmpty((CharSequence)cateId)) {
                Customer cust;
                long delCateId = Long.valueOf(cateId);
                ThirdCateVo thirdCateVo = this.thirdCateService.queryThirdCateById(Long.valueOf(delCateId));
                this.thirdCateService.delThirdCateNew(Long.valueOf(delCateId), ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername(), (Long)request.getSession().getAttribute("thirdId"));
                if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u5220\u9664\u5546\u54c1\u5206\u7c7b", "\u5220\u9664\u5546\u54c1\u5206\u7c7b\uff0c\u5206\u7c7b\u540d\u79f0\u4e3a\uff1a" + thirdCateVo.getCatName() + "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                }
                LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5220\u9664\u5546\u5bb6\u5206\u7c7b\u4fe1\u606f");
                result.setStatus(ResultData.getSuccess());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5546\u54c1\u5206\u7c7b\u5f02\u5e38");
        }
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/batchDelThirdCate"})
    public ModelAndView batchDelThirdCate(Long[] thirdCateIds, HttpServletRequest request) {
        this.thirdCateService.batchDelThirdCate(thirdCateIds, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u6279\u91cf\u5220\u9664\u5546\u5bb6\u5206\u7c7b\u4fe1\u606f");
        return new ModelAndView((View)new RedirectView("cateManager.htm"));
    }

    @RequestMapping(value={"/updateThirdCate"})
    public ModelAndView updateThirdCate(ThirdCate cate, HttpServletRequest request, MultipartHttpServletRequest request2) {
        Customer cust;
        MultipartFile imageFile = request2.getFile("upCatImg");
        if (!imageFile.isEmpty()) {
            cate.setCatImg((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
        }
        cate.setThirdId((Long)request.getSession().getAttribute("thirdId"));
        this.filterXss(cate);
        ThirdCateVo thirdCateVo = this.thirdCateService.queryThirdCateById(cate.getCatId());
        if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u4fee\u6539\u5546\u54c1\u5206\u7c7b", "\u4fee\u6539\u5546\u54c1\u5206\u7c7b\uff0c\u539f\u5206\u7c7b\u540d\u79f0\u4e3a\uff1a" + thirdCateVo.getCatName() + "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
        }
        this.thirdCateService.updateThirdCate(cate, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u66f4\u65b0\u5546\u5bb6\u5206\u7c7b\u4fe1\u606f");
        return new ModelAndView((View)new RedirectView("cateManager.htm"));
    }

    @RequestMapping(value={"/fastUpdateThirdCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int fastUpdateThirdCate(ThirdCate cate, HttpServletRequest request) {
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5feb\u901f\u66f4\u65b0\u5546\u5bb6\u5206\u7c7b\u4fe1\u606f");
        this.filterXss(cate);
        return this.thirdCateService.updateThirdCate(cate, ((Customer)request.getSession().getAttribute("cust")).getCustomerUsername());
    }

    @RequestMapping(value={"/checkThirdCateName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkThirdCateName(String cateName, HttpServletRequest request) {
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u9a8c\u8bc1\u5206\u7c7b\u540d\u79f0\u662f\u5426\u53ef\u7528");
        return this.thirdCateService.queyCateByCateName(cateName, (Long)request.getSession().getAttribute("thirdId")) == null;
    }

    @RequestMapping(value={"/checkThirdCateDel"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkThirdDel(Long thirdCateId) {
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u9a8c\u8bc1\u5206\u7c7b\u662f\u5426\u53ef\u4ee5\u5220\u9664");
        return this.thirdCateService.checkDelWithCateId(thirdCateId);
    }

    @RequestMapping(value={"/queryThirdCateByCateId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ThirdCateVo queryThirdCateByCateId(Long catId) {
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u5206\u7c7b\u4fe1\u606f");
        return this.thirdCateService.queryThirdCateById(catId);
    }

    @RequestMapping(value={"/getCookieThirdCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdCate> getCookieThirdCate(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        return CookieUtil.takeFormCookie(request, response);
    }

    @RequestMapping(value={"/qureyGradeLastThitsCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdCate> queryGradeLastThirdCate(String cateName, HttpServletRequest request) {
        return this.thirdCateService.getThirdCateByCateNameAndGrade(cateName, (Long)request.getSession().getAttribute("thirdId"));
    }

    @RequestMapping(value={"/getThirdCateByParentCatId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdCate> getThirdCateByParentCatId(Long cateId, HttpServletRequest request) {
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        return this.thirdCateService.getThirdCateByParentId(cateId, Long.valueOf(thirdId));
    }

    @RequestMapping(value={"/getThirdCateByParentCatIdtwo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdCate> getThirdCateByParentCatIdtwo(HttpServletRequest request) {
        return this.thirdCateService.getThirdCateByParentIdtwo((Long)request.getSession().getAttribute("thirdId"));
    }

    @RequestMapping(value={"/clearThirdCateFromCookie"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean clearThirdCateFromCookie(HttpServletRequest request, HttpServletResponse response) {
        return CookieUtil.clearThirdCateFromCookie(request, response);
    }

    public ThirdCateService getThirdCateService() {
        return this.thirdCateService;
    }

    @Resource(name="ThirdCateService1")
    public void setThirdCateService(ThirdCateService thirdCateService) {
        this.thirdCateService = thirdCateService;
    }

    @RequestMapping(value={"/queryThirdSonCateByCateIdAndName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ThirdCate> queryThirdSonCateByCateIdAndName(HttpServletRequest request, Long catGrade, String thirdCateName, Long catParentId) {
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        return this.thirdCateService.queryThirdSonCateByCateIdAndName(catGrade, thirdCateName, Long.valueOf(thirdId), catParentId);
    }

    @RequestMapping(value={"/queryThirdAllCate"}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String queryThirdAllCate(HttpServletRequest request, ModelMap modelMap) {
        LOGGER.info((Object)"\u5f00\u59cb\u67e5\u8be2\u5546\u5bb6\u4e0b\u6240\u6709\u5546\u54c1\u5206\u7c7b");
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        try {
            List cateList;
            ArrayList cates = new ArrayList();
            ThirdCateVo allCate = this.thirdCateService.queryThirdCateById(Long.valueOf(0L));
            Customer customer = ThirdCateController.findCustomer(request);
            if (null != allCate) {
                HashMap<String, Object> all = new HashMap<String, Object>();
                all.put("catId", allCate.getCatId());
                all.put("catName", allCate.getCatName());
                all.put("catSort", allCate.getCatSort());
                all.put("iconCls", "icon-tree");
                all.put("endNode", Character.valueOf(allCate.getEndNode()));
                cates.add(all);
            }
            if (null != customer && null != customer.getThirdId() && null != (cateList = this.thirdCateService.queryThirdAllCate(customer.getThirdId().longValue())) && cateList.size() > 0) {
                for (ThirdCate cate : cateList) {
                    HashMap<String, Object> cateMap = new HashMap<String, Object>();
                    cateMap.put("catId", cate.getCatId());
                    cateMap.put("catName", cate.getCatName());
                    cateMap.put("catSort", cate.getCatSort());
                    cateMap.put("iconCls", "icon-tree");
                    cateMap.put("endNode", Character.valueOf(cate.getEndNode()));
                    cateMap.put("_parentId", cate.getCatParentId());
                    cates.add(cateMap);
                }
            }
            result.setRows(cates);
            result.setStatus(ResultData.getSuccess());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u5bb6\u4e0b\u6240\u6709\u5546\u54c1\u5206\u7c7b\u5f02\u5e38", (Throwable)e);
        }
        LOGGER.info((Object)"\u7ed3\u675f\u67e5\u8be2\u5546\u5bb6\u4e0b\u6240\u6709\u5546\u54c1\u5206\u7c7b");
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/querySupplierCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String querySupplierCate(HttpServletRequest request) {
        ResultData result = new ResultData();
        result.setStatus(ResultData.getError());
        String catName = request.getParameter("catName");
        String catId = request.getParameter("catId");
        Customer customer = ThirdCateController.findCustomer(request);
        if (null != customer && customer.getThirdId() != null && !StringUtils.isEmpty((CharSequence)catName)) {
            ThirdCate queryCate = new ThirdCate();
            queryCate.setCatName(catName);
            queryCate.setThirdId(customer.getThirdId());
            ThirdCate resultCat = this.thirdCateService.queryThirdCateByEntity(queryCate);
            if (resultCat != null && resultCat.getCatId() != null) {
                result.setStatus(ResultData.getSuccess());
                if (!StringUtils.isEmpty((CharSequence)catId)) {
                    System.out.println(resultCat.getCatId().toString());
                    if (catId.equals(resultCat.getCatId().toString())) {
                        result.setStatus(ResultData.getError());
                    }
                }
            }
        }
        return JSONObject.fromObject(result).toString();
    }

    @RequestMapping(value={"/queryGoodsByCateId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String queryGoodsByCateId(HttpServletRequest request) {
        ResultData result = new ResultData();
        try {
            int total;
            result.setStatus(ResultData.getSuccess());
            String cateId = request.getParameter("cateId");
            LOGGER.info((Object)("\u5f00\u59cb\u67e5\u8be2\u5206\u7c7bcateId[" + cateId + "]\u662f\u5426\u6709\u5546\u54c1"));
            Customer customer = ThirdCateController.findCustomer(request);
            if (!StringUtils.isEmpty((CharSequence)cateId) && null != customer && customer.getThirdId() != null && (total = this.goodsService.queryGoodsByCateId(Long.valueOf(cateId).longValue(), Long.valueOf(customer.getThirdId()).longValue())) < 1) {
                result.setStatus(ResultData.getError());
            }
            LOGGER.info((Object)("\u7ed3\u675f\u67e5\u8be2\u5206\u7c7bcateId[" + cateId + "]\u662f\u5426\u6709\u5546\u54c1"));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5206\u7c7b\u4e0b\u7684\u5546\u54c1\u6570\u5f02\u5e38", (Throwable)e);
        }
        return JSONObject.fromObject(result).toString();
    }

    private static final Customer findCustomer(HttpServletRequest request) {
        Customer customer = new Customer();
        long thirdId = (Long)request.getSession().getAttribute("thirdId");
        customer.setThirdId(Long.valueOf(thirdId));
        return customer;
    }
}

