/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.freight.controller;

import com.qianjiang.freight.bean.FreightTemplate;
import com.qianjiang.freight.service.FreightTemplateService;
import com.qianjiang.freight.service.SysCityService;
import com.qianjiang.freight.service.SysDistrictService;
import com.qianjiang.freight.service.SysLogisticsCompanyService;
import com.qianjiang.freight.service.SysProvinceService;
import com.qianjiang.util.MyLogger;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class FreightTemplateController {
    private static final MyLogger LOGGER = new MyLogger(FreightTemplateController.class);
    private static final String FREIGHTTEMPLATELIST_HTM = "freighttemplatelist.htm";
    @Resource(name="FreightTemplateService")
    private FreightTemplateService freightTemplateService;
    @Resource(name="SysLogisticsCompanyService")
    private SysLogisticsCompanyService sysLogisticsCompanyService;
    @Resource(name="SysProvinceService")
    private SysProvinceService sysProvinceService;
    @Resource(name="SysCityService")
    private SysCityService sysCityService;
    @Resource(name="SysDistrictService")
    private SysDistrictService sysDistrictService;

    @RequestMapping(value={"freighttemplatelist"})
    public ModelAndView searchAllTemplate(FreightTemplate freightTemplate, HttpServletRequest request) {
        freightTemplate.setFreightThirdId(Long.valueOf(0L));
        LOGGER.info((Object)"\u83b7\u53d6\u8fd0\u8d39\u6a21\u677f\u96c6\u5408");
        return new ModelAndView("jsp/freight/freightlist").addObject("list", (Object)this.freightTemplateService.searchAllTemplate(freightTemplate));
    }

    @RequestMapping(value={"freightTemp"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<FreightTemplate> queryTemplate() {
        return this.freightTemplateService.queryTemplate();
    }

    @RequestMapping(value={"copyfreighttemplate"})
    public ModelAndView copyFreightTemplate(Long freightTemplateId) {
        if (null != freightTemplateId && null != this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId).getFreightTemplateName()) {
            LOGGER.info((Object)("\u590d\u5236\u540d\u79f0\u4e3a\uff1a\u3010" + this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId).getFreightTemplateName() + "\u6a21\u677f"));
        }
        this.freightTemplateService.copyFreightTemplate(freightTemplateId);
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELIST_HTM));
    }

    @RequestMapping(value={"deletefreighttemplate"})
    public ModelAndView deleteFreightTemplate(Long freightTemplateId, Long freightThirdId) {
        if (null != freightTemplateId && null != this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId).getFreightTemplateName()) {
            LOGGER.info((Object)("\u5220\u9664\u540d\u79f0\u4e3a\uff1a\u3010" + this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId).getFreightTemplateName() + "\u3011\u6a21\u677f"));
        }
        this.freightTemplateService.deleteFreightTemplate(freightTemplateId, freightThirdId);
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELIST_HTM));
    }

    @RequestMapping(value={"defaultfreighttemplate"})
    public ModelAndView defaultFreightTemplate(FreightTemplate freightTemplate) {
        if (null != freightTemplate.getFreightTemplateName()) {
            LOGGER.info((Object)("\u8bbe\u7f6e\u540d\u79f0\u4e3a\uff1a\u3010" + freightTemplate.getFreightTemplateName() + "\u3011\u6a21\u677f"));
        }
        freightTemplate.setFreightThirdId(Long.valueOf(0L));
        this.freightTemplateService.defaultFreightTemplate(freightTemplate);
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELIST_HTM));
    }

    @RequestMapping(value={"toupdatefreighttemplate"})
    public ModelAndView toUpdateFreightTemplate(Long freightTemplateId, HttpServletRequest request) {
        FreightTemplate ft = this.freightTemplateService.selectFreightTemplateDetail(freightTemplateId);
        if (null != ft.getFreightTemplateName()) {
            LOGGER.info((Object)("\u67e5\u8be2\u540d\u79f0\u4e3a\uff1a\u3010" + ft.getFreightTemplateName() + "\u3011\u7684\u8be6\u7ec6\u4fe1\u606f"));
        }
        return new ModelAndView("jsp/freight/updatefreightlist").addObject("provinceList", (Object)this.sysProvinceService.selectAllProvince()).addObject("cityList", (Object)this.sysCityService.selectAllCityByProvinceId(ft.getFreightProvinceId())).addObject("districtList", (Object)this.sysDistrictService.selectAllDistrictByCityId(ft.getFreightCityId())).addObject("freightTemplate", (Object)ft).addObject("companylist", (Object)this.sysLogisticsCompanyService.selectAllCompnay());
    }

    @RequestMapping(value={"savefreight"})
    public ModelAndView saveFreight(HttpServletRequest request, FreightTemplate freightTemplate) {
        if (null != freightTemplate.getFreightTemplateName()) {
            LOGGER.info((Object)("\u4fee\u6539\u540d\u79f0\u4e3a\uff1a\u3010" + freightTemplate.getFreightTemplateName() + "\u3011\u7684\u6a21\u677f"));
        }
        ConcurrentHashMap<String, Object> requestMap = new ConcurrentHashMap<String, Object>();
        requestMap.put("thirdId", request.getSession().getAttribute("thirdId"));
        for (String key : request.getParameterMap().keySet()) {
            requestMap.put(key, request.getParameterMap().get(key));
        }
        requestMap.put("freightTemplateId", request.getParameter("freightTemplateId"));
        this.freightTemplateService.saveFreight(requestMap, freightTemplate);
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELIST_HTM));
    }

    @RequestMapping(value={"toAddFreightTemplate"})
    public ModelAndView toAddFreightTemplate(HttpServletRequest request) {
        return new ModelAndView("jsp/freight/addfreightlist").addObject("provinceList", (Object)this.sysProvinceService.selectAllProvince()).addObject("companylist", (Object)this.sysLogisticsCompanyService.selectAllCompnay());
    }

    @RequestMapping(value={"addFreight"})
    public ModelAndView addFreight(HttpServletRequest request, FreightTemplate freightTemplate) {
        if (null != freightTemplate.getFreightTemplateName()) {
            LOGGER.info((Object)("\u65b0\u589e\u540d\u79f0\u4e3a\uff1a\u3010" + freightTemplate.getFreightTemplateName() + "\u3011\u7684\u6a21\u677f"));
        }
        freightTemplate.setFreightThirdId(Long.valueOf(0L));
        ConcurrentHashMap<String, Object> requestMap = new ConcurrentHashMap<String, Object>();
        requestMap.put("thirdId", request.getSession().getAttribute("thirdId"));
        for (String key : request.getParameterMap().keySet()) {
            requestMap.put(key, request.getParameterMap().get(key));
        }
        requestMap.put("freightTemplateId", request.getParameter("freightTemplateId"));
        this.freightTemplateService.addFreight(requestMap, freightTemplate);
        return new ModelAndView((View)new RedirectView(FREIGHTTEMPLATELIST_HTM));
    }
}

